// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SnapshotCopyArgs extends com.pulumi.resources.ResourceArgs {

    public static final SnapshotCopyArgs Empty = new SnapshotCopyArgs();

    /**
     * Whether to copy existing tags. Defaults to `false`.
     * 
     */
    @Import(name="copyTags")
    private @Nullable Output<Boolean> copyTags;

    /**
     * @return Whether to copy existing tags. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> copyTags() {
        return Optional.ofNullable(this.copyTags);
    }

    /**
     * The Destination region to place snapshot copy.
     * 
     */
    @Import(name="destinationRegion")
    private @Nullable Output<String> destinationRegion;

    /**
     * @return The Destination region to place snapshot copy.
     * 
     */
    public Optional<Output<String>> destinationRegion() {
        return Optional.ofNullable(this.destinationRegion);
    }

    /**
     * KMS key ID.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return KMS key ID.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * The name of an option group to associate with the copy of the snapshot.
     * 
     */
    @Import(name="optionGroupName")
    private @Nullable Output<String> optionGroupName;

    /**
     * @return The name of an option group to associate with the copy of the snapshot.
     * 
     */
    public Optional<Output<String>> optionGroupName() {
        return Optional.ofNullable(this.optionGroupName);
    }

    /**
     * he URL that contains a Signature Version 4 signed request.
     * 
     */
    @Import(name="presignedUrl")
    private @Nullable Output<String> presignedUrl;

    /**
     * @return he URL that contains a Signature Version 4 signed request.
     * 
     */
    public Optional<Output<String>> presignedUrl() {
        return Optional.ofNullable(this.presignedUrl);
    }

    /**
     * Snapshot identifier of the source snapshot.
     * 
     */
    @Import(name="sourceDbSnapshotIdentifier", required=true)
    private Output<String> sourceDbSnapshotIdentifier;

    /**
     * @return Snapshot identifier of the source snapshot.
     * 
     */
    public Output<String> sourceDbSnapshotIdentifier() {
        return this.sourceDbSnapshotIdentifier;
    }

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The external custom Availability Zone.
     * 
     */
    @Import(name="targetCustomAvailabilityZone")
    private @Nullable Output<String> targetCustomAvailabilityZone;

    /**
     * @return The external custom Availability Zone.
     * 
     */
    public Optional<Output<String>> targetCustomAvailabilityZone() {
        return Optional.ofNullable(this.targetCustomAvailabilityZone);
    }

    /**
     * The Identifier for the snapshot.
     * 
     */
    @Import(name="targetDbSnapshotIdentifier", required=true)
    private Output<String> targetDbSnapshotIdentifier;

    /**
     * @return The Identifier for the snapshot.
     * 
     */
    public Output<String> targetDbSnapshotIdentifier() {
        return this.targetDbSnapshotIdentifier;
    }

    private SnapshotCopyArgs() {}

    private SnapshotCopyArgs(SnapshotCopyArgs $) {
        this.copyTags = $.copyTags;
        this.destinationRegion = $.destinationRegion;
        this.kmsKeyId = $.kmsKeyId;
        this.optionGroupName = $.optionGroupName;
        this.presignedUrl = $.presignedUrl;
        this.sourceDbSnapshotIdentifier = $.sourceDbSnapshotIdentifier;
        this.tags = $.tags;
        this.targetCustomAvailabilityZone = $.targetCustomAvailabilityZone;
        this.targetDbSnapshotIdentifier = $.targetDbSnapshotIdentifier;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SnapshotCopyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SnapshotCopyArgs $;

        public Builder() {
            $ = new SnapshotCopyArgs();
        }

        public Builder(SnapshotCopyArgs defaults) {
            $ = new SnapshotCopyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param copyTags Whether to copy existing tags. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder copyTags(@Nullable Output<Boolean> copyTags) {
            $.copyTags = copyTags;
            return this;
        }

        /**
         * @param copyTags Whether to copy existing tags. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder copyTags(Boolean copyTags) {
            return copyTags(Output.of(copyTags));
        }

        /**
         * @param destinationRegion The Destination region to place snapshot copy.
         * 
         * @return builder
         * 
         */
        public Builder destinationRegion(@Nullable Output<String> destinationRegion) {
            $.destinationRegion = destinationRegion;
            return this;
        }

        /**
         * @param destinationRegion The Destination region to place snapshot copy.
         * 
         * @return builder
         * 
         */
        public Builder destinationRegion(String destinationRegion) {
            return destinationRegion(Output.of(destinationRegion));
        }

        /**
         * @param kmsKeyId KMS key ID.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId KMS key ID.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param optionGroupName The name of an option group to associate with the copy of the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder optionGroupName(@Nullable Output<String> optionGroupName) {
            $.optionGroupName = optionGroupName;
            return this;
        }

        /**
         * @param optionGroupName The name of an option group to associate with the copy of the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder optionGroupName(String optionGroupName) {
            return optionGroupName(Output.of(optionGroupName));
        }

        /**
         * @param presignedUrl he URL that contains a Signature Version 4 signed request.
         * 
         * @return builder
         * 
         */
        public Builder presignedUrl(@Nullable Output<String> presignedUrl) {
            $.presignedUrl = presignedUrl;
            return this;
        }

        /**
         * @param presignedUrl he URL that contains a Signature Version 4 signed request.
         * 
         * @return builder
         * 
         */
        public Builder presignedUrl(String presignedUrl) {
            return presignedUrl(Output.of(presignedUrl));
        }

        /**
         * @param sourceDbSnapshotIdentifier Snapshot identifier of the source snapshot.
         * 
         * @return builder
         * 
         */
        public Builder sourceDbSnapshotIdentifier(Output<String> sourceDbSnapshotIdentifier) {
            $.sourceDbSnapshotIdentifier = sourceDbSnapshotIdentifier;
            return this;
        }

        /**
         * @param sourceDbSnapshotIdentifier Snapshot identifier of the source snapshot.
         * 
         * @return builder
         * 
         */
        public Builder sourceDbSnapshotIdentifier(String sourceDbSnapshotIdentifier) {
            return sourceDbSnapshotIdentifier(Output.of(sourceDbSnapshotIdentifier));
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param targetCustomAvailabilityZone The external custom Availability Zone.
         * 
         * @return builder
         * 
         */
        public Builder targetCustomAvailabilityZone(@Nullable Output<String> targetCustomAvailabilityZone) {
            $.targetCustomAvailabilityZone = targetCustomAvailabilityZone;
            return this;
        }

        /**
         * @param targetCustomAvailabilityZone The external custom Availability Zone.
         * 
         * @return builder
         * 
         */
        public Builder targetCustomAvailabilityZone(String targetCustomAvailabilityZone) {
            return targetCustomAvailabilityZone(Output.of(targetCustomAvailabilityZone));
        }

        /**
         * @param targetDbSnapshotIdentifier The Identifier for the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder targetDbSnapshotIdentifier(Output<String> targetDbSnapshotIdentifier) {
            $.targetDbSnapshotIdentifier = targetDbSnapshotIdentifier;
            return this;
        }

        /**
         * @param targetDbSnapshotIdentifier The Identifier for the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder targetDbSnapshotIdentifier(String targetDbSnapshotIdentifier) {
            return targetDbSnapshotIdentifier(Output.of(targetDbSnapshotIdentifier));
        }

        public SnapshotCopyArgs build() {
            $.sourceDbSnapshotIdentifier = Objects.requireNonNull($.sourceDbSnapshotIdentifier, "expected parameter 'sourceDbSnapshotIdentifier' to be non-null");
            $.targetDbSnapshotIdentifier = Objects.requireNonNull($.targetDbSnapshotIdentifier, "expected parameter 'targetDbSnapshotIdentifier' to be non-null");
            return $;
        }
    }

}
