// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.rds.RoleAssociationArgs;
import com.pulumi.aws.rds.inputs.RoleAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages an RDS DB Instance association with an IAM Role. Example use cases:
 * 
 * * [Amazon RDS Oracle integration with Amazon S3](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html)
 * * [Importing Amazon S3 Data into an RDS PostgreSQL DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PostgreSQL.S3Import.html)
 * 
 * &gt; To manage the RDS DB Instance IAM Role for [Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html), see the `aws.rds.Instance` resource `monitoring_role_arn` argument instead.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.RoleAssociation;
 * import com.pulumi.aws.rds.RoleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new RoleAssociation(&#34;example&#34;, RoleAssociationArgs.builder()        
 *             .dbInstanceIdentifier(aws_db_instance.example().identifier())
 *             .featureName(&#34;S3_INTEGRATION&#34;)
 *             .roleArn(aws_iam_role.example().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_db_instance_role_association` using the DB Instance Identifier and IAM Role ARN separated by a comma (`,`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:rds/roleAssociation:RoleAssociation example my-db-instance,arn:aws:iam::123456789012:role/my-role
 * ```
 * 
 */
@ResourceType(type="aws:rds/roleAssociation:RoleAssociation")
public class RoleAssociation extends com.pulumi.resources.CustomResource {
    /**
     * DB Instance Identifier to associate with the IAM Role.
     * 
     */
    @Export(name="dbInstanceIdentifier", refs={String.class}, tree="[0]")
    private Output<String> dbInstanceIdentifier;

    /**
     * @return DB Instance Identifier to associate with the IAM Role.
     * 
     */
    public Output<String> dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }
    /**
     * Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
     * 
     */
    @Export(name="featureName", refs={String.class}, tree="[0]")
    private Output<String> featureName;

    /**
     * @return Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
     * 
     */
    public Output<String> featureName() {
        return this.featureName;
    }
    /**
     * Amazon Resource Name (ARN) of the IAM Role to associate with the DB Instance.
     * 
     */
    @Export(name="roleArn", refs={String.class}, tree="[0]")
    private Output<String> roleArn;

    /**
     * @return Amazon Resource Name (ARN) of the IAM Role to associate with the DB Instance.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public RoleAssociation(String name) {
        this(name, RoleAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public RoleAssociation(String name, RoleAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public RoleAssociation(String name, RoleAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:rds/roleAssociation:RoleAssociation", name, args == null ? RoleAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private RoleAssociation(String name, Output<String> id, @Nullable RoleAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:rds/roleAssociation:RoleAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static RoleAssociation get(String name, Output<String> id, @Nullable RoleAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new RoleAssociation(name, id, state, options);
    }
}
