// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ProxyEndpointArgs extends com.pulumi.resources.ResourceArgs {

    public static final ProxyEndpointArgs Empty = new ProxyEndpointArgs();

    /**
     * The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can&#39;t end with a hyphen or contain two consecutive hyphens.
     * 
     */
    @Import(name="dbProxyEndpointName", required=true)
    private Output<String> dbProxyEndpointName;

    /**
     * @return The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can&#39;t end with a hyphen or contain two consecutive hyphens.
     * 
     */
    public Output<String> dbProxyEndpointName() {
        return this.dbProxyEndpointName;
    }

    /**
     * The name of the DB proxy associated with the DB proxy endpoint that you create.
     * 
     */
    @Import(name="dbProxyName", required=true)
    private Output<String> dbProxyName;

    /**
     * @return The name of the DB proxy associated with the DB proxy endpoint that you create.
     * 
     */
    public Output<String> dbProxyName() {
        return this.dbProxyName;
    }

    /**
     * A mapping of tags to assign to the resource.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A mapping of tags to assign to the resource.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
     * 
     */
    @Import(name="targetRole")
    private @Nullable Output<String> targetRole;

    /**
     * @return Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
     * 
     */
    public Optional<Output<String>> targetRole() {
        return Optional.ofNullable(this.targetRole);
    }

    /**
     * One or more VPC security group IDs to associate with the new proxy.
     * 
     */
    @Import(name="vpcSecurityGroupIds")
    private @Nullable Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return One or more VPC security group IDs to associate with the new proxy.
     * 
     */
    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    /**
     * One or more VPC subnet IDs to associate with the new proxy.
     * 
     */
    @Import(name="vpcSubnetIds", required=true)
    private Output<List<String>> vpcSubnetIds;

    /**
     * @return One or more VPC subnet IDs to associate with the new proxy.
     * 
     */
    public Output<List<String>> vpcSubnetIds() {
        return this.vpcSubnetIds;
    }

    private ProxyEndpointArgs() {}

    private ProxyEndpointArgs(ProxyEndpointArgs $) {
        this.dbProxyEndpointName = $.dbProxyEndpointName;
        this.dbProxyName = $.dbProxyName;
        this.tags = $.tags;
        this.targetRole = $.targetRole;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
        this.vpcSubnetIds = $.vpcSubnetIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ProxyEndpointArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ProxyEndpointArgs $;

        public Builder() {
            $ = new ProxyEndpointArgs();
        }

        public Builder(ProxyEndpointArgs defaults) {
            $ = new ProxyEndpointArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param dbProxyEndpointName The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can&#39;t end with a hyphen or contain two consecutive hyphens.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyEndpointName(Output<String> dbProxyEndpointName) {
            $.dbProxyEndpointName = dbProxyEndpointName;
            return this;
        }

        /**
         * @param dbProxyEndpointName The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can&#39;t end with a hyphen or contain two consecutive hyphens.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyEndpointName(String dbProxyEndpointName) {
            return dbProxyEndpointName(Output.of(dbProxyEndpointName));
        }

        /**
         * @param dbProxyName The name of the DB proxy associated with the DB proxy endpoint that you create.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyName(Output<String> dbProxyName) {
            $.dbProxyName = dbProxyName;
            return this;
        }

        /**
         * @param dbProxyName The name of the DB proxy associated with the DB proxy endpoint that you create.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyName(String dbProxyName) {
            return dbProxyName(Output.of(dbProxyName));
        }

        /**
         * @param tags A mapping of tags to assign to the resource.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A mapping of tags to assign to the resource.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param targetRole Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
         * 
         * @return builder
         * 
         */
        public Builder targetRole(@Nullable Output<String> targetRole) {
            $.targetRole = targetRole;
            return this;
        }

        /**
         * @param targetRole Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
         * 
         * @return builder
         * 
         */
        public Builder targetRole(String targetRole) {
            return targetRole(Output.of(targetRole));
        }

        /**
         * @param vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            $.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * @param vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(Output.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSubnetIds(Output<List<String>> vpcSubnetIds) {
            $.vpcSubnetIds = vpcSubnetIds;
            return this;
        }

        /**
         * @param vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSubnetIds(List<String> vpcSubnetIds) {
            return vpcSubnetIds(Output.of(vpcSubnetIds));
        }

        /**
         * @param vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSubnetIds(String... vpcSubnetIds) {
            return vpcSubnetIds(List.of(vpcSubnetIds));
        }

        public ProxyEndpointArgs build() {
            $.dbProxyEndpointName = Objects.requireNonNull($.dbProxyEndpointName, "expected parameter 'dbProxyEndpointName' to be non-null");
            $.dbProxyName = Objects.requireNonNull($.dbProxyName, "expected parameter 'dbProxyName' to be non-null");
            $.vpcSubnetIds = Objects.requireNonNull($.vpcSubnetIds, "expected parameter 'vpcSubnetIds' to be non-null");
            return $;
        }
    }

}
