// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class InstanceAutomatedBackupsReplicationArgs extends com.pulumi.resources.ResourceArgs {

    public static final InstanceAutomatedBackupsReplicationArgs Empty = new InstanceAutomatedBackupsReplicationArgs();

    /**
     * The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region, for example, `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region, for example, `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * A URL that contains a [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) signed request for the [`StartDBInstanceAutomatedBackupsReplication`](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstanceAutomatedBackupsReplication.html) action to be called in the AWS Region of the source DB instance.
     * 
     */
    @Import(name="preSignedUrl")
    private @Nullable Output<String> preSignedUrl;

    /**
     * @return A URL that contains a [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) signed request for the [`StartDBInstanceAutomatedBackupsReplication`](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstanceAutomatedBackupsReplication.html) action to be called in the AWS Region of the source DB instance.
     * 
     */
    public Optional<Output<String>> preSignedUrl() {
        return Optional.ofNullable(this.preSignedUrl);
    }

    /**
     * The retention period for the replicated automated backups, defaults to `7`.
     * 
     */
    @Import(name="retentionPeriod")
    private @Nullable Output<Integer> retentionPeriod;

    /**
     * @return The retention period for the replicated automated backups, defaults to `7`.
     * 
     */
    public Optional<Output<Integer>> retentionPeriod() {
        return Optional.ofNullable(this.retentionPeriod);
    }

    /**
     * The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
     * 
     */
    @Import(name="sourceDbInstanceArn", required=true)
    private Output<String> sourceDbInstanceArn;

    /**
     * @return The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
     * 
     */
    public Output<String> sourceDbInstanceArn() {
        return this.sourceDbInstanceArn;
    }

    private InstanceAutomatedBackupsReplicationArgs() {}

    private InstanceAutomatedBackupsReplicationArgs(InstanceAutomatedBackupsReplicationArgs $) {
        this.kmsKeyId = $.kmsKeyId;
        this.preSignedUrl = $.preSignedUrl;
        this.retentionPeriod = $.retentionPeriod;
        this.sourceDbInstanceArn = $.sourceDbInstanceArn;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(InstanceAutomatedBackupsReplicationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private InstanceAutomatedBackupsReplicationArgs $;

        public Builder() {
            $ = new InstanceAutomatedBackupsReplicationArgs();
        }

        public Builder(InstanceAutomatedBackupsReplicationArgs defaults) {
            $ = new InstanceAutomatedBackupsReplicationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param kmsKeyId The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region, for example, `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region, for example, `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param preSignedUrl A URL that contains a [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) signed request for the [`StartDBInstanceAutomatedBackupsReplication`](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstanceAutomatedBackupsReplication.html) action to be called in the AWS Region of the source DB instance.
         * 
         * @return builder
         * 
         */
        public Builder preSignedUrl(@Nullable Output<String> preSignedUrl) {
            $.preSignedUrl = preSignedUrl;
            return this;
        }

        /**
         * @param preSignedUrl A URL that contains a [Signature Version 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) signed request for the [`StartDBInstanceAutomatedBackupsReplication`](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstanceAutomatedBackupsReplication.html) action to be called in the AWS Region of the source DB instance.
         * 
         * @return builder
         * 
         */
        public Builder preSignedUrl(String preSignedUrl) {
            return preSignedUrl(Output.of(preSignedUrl));
        }

        /**
         * @param retentionPeriod The retention period for the replicated automated backups, defaults to `7`.
         * 
         * @return builder
         * 
         */
        public Builder retentionPeriod(@Nullable Output<Integer> retentionPeriod) {
            $.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * @param retentionPeriod The retention period for the replicated automated backups, defaults to `7`.
         * 
         * @return builder
         * 
         */
        public Builder retentionPeriod(Integer retentionPeriod) {
            return retentionPeriod(Output.of(retentionPeriod));
        }

        /**
         * @param sourceDbInstanceArn The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
         * 
         * @return builder
         * 
         */
        public Builder sourceDbInstanceArn(Output<String> sourceDbInstanceArn) {
            $.sourceDbInstanceArn = sourceDbInstanceArn;
            return this;
        }

        /**
         * @param sourceDbInstanceArn The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
         * 
         * @return builder
         * 
         */
        public Builder sourceDbInstanceArn(String sourceDbInstanceArn) {
            return sourceDbInstanceArn(Output.of(sourceDbInstanceArn));
        }

        public InstanceAutomatedBackupsReplicationArgs build() {
            $.sourceDbInstanceArn = Objects.requireNonNull($.sourceDbInstanceArn, "expected parameter 'sourceDbInstanceArn' to be non-null");
            return $;
        }
    }

}
