// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds;

import com.pulumi.aws.rds.inputs.ExportTaskTimeoutsArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ExportTaskArgs extends com.pulumi.resources.ResourceArgs {

    public static final ExportTaskArgs Empty = new ExportTaskArgs();

    /**
     * Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     * 
     */
    @Import(name="exportOnlies")
    private @Nullable Output<List<String>> exportOnlies;

    /**
     * @return Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     * 
     */
    public Optional<Output<List<String>>> exportOnlies() {
        return Optional.ofNullable(this.exportOnlies);
    }

    /**
     * Unique identifier for the snapshot export task.
     * 
     */
    @Import(name="exportTaskIdentifier", required=true)
    private Output<String> exportTaskIdentifier;

    /**
     * @return Unique identifier for the snapshot export task.
     * 
     */
    public Output<String> exportTaskIdentifier() {
        return this.exportTaskIdentifier;
    }

    /**
     * ARN of the IAM role to use for writing to the Amazon S3 bucket.
     * 
     */
    @Import(name="iamRoleArn", required=true)
    private Output<String> iamRoleArn;

    /**
     * @return ARN of the IAM role to use for writing to the Amazon S3 bucket.
     * 
     */
    public Output<String> iamRoleArn() {
        return this.iamRoleArn;
    }

    /**
     * ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
     * 
     */
    @Import(name="kmsKeyId", required=true)
    private Output<String> kmsKeyId;

    /**
     * @return ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
     * 
     */
    public Output<String> kmsKeyId() {
        return this.kmsKeyId;
    }

    /**
     * Name of the Amazon S3 bucket to export the snapshot to.
     * 
     */
    @Import(name="s3BucketName", required=true)
    private Output<String> s3BucketName;

    /**
     * @return Name of the Amazon S3 bucket to export the snapshot to.
     * 
     */
    public Output<String> s3BucketName() {
        return this.s3BucketName;
    }

    /**
     * Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     * 
     */
    @Import(name="s3Prefix")
    private @Nullable Output<String> s3Prefix;

    /**
     * @return Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     * 
     */
    public Optional<Output<String>> s3Prefix() {
        return Optional.ofNullable(this.s3Prefix);
    }

    /**
     * Amazon Resource Name (ARN) of the snapshot to export.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="sourceArn", required=true)
    private Output<String> sourceArn;

    /**
     * @return Amazon Resource Name (ARN) of the snapshot to export.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> sourceArn() {
        return this.sourceArn;
    }

    @Import(name="timeouts")
    private @Nullable Output<ExportTaskTimeoutsArgs> timeouts;

    public Optional<Output<ExportTaskTimeoutsArgs>> timeouts() {
        return Optional.ofNullable(this.timeouts);
    }

    private ExportTaskArgs() {}

    private ExportTaskArgs(ExportTaskArgs $) {
        this.exportOnlies = $.exportOnlies;
        this.exportTaskIdentifier = $.exportTaskIdentifier;
        this.iamRoleArn = $.iamRoleArn;
        this.kmsKeyId = $.kmsKeyId;
        this.s3BucketName = $.s3BucketName;
        this.s3Prefix = $.s3Prefix;
        this.sourceArn = $.sourceArn;
        this.timeouts = $.timeouts;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ExportTaskArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ExportTaskArgs $;

        public Builder() {
            $ = new ExportTaskArgs();
        }

        public Builder(ExportTaskArgs defaults) {
            $ = new ExportTaskArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param exportOnlies Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
         * 
         * @return builder
         * 
         */
        public Builder exportOnlies(@Nullable Output<List<String>> exportOnlies) {
            $.exportOnlies = exportOnlies;
            return this;
        }

        /**
         * @param exportOnlies Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
         * 
         * @return builder
         * 
         */
        public Builder exportOnlies(List<String> exportOnlies) {
            return exportOnlies(Output.of(exportOnlies));
        }

        /**
         * @param exportOnlies Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
         * 
         * @return builder
         * 
         */
        public Builder exportOnlies(String... exportOnlies) {
            return exportOnlies(List.of(exportOnlies));
        }

        /**
         * @param exportTaskIdentifier Unique identifier for the snapshot export task.
         * 
         * @return builder
         * 
         */
        public Builder exportTaskIdentifier(Output<String> exportTaskIdentifier) {
            $.exportTaskIdentifier = exportTaskIdentifier;
            return this;
        }

        /**
         * @param exportTaskIdentifier Unique identifier for the snapshot export task.
         * 
         * @return builder
         * 
         */
        public Builder exportTaskIdentifier(String exportTaskIdentifier) {
            return exportTaskIdentifier(Output.of(exportTaskIdentifier));
        }

        /**
         * @param iamRoleArn ARN of the IAM role to use for writing to the Amazon S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder iamRoleArn(Output<String> iamRoleArn) {
            $.iamRoleArn = iamRoleArn;
            return this;
        }

        /**
         * @param iamRoleArn ARN of the IAM role to use for writing to the Amazon S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder iamRoleArn(String iamRoleArn) {
            return iamRoleArn(Output.of(iamRoleArn));
        }

        /**
         * @param kmsKeyId ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param s3BucketName Name of the Amazon S3 bucket to export the snapshot to.
         * 
         * @return builder
         * 
         */
        public Builder s3BucketName(Output<String> s3BucketName) {
            $.s3BucketName = s3BucketName;
            return this;
        }

        /**
         * @param s3BucketName Name of the Amazon S3 bucket to export the snapshot to.
         * 
         * @return builder
         * 
         */
        public Builder s3BucketName(String s3BucketName) {
            return s3BucketName(Output.of(s3BucketName));
        }

        /**
         * @param s3Prefix Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
         * 
         * @return builder
         * 
         */
        public Builder s3Prefix(@Nullable Output<String> s3Prefix) {
            $.s3Prefix = s3Prefix;
            return this;
        }

        /**
         * @param s3Prefix Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
         * 
         * @return builder
         * 
         */
        public Builder s3Prefix(String s3Prefix) {
            return s3Prefix(Output.of(s3Prefix));
        }

        /**
         * @param sourceArn Amazon Resource Name (ARN) of the snapshot to export.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder sourceArn(Output<String> sourceArn) {
            $.sourceArn = sourceArn;
            return this;
        }

        /**
         * @param sourceArn Amazon Resource Name (ARN) of the snapshot to export.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder sourceArn(String sourceArn) {
            return sourceArn(Output.of(sourceArn));
        }

        public Builder timeouts(@Nullable Output<ExportTaskTimeoutsArgs> timeouts) {
            $.timeouts = timeouts;
            return this;
        }

        public Builder timeouts(ExportTaskTimeoutsArgs timeouts) {
            return timeouts(Output.of(timeouts));
        }

        public ExportTaskArgs build() {
            $.exportTaskIdentifier = Objects.requireNonNull($.exportTaskIdentifier, "expected parameter 'exportTaskIdentifier' to be non-null");
            $.iamRoleArn = Objects.requireNonNull($.iamRoleArn, "expected parameter 'iamRoleArn' to be non-null");
            $.kmsKeyId = Objects.requireNonNull($.kmsKeyId, "expected parameter 'kmsKeyId' to be non-null");
            $.s3BucketName = Objects.requireNonNull($.s3BucketName, "expected parameter 's3BucketName' to be non-null");
            $.sourceArn = Objects.requireNonNull($.sourceArn, "expected parameter 'sourceArn' to be non-null");
            return $;
        }
    }

}
