// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.rds.ExportTaskArgs;
import com.pulumi.aws.rds.inputs.ExportTaskState;
import com.pulumi.aws.rds.outputs.ExportTaskTimeouts;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS RDS (Relational Database) Export Task.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ExportTask;
 * import com.pulumi.aws.rds.ExportTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ExportTask(&#34;example&#34;, ExportTaskArgs.builder()        
 *             .exportTaskIdentifier(&#34;example&#34;)
 *             .sourceArn(aws_db_snapshot.example().db_snapshot_arn())
 *             .s3BucketName(aws_s3_bucket.example().id())
 *             .iamRoleArn(aws_iam_role.example().arn())
 *             .kmsKeyId(aws_kms_key.example().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Complete Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.rds.Snapshot;
 * import com.pulumi.aws.rds.SnapshotArgs;
 * import com.pulumi.aws.rds.ExportTask;
 * import com.pulumi.aws.rds.ExportTaskArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2(&#34;exampleBucketV2&#34;, BucketV2Args.builder()        
 *             .forceDestroy(true)
 *             .build());
 * 
 *         var exampleBucketAclV2 = new BucketAclV2(&#34;exampleBucketAclV2&#34;, BucketAclV2Args.builder()        
 *             .bucket(exampleBucketV2.id())
 *             .acl(&#34;private&#34;)
 *             .build());
 * 
 *         var exampleRole = new Role(&#34;exampleRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;Version&#34;, &#34;2012-10-17&#34;),
 *                     jsonProperty(&#34;Statement&#34;, jsonArray(jsonObject(
 *                         jsonProperty(&#34;Action&#34;, &#34;sts:AssumeRole&#34;),
 *                         jsonProperty(&#34;Effect&#34;, &#34;Allow&#34;),
 *                         jsonProperty(&#34;Sid&#34;, &#34;&#34;),
 *                         jsonProperty(&#34;Principal&#34;, jsonObject(
 *                             jsonProperty(&#34;Service&#34;, &#34;export.rds.amazonaws.com&#34;)
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 * 
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(            
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions(&#34;s3:ListAllMyBuckets&#34;)
 *                     .resources(&#34;*&#34;)
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions(                    
 *                         &#34;s3:GetBucketLocation&#34;,
 *                         &#34;s3:ListBucket&#34;)
 *                     .resources(exampleBucketV2.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions(                    
 *                         &#34;s3:GetObject&#34;,
 *                         &#34;s3:PutObject&#34;,
 *                         &#34;s3:DeleteObject&#34;)
 *                     .resources(exampleBucketV2.arn().applyValue(arn -&gt; String.format(&#34;%s/*&#34;, arn)))
 *                     .build())
 *             .build());
 * 
 *         var examplePolicy = new Policy(&#34;examplePolicy&#34;, PolicyArgs.builder()        
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(examplePolicyDocument -&gt; examplePolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
 *             .build());
 * 
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment(&#34;exampleRolePolicyAttachment&#34;, RolePolicyAttachmentArgs.builder()        
 *             .role(exampleRole.name())
 *             .policyArn(examplePolicy.arn())
 *             .build());
 * 
 *         var exampleKey = new Key(&#34;exampleKey&#34;, KeyArgs.builder()        
 *             .deletionWindowInDays(10)
 *             .build());
 * 
 *         var exampleInstance = new Instance(&#34;exampleInstance&#34;, InstanceArgs.builder()        
 *             .identifier(&#34;example&#34;)
 *             .allocatedStorage(10)
 *             .dbName(&#34;test&#34;)
 *             .engine(&#34;mysql&#34;)
 *             .engineVersion(&#34;5.7&#34;)
 *             .instanceClass(&#34;db.t3.micro&#34;)
 *             .username(&#34;foo&#34;)
 *             .password(&#34;foobarbaz&#34;)
 *             .parameterGroupName(&#34;default.mysql5.7&#34;)
 *             .skipFinalSnapshot(true)
 *             .build());
 * 
 *         var exampleSnapshot = new Snapshot(&#34;exampleSnapshot&#34;, SnapshotArgs.builder()        
 *             .dbInstanceIdentifier(exampleInstance.identifier())
 *             .dbSnapshotIdentifier(&#34;example&#34;)
 *             .build());
 * 
 *         var exampleExportTask = new ExportTask(&#34;exampleExportTask&#34;, ExportTaskArgs.builder()        
 *             .exportTaskIdentifier(&#34;example&#34;)
 *             .sourceArn(exampleSnapshot.dbSnapshotArn())
 *             .s3BucketName(exampleBucketV2.id())
 *             .iamRoleArn(exampleRole.arn())
 *             .kmsKeyId(exampleKey.arn())
 *             .exportOnlies(&#34;database&#34;)
 *             .s3Prefix(&#34;my_prefix/example&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import a RDS (Relational Database) Export Task using the `export_task_identifier`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:rds/exportTask:ExportTask example example
 * ```
 * 
 */
@ResourceType(type="aws:rds/exportTask:ExportTask")
public class ExportTask extends com.pulumi.resources.CustomResource {
    /**
     * Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     * 
     */
    @Export(name="exportOnlies", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> exportOnlies;

    /**
     * @return Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     * 
     */
    public Output<Optional<List<String>>> exportOnlies() {
        return Codegen.optional(this.exportOnlies);
    }
    /**
     * Unique identifier for the snapshot export task.
     * 
     */
    @Export(name="exportTaskIdentifier", refs={String.class}, tree="[0]")
    private Output<String> exportTaskIdentifier;

    /**
     * @return Unique identifier for the snapshot export task.
     * 
     */
    public Output<String> exportTaskIdentifier() {
        return this.exportTaskIdentifier;
    }
    /**
     * Reason the export failed, if it failed.
     * 
     */
    @Export(name="failureCause", refs={String.class}, tree="[0]")
    private Output<String> failureCause;

    /**
     * @return Reason the export failed, if it failed.
     * 
     */
    public Output<String> failureCause() {
        return this.failureCause;
    }
    /**
     * ARN of the IAM role to use for writing to the Amazon S3 bucket.
     * 
     */
    @Export(name="iamRoleArn", refs={String.class}, tree="[0]")
    private Output<String> iamRoleArn;

    /**
     * @return ARN of the IAM role to use for writing to the Amazon S3 bucket.
     * 
     */
    public Output<String> iamRoleArn() {
        return this.iamRoleArn;
    }
    /**
     * ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
     * 
     */
    @Export(name="kmsKeyId", refs={String.class}, tree="[0]")
    private Output<String> kmsKeyId;

    /**
     * @return ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
     * 
     */
    public Output<String> kmsKeyId() {
        return this.kmsKeyId;
    }
    /**
     * Progress of the snapshot export task as a percentage.
     * 
     */
    @Export(name="percentProgress", refs={Integer.class}, tree="[0]")
    private Output<Integer> percentProgress;

    /**
     * @return Progress of the snapshot export task as a percentage.
     * 
     */
    public Output<Integer> percentProgress() {
        return this.percentProgress;
    }
    /**
     * Name of the Amazon S3 bucket to export the snapshot to.
     * 
     */
    @Export(name="s3BucketName", refs={String.class}, tree="[0]")
    private Output<String> s3BucketName;

    /**
     * @return Name of the Amazon S3 bucket to export the snapshot to.
     * 
     */
    public Output<String> s3BucketName() {
        return this.s3BucketName;
    }
    /**
     * Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     * 
     */
    @Export(name="s3Prefix", refs={String.class}, tree="[0]")
    private Output<String> s3Prefix;

    /**
     * @return Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     * 
     */
    public Output<String> s3Prefix() {
        return this.s3Prefix;
    }
    /**
     * Time that the snapshot was created.
     * 
     */
    @Export(name="snapshotTime", refs={String.class}, tree="[0]")
    private Output<String> snapshotTime;

    /**
     * @return Time that the snapshot was created.
     * 
     */
    public Output<String> snapshotTime() {
        return this.snapshotTime;
    }
    /**
     * Amazon Resource Name (ARN) of the snapshot to export.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="sourceArn", refs={String.class}, tree="[0]")
    private Output<String> sourceArn;

    /**
     * @return Amazon Resource Name (ARN) of the snapshot to export.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> sourceArn() {
        return this.sourceArn;
    }
    /**
     * Type of source for the export.
     * 
     */
    @Export(name="sourceType", refs={String.class}, tree="[0]")
    private Output<String> sourceType;

    /**
     * @return Type of source for the export.
     * 
     */
    public Output<String> sourceType() {
        return this.sourceType;
    }
    /**
     * Status of the export task.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return Status of the export task.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * Time that the snapshot export task completed.
     * 
     */
    @Export(name="taskEndTime", refs={String.class}, tree="[0]")
    private Output<String> taskEndTime;

    /**
     * @return Time that the snapshot export task completed.
     * 
     */
    public Output<String> taskEndTime() {
        return this.taskEndTime;
    }
    /**
     * Time that the snapshot export task started.
     * 
     */
    @Export(name="taskStartTime", refs={String.class}, tree="[0]")
    private Output<String> taskStartTime;

    /**
     * @return Time that the snapshot export task started.
     * 
     */
    public Output<String> taskStartTime() {
        return this.taskStartTime;
    }
    @Export(name="timeouts", refs={ExportTaskTimeouts.class}, tree="[0]")
    private Output</* @Nullable */ ExportTaskTimeouts> timeouts;

    public Output<Optional<ExportTaskTimeouts>> timeouts() {
        return Codegen.optional(this.timeouts);
    }
    /**
     * Warning about the snapshot export task, if any.
     * 
     */
    @Export(name="warningMessage", refs={String.class}, tree="[0]")
    private Output<String> warningMessage;

    /**
     * @return Warning about the snapshot export task, if any.
     * 
     */
    public Output<String> warningMessage() {
        return this.warningMessage;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ExportTask(String name) {
        this(name, ExportTaskArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ExportTask(String name, ExportTaskArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ExportTask(String name, ExportTaskArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:rds/exportTask:ExportTask", name, args == null ? ExportTaskArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ExportTask(String name, Output<String> id, @Nullable ExportTaskState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:rds/exportTask:ExportTask", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ExportTask get(String name, Output<String> id, @Nullable ExportTaskState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ExportTask(name, id, state, options);
    }
}
