// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.rds.ClusterInstanceArgs;
import com.pulumi.aws.rds.inputs.ClusterInstanceState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an RDS Cluster Instance Resource. A Cluster Instance Resource defines
 * attributes that are specific to a single instance in a RDS Cluster,
 * specifically running Amazon Aurora.
 * 
 * Unlike other RDS resources that support replication, with Amazon Aurora you do
 * not designate a primary and subsequent replicas. Instead, you simply add RDS
 * Instances and Aurora manages the replication. You can use the [count][5]
 * meta-parameter to make multiple instances and join them all to the same RDS
 * Cluster, or you may specify different Cluster Instance resources with various
 * `instance_class` sizes.
 * 
 * For more information on Amazon Aurora, see [Aurora on Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html) in the Amazon RDS User Guide.
 * 
 * &gt; **NOTE:** Deletion Protection from the RDS service can only be enabled at the cluster level, not for individual cluster instances. You can still add the [`protect` CustomResourceOption](https://www.pulumi.com/docs/intro/concepts/programming-model/#protect) to this resource configuration if you desire protection from accidental deletion.
 * 
 * &gt; **NOTE:** `aurora` is no longer a valid `engine` because of [Amazon Aurora&#39;s MySQL-Compatible Edition version 1 end of life](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.MySQL56.EOL.html).
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster(&#34;default&#34;, ClusterArgs.builder()        
 *             .clusterIdentifier(&#34;aurora-cluster-demo&#34;)
 *             .availabilityZones(            
 *                 &#34;us-west-2a&#34;,
 *                 &#34;us-west-2b&#34;,
 *                 &#34;us-west-2c&#34;)
 *             .databaseName(&#34;mydb&#34;)
 *             .masterUsername(&#34;foo&#34;)
 *             .masterPassword(&#34;barbut8chars&#34;)
 *             .build());
 * 
 *         for (var i = 0; i &lt; 2; i++) {
 *             new ClusterInstance(&#34;clusterInstances-&#34; + i, ClusterInstanceArgs.builder()            
 *                 .identifier(String.format(&#34;aurora-cluster-demo-%s&#34;, range.value()))
 *                 .clusterIdentifier(default_.id())
 *                 .instanceClass(&#34;db.r4.large&#34;)
 *                 .engine(default_.engine())
 *                 .engineVersion(default_.engineVersion())
 *                 .build());
 * 
 *         
 * }
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import RDS Cluster Instances using the `identifier`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:rds/clusterInstance:ClusterInstance prod_instance_1 aurora-cluster-instance-1
 * ```
 * 
 */
@ResourceType(type="aws:rds/clusterInstance:ClusterInstance")
public class ClusterInstance extends com.pulumi.resources.CustomResource {
    /**
     * Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
     * 
     */
    @Export(name="applyImmediately", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> applyImmediately;

    /**
     * @return Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
     * 
     */
    public Output<Boolean> applyImmediately() {
        return this.applyImmediately;
    }
    /**
     * Amazon Resource Name (ARN) of cluster instance
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of cluster instance
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
     * 
     */
    @Export(name="autoMinorVersionUpgrade", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> autoMinorVersionUpgrade;

    /**
     * @return Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
     * 
     */
    public Output<Optional<Boolean>> autoMinorVersionUpgrade() {
        return Codegen.optional(this.autoMinorVersionUpgrade);
    }
    /**
     * EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
     * 
     */
    @Export(name="availabilityZone", refs={String.class}, tree="[0]")
    private Output<String> availabilityZone;

    /**
     * @return EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
     * 
     */
    public Output<String> availabilityZone() {
        return this.availabilityZone;
    }
    /**
     * Identifier of the CA certificate for the DB instance.
     * 
     */
    @Export(name="caCertIdentifier", refs={String.class}, tree="[0]")
    private Output<String> caCertIdentifier;

    /**
     * @return Identifier of the CA certificate for the DB instance.
     * 
     */
    public Output<String> caCertIdentifier() {
        return this.caCertIdentifier;
    }
    /**
     * Identifier of the `aws.rds.Cluster` in which to launch this instance.
     * 
     */
    @Export(name="clusterIdentifier", refs={String.class}, tree="[0]")
    private Output<String> clusterIdentifier;

    /**
     * @return Identifier of the `aws.rds.Cluster` in which to launch this instance.
     * 
     */
    public Output<String> clusterIdentifier() {
        return this.clusterIdentifier;
    }
    /**
     * Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
     * 
     */
    @Export(name="copyTagsToSnapshot", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> copyTagsToSnapshot;

    /**
     * @return Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
     * 
     */
    public Output<Optional<Boolean>> copyTagsToSnapshot() {
        return Codegen.optional(this.copyTagsToSnapshot);
    }
    /**
     * Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     * 
     */
    @Export(name="customIamInstanceProfile", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> customIamInstanceProfile;

    /**
     * @return Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     * 
     */
    public Output<Optional<String>> customIamInstanceProfile() {
        return Codegen.optional(this.customIamInstanceProfile);
    }
    /**
     * Name of the DB parameter group to associate with this instance.
     * 
     */
    @Export(name="dbParameterGroupName", refs={String.class}, tree="[0]")
    private Output<String> dbParameterGroupName;

    /**
     * @return Name of the DB parameter group to associate with this instance.
     * 
     */
    public Output<String> dbParameterGroupName() {
        return this.dbParameterGroupName;
    }
    /**
     * DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` of the attached `aws.rds.Cluster`.
     * 
     */
    @Export(name="dbSubnetGroupName", refs={String.class}, tree="[0]")
    private Output<String> dbSubnetGroupName;

    /**
     * @return DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` of the attached `aws.rds.Cluster`.
     * 
     */
    public Output<String> dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }
    /**
     * Region-unique, immutable identifier for the DB instance.
     * 
     */
    @Export(name="dbiResourceId", refs={String.class}, tree="[0]")
    private Output<String> dbiResourceId;

    /**
     * @return Region-unique, immutable identifier for the DB instance.
     * 
     */
    public Output<String> dbiResourceId() {
        return this.dbiResourceId;
    }
    /**
     * DNS address for this instance. May not be writable
     * 
     */
    @Export(name="endpoint", refs={String.class}, tree="[0]")
    private Output<String> endpoint;

    /**
     * @return DNS address for this instance. May not be writable
     * 
     */
    public Output<String> endpoint() {
        return this.endpoint;
    }
    /**
     * Name of the database engine to be used for the RDS instance. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.
     * 
     */
    @Export(name="engine", refs={String.class}, tree="[0]")
    private Output<String> engine;

    /**
     * @return Name of the database engine to be used for the RDS instance. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.
     * 
     */
    public Output<String> engine() {
        return this.engine;
    }
    /**
     * Database engine version.
     * 
     */
    @Export(name="engineVersion", refs={String.class}, tree="[0]")
    private Output<String> engineVersion;

    /**
     * @return Database engine version.
     * 
     */
    public Output<String> engineVersion() {
        return this.engineVersion;
    }
    /**
     * Database engine version
     * 
     */
    @Export(name="engineVersionActual", refs={String.class}, tree="[0]")
    private Output<String> engineVersionActual;

    /**
     * @return Database engine version
     * 
     */
    public Output<String> engineVersionActual() {
        return this.engineVersionActual;
    }
    /**
     * Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
     * 
     */
    @Export(name="identifier", refs={String.class}, tree="[0]")
    private Output<String> identifier;

    /**
     * @return Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
     * 
     */
    public Output<String> identifier() {
        return this.identifier;
    }
    /**
     * Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     * 
     */
    @Export(name="identifierPrefix", refs={String.class}, tree="[0]")
    private Output<String> identifierPrefix;

    /**
     * @return Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     * 
     */
    public Output<String> identifierPrefix() {
        return this.identifierPrefix;
    }
    /**
     * Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details.
     * 
     */
    @Export(name="instanceClass", refs={String.class}, tree="[0]")
    private Output<String> instanceClass;

    /**
     * @return Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details.
     * 
     */
    public Output<String> instanceClass() {
        return this.instanceClass;
    }
    /**
     * ARN for the KMS encryption key if one is set to the cluster.
     * 
     */
    @Export(name="kmsKeyId", refs={String.class}, tree="[0]")
    private Output<String> kmsKeyId;

    /**
     * @return ARN for the KMS encryption key if one is set to the cluster.
     * 
     */
    public Output<String> kmsKeyId() {
        return this.kmsKeyId;
    }
    /**
     * Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
     * 
     */
    @Export(name="monitoringInterval", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> monitoringInterval;

    /**
     * @return Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
     * 
     */
    public Output<Optional<Integer>> monitoringInterval() {
        return Codegen.optional(this.monitoringInterval);
    }
    /**
     * ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
     * 
     */
    @Export(name="monitoringRoleArn", refs={String.class}, tree="[0]")
    private Output<String> monitoringRoleArn;

    /**
     * @return ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
     * 
     */
    public Output<String> monitoringRoleArn() {
        return this.monitoringRoleArn;
    }
    /**
     * Network type of the DB instance.
     * 
     */
    @Export(name="networkType", refs={String.class}, tree="[0]")
    private Output<String> networkType;

    /**
     * @return Network type of the DB instance.
     * 
     */
    public Output<String> networkType() {
        return this.networkType;
    }
    /**
     * Specifies whether Performance Insights is enabled or not.
     * 
     */
    @Export(name="performanceInsightsEnabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> performanceInsightsEnabled;

    /**
     * @return Specifies whether Performance Insights is enabled or not.
     * 
     */
    public Output<Boolean> performanceInsightsEnabled() {
        return this.performanceInsightsEnabled;
    }
    /**
     * ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
     * 
     */
    @Export(name="performanceInsightsKmsKeyId", refs={String.class}, tree="[0]")
    private Output<String> performanceInsightsKmsKeyId;

    /**
     * @return ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
     * 
     */
    public Output<String> performanceInsightsKmsKeyId() {
        return this.performanceInsightsKmsKeyId;
    }
    /**
     * Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to &#39;7&#39;.
     * 
     */
    @Export(name="performanceInsightsRetentionPeriod", refs={Integer.class}, tree="[0]")
    private Output<Integer> performanceInsightsRetentionPeriod;

    /**
     * @return Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to &#39;7&#39;.
     * 
     */
    public Output<Integer> performanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }
    /**
     * Database port
     * 
     */
    @Export(name="port", refs={Integer.class}, tree="[0]")
    private Output<Integer> port;

    /**
     * @return Database port
     * 
     */
    public Output<Integer> port() {
        return this.port;
    }
    /**
     * Daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;. **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
     * 
     */
    @Export(name="preferredBackupWindow", refs={String.class}, tree="[0]")
    private Output<String> preferredBackupWindow;

    /**
     * @return Daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;. **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
     * 
     */
    public Output<String> preferredBackupWindow() {
        return this.preferredBackupWindow;
    }
    /**
     * Window to perform maintenance in. Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
     * 
     */
    @Export(name="preferredMaintenanceWindow", refs={String.class}, tree="[0]")
    private Output<String> preferredMaintenanceWindow;

    /**
     * @return Window to perform maintenance in. Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
     * 
     */
    public Output<String> preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }
    /**
     * Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
     * 
     */
    @Export(name="promotionTier", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> promotionTier;

    /**
     * @return Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
     * 
     */
    public Output<Optional<Integer>> promotionTier() {
        return Codegen.optional(this.promotionTier);
    }
    /**
     * Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
     * 
     */
    @Export(name="publiclyAccessible", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> publiclyAccessible;

    /**
     * @return Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
     * 
     */
    public Output<Optional<Boolean>> publiclyAccessible() {
        return Codegen.optional(this.publiclyAccessible);
    }
    /**
     * Specifies whether the DB cluster is encrypted.
     * 
     */
    @Export(name="storageEncrypted", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> storageEncrypted;

    /**
     * @return Specifies whether the DB cluster is encrypted.
     * 
     */
    public Output<Boolean> storageEncrypted() {
        return this.storageEncrypted;
    }
    /**
     * Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
     * 
     */
    @Export(name="writer", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> writer;

    /**
     * @return Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
     * 
     */
    public Output<Boolean> writer() {
        return this.writer;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ClusterInstance(String name) {
        this(name, ClusterInstanceArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ClusterInstance(String name, ClusterInstanceArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ClusterInstance(String name, ClusterInstanceArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:rds/clusterInstance:ClusterInstance", name, args == null ? ClusterInstanceArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ClusterInstance(String name, Output<String> id, @Nullable ClusterInstanceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:rds/clusterInstance:ClusterInstance", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ClusterInstance get(String name, Output<String> id, @Nullable ClusterInstanceState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ClusterInstance(name, id, state, options);
    }
}
