// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rbin;

import com.pulumi.aws.rbin.inputs.RuleLockConfigurationArgs;
import com.pulumi.aws.rbin.inputs.RuleResourceTagArgs;
import com.pulumi.aws.rbin.inputs.RuleRetentionPeriodArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class RuleArgs extends com.pulumi.resources.ResourceArgs {

    public static final RuleArgs Empty = new RuleArgs();

    /**
     * The retention rule description.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return The retention rule description.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Information about the retention rule lock configuration. See `lock_configuration` below.
     * 
     */
    @Import(name="lockConfiguration")
    private @Nullable Output<RuleLockConfigurationArgs> lockConfiguration;

    /**
     * @return Information about the retention rule lock configuration. See `lock_configuration` below.
     * 
     */
    public Optional<Output<RuleLockConfigurationArgs>> lockConfiguration() {
        return Optional.ofNullable(this.lockConfiguration);
    }

    /**
     * Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     * 
     */
    @Import(name="resourceTags")
    private @Nullable Output<List<RuleResourceTagArgs>> resourceTags;

    /**
     * @return Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
     * 
     */
    public Optional<Output<List<RuleResourceTagArgs>>> resourceTags() {
        return Optional.ofNullable(this.resourceTags);
    }

    /**
     * The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
     * 
     */
    @Import(name="resourceType", required=true)
    private Output<String> resourceType;

    /**
     * @return The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
     * 
     */
    public Output<String> resourceType() {
        return this.resourceType;
    }

    /**
     * Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="retentionPeriod", required=true)
    private Output<RuleRetentionPeriodArgs> retentionPeriod;

    /**
     * @return Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<RuleRetentionPeriodArgs> retentionPeriod() {
        return this.retentionPeriod;
    }

    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private RuleArgs() {}

    private RuleArgs(RuleArgs $) {
        this.description = $.description;
        this.lockConfiguration = $.lockConfiguration;
        this.resourceTags = $.resourceTags;
        this.resourceType = $.resourceType;
        this.retentionPeriod = $.retentionPeriod;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(RuleArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private RuleArgs $;

        public Builder() {
            $ = new RuleArgs();
        }

        public Builder(RuleArgs defaults) {
            $ = new RuleArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description The retention rule description.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description The retention rule description.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param lockConfiguration Information about the retention rule lock configuration. See `lock_configuration` below.
         * 
         * @return builder
         * 
         */
        public Builder lockConfiguration(@Nullable Output<RuleLockConfigurationArgs> lockConfiguration) {
            $.lockConfiguration = lockConfiguration;
            return this;
        }

        /**
         * @param lockConfiguration Information about the retention rule lock configuration. See `lock_configuration` below.
         * 
         * @return builder
         * 
         */
        public Builder lockConfiguration(RuleLockConfigurationArgs lockConfiguration) {
            return lockConfiguration(Output.of(lockConfiguration));
        }

        /**
         * @param resourceTags Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
         * 
         * @return builder
         * 
         */
        public Builder resourceTags(@Nullable Output<List<RuleResourceTagArgs>> resourceTags) {
            $.resourceTags = resourceTags;
            return this;
        }

        /**
         * @param resourceTags Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
         * 
         * @return builder
         * 
         */
        public Builder resourceTags(List<RuleResourceTagArgs> resourceTags) {
            return resourceTags(Output.of(resourceTags));
        }

        /**
         * @param resourceTags Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. See `resource_tags` below.
         * 
         * @return builder
         * 
         */
        public Builder resourceTags(RuleResourceTagArgs... resourceTags) {
            return resourceTags(List.of(resourceTags));
        }

        /**
         * @param resourceType The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
         * 
         * @return builder
         * 
         */
        public Builder resourceType(Output<String> resourceType) {
            $.resourceType = resourceType;
            return this;
        }

        /**
         * @param resourceType The resource type to be retained by the retention rule. Valid values are `EBS_SNAPSHOT` and `EC2_IMAGE`.
         * 
         * @return builder
         * 
         */
        public Builder resourceType(String resourceType) {
            return resourceType(Output.of(resourceType));
        }

        /**
         * @param retentionPeriod Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder retentionPeriod(Output<RuleRetentionPeriodArgs> retentionPeriod) {
            $.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * @param retentionPeriod Information about the retention period for which the retention rule is to retain resources. See `retention_period` below.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder retentionPeriod(RuleRetentionPeriodArgs retentionPeriod) {
            return retentionPeriod(Output.of(retentionPeriod));
        }

        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public RuleArgs build() {
            $.resourceType = Objects.requireNonNull($.resourceType, "expected parameter 'resourceType' to be non-null");
            $.retentionPeriod = Objects.requireNonNull($.retentionPeriod, "expected parameter 'retentionPeriod' to be non-null");
            return $;
        }
    }

}
