// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ram;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ram.ResourceShareArgs;
import com.pulumi.aws.ram.inputs.ResourceShareState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a Resource Access Manager (RAM) Resource Share. To associate principals with the share, see the `aws.ram.PrincipalAssociation` resource. To associate resources with the share, see the `aws.ram.ResourceAssociation` resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.ResourceShare;
 * import com.pulumi.aws.ram.ResourceShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ResourceShare(&#34;example&#34;, ResourceShareArgs.builder()        
 *             .allowExternalPrincipals(true)
 *             .tags(Map.of(&#34;Environment&#34;, &#34;Production&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import resource shares using the `arn` of the resource share. For exampleterraform import {
 * 
 *  to = aws_ram_resource_share.example
 * 
 *  id = &#34;arn:aws:ram:eu-west-1:123456789012:resource-share/73da1ab9-b94a-4ba3-8eb4-45917f7f4b12&#34; } Using `TODO import`, import resource shares using the `arn` of the resource share. For exampleconsole % TODO import aws_ram_resource_share.example arn:aws:ram:eu-west-1:123456789012:resource-share/73da1ab9-b94a-4ba3-8eb4-45917f7f4b12
 * 
 */
@ResourceType(type="aws:ram/resourceShare:ResourceShare")
public class ResourceShare extends com.pulumi.resources.CustomResource {
    /**
     * Indicates whether principals outside your organization can be associated with a resource share.
     * 
     */
    @Export(name="allowExternalPrincipals", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> allowExternalPrincipals;

    /**
     * @return Indicates whether principals outside your organization can be associated with a resource share.
     * 
     */
    public Output<Optional<Boolean>> allowExternalPrincipals() {
        return Codegen.optional(this.allowExternalPrincipals);
    }
    /**
     * The Amazon Resource Name (ARN) of the resource share.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the resource share.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The name of the resource share.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the resource share.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Specifies the Amazon Resource Names (ARNs) of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
     * 
     */
    @Export(name="permissionArns", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> permissionArns;

    /**
     * @return Specifies the Amazon Resource Names (ARNs) of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
     * 
     */
    public Output<List<String>> permissionArns() {
        return this.permissionArns;
    }
    /**
     * A map of tags to assign to the resource share. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource share. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ResourceShare(String name) {
        this(name, ResourceShareArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ResourceShare(String name, @Nullable ResourceShareArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ResourceShare(String name, @Nullable ResourceShareArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ram/resourceShare:ResourceShare", name, args == null ? ResourceShareArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ResourceShare(String name, Output<String> id, @Nullable ResourceShareState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ram/resourceShare:ResourceShare", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ResourceShare get(String name, Output<String> id, @Nullable ResourceShareState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ResourceShare(name, id, state, options);
    }
}
