// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ram;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ram.ResourceAssociationArgs;
import com.pulumi.aws.ram.inputs.ResourceAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages a Resource Access Manager (RAM) Resource Association.
 * 
 * &gt; *NOTE:* Certain AWS resources (e.g., EC2 Subnets) can only be shared in an AWS account that is a member of an AWS Organizations organization with organization-wide Resource Access Manager functionality enabled. See the [Resource Access Manager User Guide](https://docs.aws.amazon.com/ram/latest/userguide/what-is.html) and AWS service specific documentation for additional information.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.ResourceAssociation;
 * import com.pulumi.aws.ram.ResourceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ResourceAssociation(&#34;example&#34;, ResourceAssociationArgs.builder()        
 *             .resourceArn(aws_subnet.example().arn())
 *             .resourceShareArn(aws_ram_resource_share.example().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import RAM Resource Associations using their Resource Share ARN and Resource ARN separated by a comma. For example:
 * 
 * ```sh
 *  $ pulumi import aws:ram/resourceAssociation:ResourceAssociation example arn:aws:ram:eu-west-1:123456789012:resource-share/73da1ab9-b94a-4ba3-8eb4-45917f7f4b12,arn:aws:ec2:eu-west-1:123456789012:subnet/subnet-12345678
 * ```
 * 
 */
@ResourceType(type="aws:ram/resourceAssociation:ResourceAssociation")
public class ResourceAssociation extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of the resource to associate with the RAM Resource Share.
     * 
     */
    @Export(name="resourceArn", refs={String.class}, tree="[0]")
    private Output<String> resourceArn;

    /**
     * @return Amazon Resource Name (ARN) of the resource to associate with the RAM Resource Share.
     * 
     */
    public Output<String> resourceArn() {
        return this.resourceArn;
    }
    /**
     * Amazon Resource Name (ARN) of the RAM Resource Share.
     * 
     */
    @Export(name="resourceShareArn", refs={String.class}, tree="[0]")
    private Output<String> resourceShareArn;

    /**
     * @return Amazon Resource Name (ARN) of the RAM Resource Share.
     * 
     */
    public Output<String> resourceShareArn() {
        return this.resourceShareArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ResourceAssociation(String name) {
        this(name, ResourceAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ResourceAssociation(String name, ResourceAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ResourceAssociation(String name, ResourceAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ram/resourceAssociation:ResourceAssociation", name, args == null ? ResourceAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ResourceAssociation(String name, Output<String> id, @Nullable ResourceAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ram/resourceAssociation:ResourceAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ResourceAssociation get(String name, Output<String> id, @Nullable ResourceAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ResourceAssociation(name, id, state, options);
    }
}
