// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.ram;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.ram.PrincipalAssociationArgs;
import com.pulumi.aws.ram.inputs.PrincipalAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a Resource Access Manager (RAM) principal association. Depending if [RAM Sharing with AWS Organizations is enabled](https://docs.aws.amazon.com/ram/latest/userguide/getting-started-sharing.html#getting-started-sharing-orgs), the RAM behavior with different principal types changes.
 * 
 * When RAM Sharing with AWS Organizations is enabled:
 * 
 * - For AWS Account ID, Organization, and Organizational Unit principals within the same AWS Organization, no resource share invitation is sent and resources become available automatically after creating the association.
 * - For AWS Account ID principals outside the AWS Organization, a resource share invitation is sent and must be accepted before resources become available. See the `aws.ram.ResourceShareAccepter` resource to accept these invitations.
 * 
 * When RAM Sharing with AWS Organizations is not enabled:
 * 
 * - Organization and Organizational Unit principals cannot be used.
 * - For AWS Account ID principals, a resource share invitation is sent and must be accepted before resources become available. See the `aws.ram.ResourceShareAccepter` resource to accept these invitations.
 * 
 * ## Example Usage
 * ### AWS Account ID
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.ResourceShare;
 * import com.pulumi.aws.ram.ResourceShareArgs;
 * import com.pulumi.aws.ram.PrincipalAssociation;
 * import com.pulumi.aws.ram.PrincipalAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleResourceShare = new ResourceShare(&#34;exampleResourceShare&#34;, ResourceShareArgs.builder()        
 *             .allowExternalPrincipals(true)
 *             .build());
 * 
 *         var examplePrincipalAssociation = new PrincipalAssociation(&#34;examplePrincipalAssociation&#34;, PrincipalAssociationArgs.builder()        
 *             .principal(&#34;111111111111&#34;)
 *             .resourceShareArn(exampleResourceShare.arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### AWS Organization
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.PrincipalAssociation;
 * import com.pulumi.aws.ram.PrincipalAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new PrincipalAssociation(&#34;example&#34;, PrincipalAssociationArgs.builder()        
 *             .principal(aws_organizations_organization.example().arn())
 *             .resourceShareArn(aws_ram_resource_share.example().arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import RAM Principal Associations using their Resource Share ARN and the `principal` separated by a comma. For exampleterraform import {
 * 
 *  to = aws_ram_principal_association.example
 * 
 *  id = &#34;arn:aws:ram:eu-west-1:123456789012:resource-share/73da1ab9-b94a-4ba3-8eb4-45917f7f4b12,123456789012&#34; } Using `TODO import`, import RAM Principal Associations using their Resource Share ARN and the `principal` separated by a comma. For exampleconsole % TODO import aws_ram_principal_association.example arn:aws:ram:eu-west-1:123456789012:resource-share/73da1ab9-b94a-4ba3-8eb4-45917f7f4b12,123456789012
 * 
 */
@ResourceType(type="aws:ram/principalAssociation:PrincipalAssociation")
public class PrincipalAssociation extends com.pulumi.resources.CustomResource {
    /**
     * The principal to associate with the resource share. Possible values are an AWS account ID, an AWS Organizations Organization ARN, or an AWS Organizations Organization Unit ARN.
     * 
     */
    @Export(name="principal", refs={String.class}, tree="[0]")
    private Output<String> principal;

    /**
     * @return The principal to associate with the resource share. Possible values are an AWS account ID, an AWS Organizations Organization ARN, or an AWS Organizations Organization Unit ARN.
     * 
     */
    public Output<String> principal() {
        return this.principal;
    }
    /**
     * The Amazon Resource Name (ARN) of the resource share.
     * 
     */
    @Export(name="resourceShareArn", refs={String.class}, tree="[0]")
    private Output<String> resourceShareArn;

    /**
     * @return The Amazon Resource Name (ARN) of the resource share.
     * 
     */
    public Output<String> resourceShareArn() {
        return this.resourceShareArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public PrincipalAssociation(String name) {
        this(name, PrincipalAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public PrincipalAssociation(String name, PrincipalAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public PrincipalAssociation(String name, PrincipalAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ram/principalAssociation:PrincipalAssociation", name, args == null ? PrincipalAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private PrincipalAssociation(String name, Output<String> id, @Nullable PrincipalAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:ram/principalAssociation:PrincipalAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static PrincipalAssociation get(String name, Output<String> id, @Nullable PrincipalAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new PrincipalAssociation(name, id, state, options);
    }
}
