// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.quicksight;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.quicksight.VpcConnectionArgs;
import com.pulumi.aws.quicksight.inputs.VpcConnectionState;
import com.pulumi.aws.quicksight.outputs.VpcConnectionTimeouts;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS QuickSight VPC Connection.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import com.pulumi.aws.quicksight.VpcConnection;
 * import com.pulumi.aws.quicksight.VpcConnectionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var vpcConnectionRole = new Role(&#34;vpcConnectionRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;Version&#34;, &#34;2012-10-17&#34;),
 *                     jsonProperty(&#34;Statement&#34;, jsonArray(jsonObject(
 *                         jsonProperty(&#34;Effect&#34;, &#34;Allow&#34;),
 *                         jsonProperty(&#34;Action&#34;, &#34;sts:AssumeRole&#34;),
 *                         jsonProperty(&#34;Principal&#34;, jsonObject(
 *                             jsonProperty(&#34;Service&#34;, &#34;quicksight.amazonaws.com&#34;)
 *                         ))
 *                     )))
 *                 )))
 *             .inlinePolicies(RoleInlinePolicyArgs.builder()
 *                 .name(&#34;QuickSightVPCConnectionRolePolicy&#34;)
 *                 .policy(serializeJson(
 *                     jsonObject(
 *                         jsonProperty(&#34;Version&#34;, &#34;2012-10-17&#34;),
 *                         jsonProperty(&#34;Statement&#34;, jsonArray(jsonObject(
 *                             jsonProperty(&#34;Effect&#34;, &#34;Allow&#34;),
 *                             jsonProperty(&#34;Action&#34;, jsonArray(
 *                                 &#34;ec2:CreateNetworkInterface&#34;, 
 *                                 &#34;ec2:ModifyNetworkInterfaceAttribute&#34;, 
 *                                 &#34;ec2:DeleteNetworkInterface&#34;, 
 *                                 &#34;ec2:DescribeSubnets&#34;, 
 *                                 &#34;ec2:DescribeSecurityGroups&#34;
 *                             )),
 *                             jsonProperty(&#34;Resource&#34;, jsonArray(&#34;*&#34;))
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 * 
 *         var example = new VpcConnection(&#34;example&#34;, VpcConnectionArgs.builder()        
 *             .vpcConnectionId(&#34;example-connection-id&#34;)
 *             .roleArn(vpcConnectionRole.arn())
 *             .securityGroupIds(&#34;sg-00000000000000000&#34;)
 *             .subnetIds(            
 *                 &#34;subnet-00000000000000000&#34;,
 *                 &#34;subnet-00000000000000001&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import QuickSight VPC connection using the AWS account ID and VPC connection ID separated by commas (`,`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:quicksight/vpcConnection:VpcConnection example 123456789012,example
 * ```
 * 
 */
@ResourceType(type="aws:quicksight/vpcConnection:VpcConnection")
public class VpcConnection extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the VPC connection.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the VPC connection.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The availability status of the VPC connection. Valid values are `AVAILABLE`, `UNAVAILABLE` or `PARTIALLY_AVAILABLE`.
     * 
     */
    @Export(name="availabilityStatus", refs={String.class}, tree="[0]")
    private Output<String> availabilityStatus;

    /**
     * @return The availability status of the VPC connection. Valid values are `AVAILABLE`, `UNAVAILABLE` or `PARTIALLY_AVAILABLE`.
     * 
     */
    public Output<String> availabilityStatus() {
        return this.availabilityStatus;
    }
    /**
     * AWS account ID.
     * 
     */
    @Export(name="awsAccountId", refs={String.class}, tree="[0]")
    private Output<String> awsAccountId;

    /**
     * @return AWS account ID.
     * 
     */
    public Output<String> awsAccountId() {
        return this.awsAccountId;
    }
    /**
     * A list of IP addresses of DNS resolver endpoints for the VPC connection.
     * 
     */
    @Export(name="dnsResolvers", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> dnsResolvers;

    /**
     * @return A list of IP addresses of DNS resolver endpoints for the VPC connection.
     * 
     */
    public Output<Optional<List<String>>> dnsResolvers() {
        return Codegen.optional(this.dnsResolvers);
    }
    /**
     * The display name for the VPC connection.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The display name for the VPC connection.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The IAM role to associate with the VPC connection.
     * 
     */
    @Export(name="roleArn", refs={String.class}, tree="[0]")
    private Output<String> roleArn;

    /**
     * @return The IAM role to associate with the VPC connection.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }
    /**
     * A list of security group IDs for the VPC connection.
     * 
     */
    @Export(name="securityGroupIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> securityGroupIds;

    /**
     * @return A list of security group IDs for the VPC connection.
     * 
     */
    public Output<List<String>> securityGroupIds() {
        return this.securityGroupIds;
    }
    /**
     * A list of subnet IDs for the VPC connection.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="subnetIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> subnetIds;

    /**
     * @return A list of subnet IDs for the VPC connection.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<List<String>> subnetIds() {
        return this.subnetIds;
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    @Export(name="timeouts", refs={VpcConnectionTimeouts.class}, tree="[0]")
    private Output</* @Nullable */ VpcConnectionTimeouts> timeouts;

    public Output<Optional<VpcConnectionTimeouts>> timeouts() {
        return Codegen.optional(this.timeouts);
    }
    /**
     * The ID of the VPC connection.
     * 
     */
    @Export(name="vpcConnectionId", refs={String.class}, tree="[0]")
    private Output<String> vpcConnectionId;

    /**
     * @return The ID of the VPC connection.
     * 
     */
    public Output<String> vpcConnectionId() {
        return this.vpcConnectionId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VpcConnection(String name) {
        this(name, VpcConnectionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VpcConnection(String name, VpcConnectionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VpcConnection(String name, VpcConnectionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:quicksight/vpcConnection:VpcConnection", name, args == null ? VpcConnectionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VpcConnection(String name, Output<String> id, @Nullable VpcConnectionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:quicksight/vpcConnection:VpcConnection", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VpcConnection get(String name, Output<String> id, @Nullable VpcConnectionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VpcConnection(name, id, state, options);
    }
}
