// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.quicksight;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class UserArgs extends com.pulumi.resources.ResourceArgs {

    public static final UserArgs Empty = new UserArgs();

    /**
     * The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     * 
     */
    @Import(name="awsAccountId")
    private @Nullable Output<String> awsAccountId;

    /**
     * @return The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     * 
     */
    public Optional<Output<String>> awsAccountId() {
        return Optional.ofNullable(this.awsAccountId);
    }

    /**
     * The email address of the user that you want to register.
     * 
     */
    @Import(name="email", required=true)
    private Output<String> email;

    /**
     * @return The email address of the user that you want to register.
     * 
     */
    public Output<String> email() {
        return this.email;
    }

    /**
     * The ARN of the IAM user or role that you are registering with Amazon QuickSight.
     * 
     */
    @Import(name="iamArn")
    private @Nullable Output<String> iamArn;

    /**
     * @return The ARN of the IAM user or role that you are registering with Amazon QuickSight.
     * 
     */
    public Optional<Output<String>> iamArn() {
        return Optional.ofNullable(this.iamArn);
    }

    /**
     * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts either  `IAM` or `QUICKSIGHT`. If `IAM` is specified, the `iam_arn` must also be specified.
     * 
     */
    @Import(name="identityType", required=true)
    private Output<String> identityType;

    /**
     * @return Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts either  `IAM` or `QUICKSIGHT`. If `IAM` is specified, the `iam_arn` must also be specified.
     * 
     */
    public Output<String> identityType() {
        return this.identityType;
    }

    /**
     * The Amazon Quicksight namespace to create the user in. Defaults to `default`.
     * 
     */
    @Import(name="namespace")
    private @Nullable Output<String> namespace;

    /**
     * @return The Amazon Quicksight namespace to create the user in. Defaults to `default`.
     * 
     */
    public Optional<Output<String>> namespace() {
        return Optional.ofNullable(this.namespace);
    }

    /**
     * The name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
     * 
     */
    @Import(name="sessionName")
    private @Nullable Output<String> sessionName;

    /**
     * @return The name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
     * 
     */
    public Optional<Output<String>> sessionName() {
        return Optional.ofNullable(this.sessionName);
    }

    /**
     * The Amazon QuickSight user name that you want to create for the user you are registering. Only valid for registering a user with `identity_type` set to `QUICKSIGHT`.
     * 
     */
    @Import(name="userName")
    private @Nullable Output<String> userName;

    /**
     * @return The Amazon QuickSight user name that you want to create for the user you are registering. Only valid for registering a user with `identity_type` set to `QUICKSIGHT`.
     * 
     */
    public Optional<Output<String>> userName() {
        return Optional.ofNullable(this.userName);
    }

    /**
     * The Amazon QuickSight role of the user. The user role can be one of the following: `READER`, `AUTHOR`, or `ADMIN`
     * 
     */
    @Import(name="userRole", required=true)
    private Output<String> userRole;

    /**
     * @return The Amazon QuickSight role of the user. The user role can be one of the following: `READER`, `AUTHOR`, or `ADMIN`
     * 
     */
    public Output<String> userRole() {
        return this.userRole;
    }

    private UserArgs() {}

    private UserArgs(UserArgs $) {
        this.awsAccountId = $.awsAccountId;
        this.email = $.email;
        this.iamArn = $.iamArn;
        this.identityType = $.identityType;
        this.namespace = $.namespace;
        this.sessionName = $.sessionName;
        this.userName = $.userName;
        this.userRole = $.userRole;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(UserArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private UserArgs $;

        public Builder() {
            $ = new UserArgs();
        }

        public Builder(UserArgs defaults) {
            $ = new UserArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param awsAccountId The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
         * 
         * @return builder
         * 
         */
        public Builder awsAccountId(@Nullable Output<String> awsAccountId) {
            $.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * @param awsAccountId The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
         * 
         * @return builder
         * 
         */
        public Builder awsAccountId(String awsAccountId) {
            return awsAccountId(Output.of(awsAccountId));
        }

        /**
         * @param email The email address of the user that you want to register.
         * 
         * @return builder
         * 
         */
        public Builder email(Output<String> email) {
            $.email = email;
            return this;
        }

        /**
         * @param email The email address of the user that you want to register.
         * 
         * @return builder
         * 
         */
        public Builder email(String email) {
            return email(Output.of(email));
        }

        /**
         * @param iamArn The ARN of the IAM user or role that you are registering with Amazon QuickSight.
         * 
         * @return builder
         * 
         */
        public Builder iamArn(@Nullable Output<String> iamArn) {
            $.iamArn = iamArn;
            return this;
        }

        /**
         * @param iamArn The ARN of the IAM user or role that you are registering with Amazon QuickSight.
         * 
         * @return builder
         * 
         */
        public Builder iamArn(String iamArn) {
            return iamArn(Output.of(iamArn));
        }

        /**
         * @param identityType Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts either  `IAM` or `QUICKSIGHT`. If `IAM` is specified, the `iam_arn` must also be specified.
         * 
         * @return builder
         * 
         */
        public Builder identityType(Output<String> identityType) {
            $.identityType = identityType;
            return this;
        }

        /**
         * @param identityType Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts either  `IAM` or `QUICKSIGHT`. If `IAM` is specified, the `iam_arn` must also be specified.
         * 
         * @return builder
         * 
         */
        public Builder identityType(String identityType) {
            return identityType(Output.of(identityType));
        }

        /**
         * @param namespace The Amazon Quicksight namespace to create the user in. Defaults to `default`.
         * 
         * @return builder
         * 
         */
        public Builder namespace(@Nullable Output<String> namespace) {
            $.namespace = namespace;
            return this;
        }

        /**
         * @param namespace The Amazon Quicksight namespace to create the user in. Defaults to `default`.
         * 
         * @return builder
         * 
         */
        public Builder namespace(String namespace) {
            return namespace(Output.of(namespace));
        }

        /**
         * @param sessionName The name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
         * 
         * @return builder
         * 
         */
        public Builder sessionName(@Nullable Output<String> sessionName) {
            $.sessionName = sessionName;
            return this;
        }

        /**
         * @param sessionName The name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
         * 
         * @return builder
         * 
         */
        public Builder sessionName(String sessionName) {
            return sessionName(Output.of(sessionName));
        }

        /**
         * @param userName The Amazon QuickSight user name that you want to create for the user you are registering. Only valid for registering a user with `identity_type` set to `QUICKSIGHT`.
         * 
         * @return builder
         * 
         */
        public Builder userName(@Nullable Output<String> userName) {
            $.userName = userName;
            return this;
        }

        /**
         * @param userName The Amazon QuickSight user name that you want to create for the user you are registering. Only valid for registering a user with `identity_type` set to `QUICKSIGHT`.
         * 
         * @return builder
         * 
         */
        public Builder userName(String userName) {
            return userName(Output.of(userName));
        }

        /**
         * @param userRole The Amazon QuickSight role of the user. The user role can be one of the following: `READER`, `AUTHOR`, or `ADMIN`
         * 
         * @return builder
         * 
         */
        public Builder userRole(Output<String> userRole) {
            $.userRole = userRole;
            return this;
        }

        /**
         * @param userRole The Amazon QuickSight role of the user. The user role can be one of the following: `READER`, `AUTHOR`, or `ADMIN`
         * 
         * @return builder
         * 
         */
        public Builder userRole(String userRole) {
            return userRole(Output.of(userRole));
        }

        public UserArgs build() {
            $.email = Objects.requireNonNull($.email, "expected parameter 'email' to be non-null");
            $.identityType = Objects.requireNonNull($.identityType, "expected parameter 'identityType' to be non-null");
            $.userRole = Objects.requireNonNull($.userRole, "expected parameter 'userRole' to be non-null");
            return $;
        }
    }

}
