// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.quicksight;

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationArgs;
import com.pulumi.aws.quicksight.inputs.ThemePermissionArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ThemeArgs extends com.pulumi.resources.ResourceArgs {

    public static final ThemeArgs Empty = new ThemeArgs();

    /**
     * AWS account ID.
     * 
     */
    @Import(name="awsAccountId")
    private @Nullable Output<String> awsAccountId;

    /**
     * @return AWS account ID.
     * 
     */
    public Optional<Output<String>> awsAccountId() {
        return Optional.ofNullable(this.awsAccountId);
    }

    /**
     * The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use ListThemes or choose Themes from within an analysis.
     * 
     */
    @Import(name="baseThemeId", required=true)
    private Output<String> baseThemeId;

    /**
     * @return The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use ListThemes or choose Themes from within an analysis.
     * 
     */
    public Output<String> baseThemeId() {
        return this.baseThemeId;
    }

    /**
     * The theme configuration, which contains the theme display properties. See configuration.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="configuration")
    private @Nullable Output<ThemeConfigurationArgs> configuration;

    /**
     * @return The theme configuration, which contains the theme display properties. See configuration.
     * 
     * The following arguments are optional:
     * 
     */
    public Optional<Output<ThemeConfigurationArgs>> configuration() {
        return Optional.ofNullable(this.configuration);
    }

    /**
     * Display name of the theme.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Display name of the theme.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     * 
     */
    @Import(name="permissions")
    private @Nullable Output<List<ThemePermissionArgs>> permissions;

    /**
     * @return A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     * 
     */
    public Optional<Output<List<ThemePermissionArgs>>> permissions() {
        return Optional.ofNullable(this.permissions);
    }

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Identifier of the theme.
     * 
     */
    @Import(name="themeId", required=true)
    private Output<String> themeId;

    /**
     * @return Identifier of the theme.
     * 
     */
    public Output<String> themeId() {
        return this.themeId;
    }

    /**
     * A description of the current theme version being created/updated.
     * 
     */
    @Import(name="versionDescription")
    private @Nullable Output<String> versionDescription;

    /**
     * @return A description of the current theme version being created/updated.
     * 
     */
    public Optional<Output<String>> versionDescription() {
        return Optional.ofNullable(this.versionDescription);
    }

    private ThemeArgs() {}

    private ThemeArgs(ThemeArgs $) {
        this.awsAccountId = $.awsAccountId;
        this.baseThemeId = $.baseThemeId;
        this.configuration = $.configuration;
        this.name = $.name;
        this.permissions = $.permissions;
        this.tags = $.tags;
        this.themeId = $.themeId;
        this.versionDescription = $.versionDescription;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ThemeArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ThemeArgs $;

        public Builder() {
            $ = new ThemeArgs();
        }

        public Builder(ThemeArgs defaults) {
            $ = new ThemeArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param awsAccountId AWS account ID.
         * 
         * @return builder
         * 
         */
        public Builder awsAccountId(@Nullable Output<String> awsAccountId) {
            $.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * @param awsAccountId AWS account ID.
         * 
         * @return builder
         * 
         */
        public Builder awsAccountId(String awsAccountId) {
            return awsAccountId(Output.of(awsAccountId));
        }

        /**
         * @param baseThemeId The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use ListThemes or choose Themes from within an analysis.
         * 
         * @return builder
         * 
         */
        public Builder baseThemeId(Output<String> baseThemeId) {
            $.baseThemeId = baseThemeId;
            return this;
        }

        /**
         * @param baseThemeId The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use ListThemes or choose Themes from within an analysis.
         * 
         * @return builder
         * 
         */
        public Builder baseThemeId(String baseThemeId) {
            return baseThemeId(Output.of(baseThemeId));
        }

        /**
         * @param configuration The theme configuration, which contains the theme display properties. See configuration.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder configuration(@Nullable Output<ThemeConfigurationArgs> configuration) {
            $.configuration = configuration;
            return this;
        }

        /**
         * @param configuration The theme configuration, which contains the theme display properties. See configuration.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder configuration(ThemeConfigurationArgs configuration) {
            return configuration(Output.of(configuration));
        }

        /**
         * @param name Display name of the theme.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Display name of the theme.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param permissions A set of resource permissions on the theme. Maximum of 64 items. See permissions.
         * 
         * @return builder
         * 
         */
        public Builder permissions(@Nullable Output<List<ThemePermissionArgs>> permissions) {
            $.permissions = permissions;
            return this;
        }

        /**
         * @param permissions A set of resource permissions on the theme. Maximum of 64 items. See permissions.
         * 
         * @return builder
         * 
         */
        public Builder permissions(List<ThemePermissionArgs> permissions) {
            return permissions(Output.of(permissions));
        }

        /**
         * @param permissions A set of resource permissions on the theme. Maximum of 64 items. See permissions.
         * 
         * @return builder
         * 
         */
        public Builder permissions(ThemePermissionArgs... permissions) {
            return permissions(List.of(permissions));
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param themeId Identifier of the theme.
         * 
         * @return builder
         * 
         */
        public Builder themeId(Output<String> themeId) {
            $.themeId = themeId;
            return this;
        }

        /**
         * @param themeId Identifier of the theme.
         * 
         * @return builder
         * 
         */
        public Builder themeId(String themeId) {
            return themeId(Output.of(themeId));
        }

        /**
         * @param versionDescription A description of the current theme version being created/updated.
         * 
         * @return builder
         * 
         */
        public Builder versionDescription(@Nullable Output<String> versionDescription) {
            $.versionDescription = versionDescription;
            return this;
        }

        /**
         * @param versionDescription A description of the current theme version being created/updated.
         * 
         * @return builder
         * 
         */
        public Builder versionDescription(String versionDescription) {
            return versionDescription(Output.of(versionDescription));
        }

        public ThemeArgs build() {
            $.baseThemeId = Objects.requireNonNull($.baseThemeId, "expected parameter 'baseThemeId' to be non-null");
            $.themeId = Objects.requireNonNull($.themeId, "expected parameter 'themeId' to be non-null");
            return $;
        }
    }

}
