// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.quicksight;

import com.pulumi.aws.quicksight.inputs.TemplatePermissionArgs;
import com.pulumi.aws.quicksight.inputs.TemplateSourceEntityArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TemplateArgs extends com.pulumi.resources.ResourceArgs {

    public static final TemplateArgs Empty = new TemplateArgs();

    /**
     * AWS account ID.
     * 
     */
    @Import(name="awsAccountId")
    private @Nullable Output<String> awsAccountId;

    /**
     * @return AWS account ID.
     * 
     */
    public Optional<Output<String>> awsAccountId() {
        return Optional.ofNullable(this.awsAccountId);
    }

    /**
     * Display name for the template.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Display name for the template.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * A set of resource permissions on the template. Maximum of 64 items. See permissions.
     * 
     */
    @Import(name="permissions")
    private @Nullable Output<List<TemplatePermissionArgs>> permissions;

    /**
     * @return A set of resource permissions on the template. Maximum of 64 items. See permissions.
     * 
     */
    public Optional<Output<List<TemplatePermissionArgs>>> permissions() {
        return Optional.ofNullable(this.permissions);
    }

    /**
     * The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     * 
     */
    @Import(name="sourceEntity")
    private @Nullable Output<TemplateSourceEntityArgs> sourceEntity;

    /**
     * @return The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     * 
     */
    public Optional<Output<TemplateSourceEntityArgs>> sourceEntity() {
        return Optional.ofNullable(this.sourceEntity);
    }

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Identifier for the template.
     * 
     */
    @Import(name="templateId", required=true)
    private Output<String> templateId;

    /**
     * @return Identifier for the template.
     * 
     */
    public Output<String> templateId() {
        return this.templateId;
    }

    /**
     * A description of the current template version being created/updated.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="versionDescription", required=true)
    private Output<String> versionDescription;

    /**
     * @return A description of the current template version being created/updated.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> versionDescription() {
        return this.versionDescription;
    }

    private TemplateArgs() {}

    private TemplateArgs(TemplateArgs $) {
        this.awsAccountId = $.awsAccountId;
        this.name = $.name;
        this.permissions = $.permissions;
        this.sourceEntity = $.sourceEntity;
        this.tags = $.tags;
        this.templateId = $.templateId;
        this.versionDescription = $.versionDescription;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TemplateArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TemplateArgs $;

        public Builder() {
            $ = new TemplateArgs();
        }

        public Builder(TemplateArgs defaults) {
            $ = new TemplateArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param awsAccountId AWS account ID.
         * 
         * @return builder
         * 
         */
        public Builder awsAccountId(@Nullable Output<String> awsAccountId) {
            $.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * @param awsAccountId AWS account ID.
         * 
         * @return builder
         * 
         */
        public Builder awsAccountId(String awsAccountId) {
            return awsAccountId(Output.of(awsAccountId));
        }

        /**
         * @param name Display name for the template.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Display name for the template.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param permissions A set of resource permissions on the template. Maximum of 64 items. See permissions.
         * 
         * @return builder
         * 
         */
        public Builder permissions(@Nullable Output<List<TemplatePermissionArgs>> permissions) {
            $.permissions = permissions;
            return this;
        }

        /**
         * @param permissions A set of resource permissions on the template. Maximum of 64 items. See permissions.
         * 
         * @return builder
         * 
         */
        public Builder permissions(List<TemplatePermissionArgs> permissions) {
            return permissions(Output.of(permissions));
        }

        /**
         * @param permissions A set of resource permissions on the template. Maximum of 64 items. See permissions.
         * 
         * @return builder
         * 
         */
        public Builder permissions(TemplatePermissionArgs... permissions) {
            return permissions(List.of(permissions));
        }

        /**
         * @param sourceEntity The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
         * 
         * @return builder
         * 
         */
        public Builder sourceEntity(@Nullable Output<TemplateSourceEntityArgs> sourceEntity) {
            $.sourceEntity = sourceEntity;
            return this;
        }

        /**
         * @param sourceEntity The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
         * 
         * @return builder
         * 
         */
        public Builder sourceEntity(TemplateSourceEntityArgs sourceEntity) {
            return sourceEntity(Output.of(sourceEntity));
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param templateId Identifier for the template.
         * 
         * @return builder
         * 
         */
        public Builder templateId(Output<String> templateId) {
            $.templateId = templateId;
            return this;
        }

        /**
         * @param templateId Identifier for the template.
         * 
         * @return builder
         * 
         */
        public Builder templateId(String templateId) {
            return templateId(Output.of(templateId));
        }

        /**
         * @param versionDescription A description of the current template version being created/updated.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder versionDescription(Output<String> versionDescription) {
            $.versionDescription = versionDescription;
            return this;
        }

        /**
         * @param versionDescription A description of the current template version being created/updated.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder versionDescription(String versionDescription) {
            return versionDescription(Output.of(versionDescription));
        }

        public TemplateArgs build() {
            $.templateId = Objects.requireNonNull($.templateId, "expected parameter 'templateId' to be non-null");
            $.versionDescription = Objects.requireNonNull($.versionDescription, "expected parameter 'versionDescription' to be non-null");
            return $;
        }
    }

}
