// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.quicksight;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.quicksight.TemplateAliasArgs;
import com.pulumi.aws.quicksight.inputs.TemplateAliasState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS QuickSight Template Alias.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.TemplateAlias;
 * import com.pulumi.aws.quicksight.TemplateAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new TemplateAlias(&#34;example&#34;, TemplateAliasArgs.builder()        
 *             .aliasName(&#34;example-alias&#34;)
 *             .templateId(aws_quicksight_template.test().template_id())
 *             .templateVersionNumber(aws_quicksight_template.test().version_number())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import QuickSight Template Alias using the AWS account ID, template ID, and alias name separated by a comma (`,`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:quicksight/templateAlias:TemplateAlias example 123456789012,example-id,example-alias
 * ```
 * 
 */
@ResourceType(type="aws:quicksight/templateAlias:TemplateAlias")
public class TemplateAlias extends com.pulumi.resources.CustomResource {
    /**
     * Display name of the template alias.
     * 
     */
    @Export(name="aliasName", refs={String.class}, tree="[0]")
    private Output<String> aliasName;

    /**
     * @return Display name of the template alias.
     * 
     */
    public Output<String> aliasName() {
        return this.aliasName;
    }
    /**
     * Amazon Resource Name (ARN) of the template alias.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the template alias.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * AWS account ID.
     * 
     */
    @Export(name="awsAccountId", refs={String.class}, tree="[0]")
    private Output<String> awsAccountId;

    /**
     * @return AWS account ID.
     * 
     */
    public Output<String> awsAccountId() {
        return this.awsAccountId;
    }
    /**
     * ID of the template.
     * 
     */
    @Export(name="templateId", refs={String.class}, tree="[0]")
    private Output<String> templateId;

    /**
     * @return ID of the template.
     * 
     */
    public Output<String> templateId() {
        return this.templateId;
    }
    /**
     * Version number of the template.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="templateVersionNumber", refs={Integer.class}, tree="[0]")
    private Output<Integer> templateVersionNumber;

    /**
     * @return Version number of the template.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<Integer> templateVersionNumber() {
        return this.templateVersionNumber;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public TemplateAlias(String name) {
        this(name, TemplateAliasArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public TemplateAlias(String name, TemplateAliasArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public TemplateAlias(String name, TemplateAliasArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:quicksight/templateAlias:TemplateAlias", name, args == null ? TemplateAliasArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private TemplateAlias(String name, Output<String> id, @Nullable TemplateAliasState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:quicksight/templateAlias:TemplateAlias", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static TemplateAlias get(String name, Output<String> id, @Nullable TemplateAliasState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new TemplateAlias(name, id, state, options);
    }
}
