// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.quicksight;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.quicksight.IngestionArgs;
import com.pulumi.aws.quicksight.inputs.IngestionState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS QuickSight Ingestion.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Ingestion;
 * import com.pulumi.aws.quicksight.IngestionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Ingestion(&#34;example&#34;, IngestionArgs.builder()        
 *             .dataSetId(aws_quicksight_data_set.example().data_set_id())
 *             .ingestionId(&#34;example-id&#34;)
 *             .ingestionType(&#34;FULL_REFRESH&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import QuickSight Ingestion using the AWS account ID, data set ID, and ingestion ID separated by commas (`,`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:quicksight/ingestion:Ingestion example 123456789012,example-dataset-id,example-ingestion-id
 * ```
 * 
 */
@ResourceType(type="aws:quicksight/ingestion:Ingestion")
public class Ingestion extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Ingestion.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Ingestion.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * AWS account ID.
     * 
     */
    @Export(name="awsAccountId", refs={String.class}, tree="[0]")
    private Output<String> awsAccountId;

    /**
     * @return AWS account ID.
     * 
     */
    public Output<String> awsAccountId() {
        return this.awsAccountId;
    }
    /**
     * ID of the dataset used in the ingestion.
     * 
     */
    @Export(name="dataSetId", refs={String.class}, tree="[0]")
    private Output<String> dataSetId;

    /**
     * @return ID of the dataset used in the ingestion.
     * 
     */
    public Output<String> dataSetId() {
        return this.dataSetId;
    }
    /**
     * ID for the ingestion.
     * 
     */
    @Export(name="ingestionId", refs={String.class}, tree="[0]")
    private Output<String> ingestionId;

    /**
     * @return ID for the ingestion.
     * 
     */
    public Output<String> ingestionId() {
        return this.ingestionId;
    }
    /**
     * Ingestion status.
     * 
     */
    @Export(name="ingestionStatus", refs={String.class}, tree="[0]")
    private Output<String> ingestionStatus;

    /**
     * @return Ingestion status.
     * 
     */
    public Output<String> ingestionStatus() {
        return this.ingestionStatus;
    }
    /**
     * Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="ingestionType", refs={String.class}, tree="[0]")
    private Output<String> ingestionType;

    /**
     * @return Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> ingestionType() {
        return this.ingestionType;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Ingestion(String name) {
        this(name, IngestionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Ingestion(String name, IngestionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Ingestion(String name, IngestionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:quicksight/ingestion:Ingestion", name, args == null ? IngestionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Ingestion(String name, Output<String> id, @Nullable IngestionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:quicksight/ingestion:Ingestion", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Ingestion get(String name, Output<String> id, @Nullable IngestionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Ingestion(name, id, state, options);
    }
}
