// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.quicksight;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.quicksight.FolderArgs;
import com.pulumi.aws.quicksight.inputs.FolderState;
import com.pulumi.aws.quicksight.outputs.FolderPermission;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing a QuickSight Folder.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Folder(&#34;example&#34;, FolderArgs.builder()        
 *             .folderId(&#34;example-id&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### With Permissions
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import com.pulumi.aws.quicksight.inputs.FolderPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Folder(&#34;example&#34;, FolderArgs.builder()        
 *             .folderId(&#34;example-id&#34;)
 *             .permissions(FolderPermissionArgs.builder()
 *                 .actions(                
 *                     &#34;quicksight:CreateFolder&#34;,
 *                     &#34;quicksight:DescribeFolder&#34;,
 *                     &#34;quicksight:UpdateFolder&#34;,
 *                     &#34;quicksight:DeleteFolder&#34;,
 *                     &#34;quicksight:CreateFolderMembership&#34;,
 *                     &#34;quicksight:DeleteFolderMembership&#34;,
 *                     &#34;quicksight:DescribeFolderPermissions&#34;,
 *                     &#34;quicksight:UpdateFolderPermissions&#34;)
 *                 .principal(aws_quicksight_user.example().arn())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### With Parent Folder
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var parent = new Folder(&#34;parent&#34;, FolderArgs.builder()        
 *             .folderId(&#34;parent-id&#34;)
 *             .build());
 * 
 *         var example = new Folder(&#34;example&#34;, FolderArgs.builder()        
 *             .folderId(&#34;example-id&#34;)
 *             .parentFolderArn(parent.arn())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import a QuickSight folder using the AWS account ID and folder ID name separated by a comma (`,`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:quicksight/folder:Folder example 123456789012,example-id
 * ```
 * 
 */
@ResourceType(type="aws:quicksight/folder:Folder")
public class Folder extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the folder.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the folder.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * AWS account ID.
     * 
     */
    @Export(name="awsAccountId", refs={String.class}, tree="[0]")
    private Output<String> awsAccountId;

    /**
     * @return AWS account ID.
     * 
     */
    public Output<String> awsAccountId() {
        return this.awsAccountId;
    }
    /**
     * The time that the folder was created.
     * 
     */
    @Export(name="createdTime", refs={String.class}, tree="[0]")
    private Output<String> createdTime;

    /**
     * @return The time that the folder was created.
     * 
     */
    public Output<String> createdTime() {
        return this.createdTime;
    }
    /**
     * Identifier for the folder.
     * 
     */
    @Export(name="folderId", refs={String.class}, tree="[0]")
    private Output<String> folderId;

    /**
     * @return Identifier for the folder.
     * 
     */
    public Output<String> folderId() {
        return this.folderId;
    }
    /**
     * An array of ancestor ARN strings for the folder. Empty for root-level folders.
     * 
     */
    @Export(name="folderPaths", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> folderPaths;

    /**
     * @return An array of ancestor ARN strings for the folder. Empty for root-level folders.
     * 
     */
    public Output<List<String>> folderPaths() {
        return this.folderPaths;
    }
    /**
     * The type of folder. By default, it is `SHARED`. Valid values are: `SHARED`.
     * 
     */
    @Export(name="folderType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> folderType;

    /**
     * @return The type of folder. By default, it is `SHARED`. Valid values are: `SHARED`.
     * 
     */
    public Output<Optional<String>> folderType() {
        return Codegen.optional(this.folderType);
    }
    /**
     * The time that the folder was last updated.
     * 
     */
    @Export(name="lastUpdatedTime", refs={String.class}, tree="[0]")
    private Output<String> lastUpdatedTime;

    /**
     * @return The time that the folder was last updated.
     * 
     */
    public Output<String> lastUpdatedTime() {
        return this.lastUpdatedTime;
    }
    /**
     * Display name for the folder.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Display name for the folder.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The Amazon Resource Name (ARN) for the parent folder. If not set, creates a root-level folder.
     * 
     */
    @Export(name="parentFolderArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> parentFolderArn;

    /**
     * @return The Amazon Resource Name (ARN) for the parent folder. If not set, creates a root-level folder.
     * 
     */
    public Output<Optional<String>> parentFolderArn() {
        return Codegen.optional(this.parentFolderArn);
    }
    /**
     * A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     * 
     */
    @Export(name="permissions", refs={List.class,FolderPermission.class}, tree="[0,1]")
    private Output</* @Nullable */ List<FolderPermission>> permissions;

    /**
     * @return A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     * 
     */
    public Output<Optional<List<FolderPermission>>> permissions() {
        return Codegen.optional(this.permissions);
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Folder(String name) {
        this(name, FolderArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Folder(String name, FolderArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Folder(String name, FolderArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:quicksight/folder:Folder", name, args == null ? FolderArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Folder(String name, Output<String> id, @Nullable FolderState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:quicksight/folder:Folder", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Folder get(String name, Output<String> id, @Nullable FolderState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Folder(name, id, state, options);
    }
}
