// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.quicksight;

import com.pulumi.aws.quicksight.inputs.AnalysisParametersArgs;
import com.pulumi.aws.quicksight.inputs.AnalysisPermissionArgs;
import com.pulumi.aws.quicksight.inputs.AnalysisSourceEntityArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class AnalysisArgs extends com.pulumi.resources.ResourceArgs {

    public static final AnalysisArgs Empty = new AnalysisArgs();

    /**
     * Identifier for the analysis.
     * 
     */
    @Import(name="analysisId", required=true)
    private Output<String> analysisId;

    /**
     * @return Identifier for the analysis.
     * 
     */
    public Output<String> analysisId() {
        return this.analysisId;
    }

    /**
     * AWS account ID.
     * 
     */
    @Import(name="awsAccountId")
    private @Nullable Output<String> awsAccountId;

    /**
     * @return AWS account ID.
     * 
     */
    public Optional<Output<String>> awsAccountId() {
        return Optional.ofNullable(this.awsAccountId);
    }

    /**
     * Display name for the analysis.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Display name for the analysis.
     * 
     * The following arguments are optional:
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The parameters for the creation of the analysis, which you want to use to override the default settings. An analysis can have any type of parameters, and some parameters might accept multiple values. See parameters.
     * 
     */
    @Import(name="parameters")
    private @Nullable Output<AnalysisParametersArgs> parameters;

    /**
     * @return The parameters for the creation of the analysis, which you want to use to override the default settings. An analysis can have any type of parameters, and some parameters might accept multiple values. See parameters.
     * 
     */
    public Optional<Output<AnalysisParametersArgs>> parameters() {
        return Optional.ofNullable(this.parameters);
    }

    /**
     * A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     * 
     */
    @Import(name="permissions")
    private @Nullable Output<List<AnalysisPermissionArgs>> permissions;

    /**
     * @return A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     * 
     */
    public Optional<Output<List<AnalysisPermissionArgs>>> permissions() {
        return Optional.ofNullable(this.permissions);
    }

    /**
     * A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. Use `0` to force deletion without recovery. Minimum value of `7`. Maximum value of `30`. Default to `30`.
     * 
     */
    @Import(name="recoveryWindowInDays")
    private @Nullable Output<Integer> recoveryWindowInDays;

    /**
     * @return A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. Use `0` to force deletion without recovery. Minimum value of `7`. Maximum value of `30`. Default to `30`.
     * 
     */
    public Optional<Output<Integer>> recoveryWindowInDays() {
        return Optional.ofNullable(this.recoveryWindowInDays);
    }

    /**
     * The entity that you are using as a source when you create the analysis (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     * 
     */
    @Import(name="sourceEntity")
    private @Nullable Output<AnalysisSourceEntityArgs> sourceEntity;

    /**
     * @return The entity that you are using as a source when you create the analysis (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     * 
     */
    public Optional<Output<AnalysisSourceEntityArgs>> sourceEntity() {
        return Optional.ofNullable(this.sourceEntity);
    }

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The Amazon Resource Name (ARN) of the theme that is being used for this analysis. The theme ARN must exist in the same AWS account where you create the analysis.
     * 
     */
    @Import(name="themeArn")
    private @Nullable Output<String> themeArn;

    /**
     * @return The Amazon Resource Name (ARN) of the theme that is being used for this analysis. The theme ARN must exist in the same AWS account where you create the analysis.
     * 
     */
    public Optional<Output<String>> themeArn() {
        return Optional.ofNullable(this.themeArn);
    }

    private AnalysisArgs() {}

    private AnalysisArgs(AnalysisArgs $) {
        this.analysisId = $.analysisId;
        this.awsAccountId = $.awsAccountId;
        this.name = $.name;
        this.parameters = $.parameters;
        this.permissions = $.permissions;
        this.recoveryWindowInDays = $.recoveryWindowInDays;
        this.sourceEntity = $.sourceEntity;
        this.tags = $.tags;
        this.themeArn = $.themeArn;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(AnalysisArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private AnalysisArgs $;

        public Builder() {
            $ = new AnalysisArgs();
        }

        public Builder(AnalysisArgs defaults) {
            $ = new AnalysisArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param analysisId Identifier for the analysis.
         * 
         * @return builder
         * 
         */
        public Builder analysisId(Output<String> analysisId) {
            $.analysisId = analysisId;
            return this;
        }

        /**
         * @param analysisId Identifier for the analysis.
         * 
         * @return builder
         * 
         */
        public Builder analysisId(String analysisId) {
            return analysisId(Output.of(analysisId));
        }

        /**
         * @param awsAccountId AWS account ID.
         * 
         * @return builder
         * 
         */
        public Builder awsAccountId(@Nullable Output<String> awsAccountId) {
            $.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * @param awsAccountId AWS account ID.
         * 
         * @return builder
         * 
         */
        public Builder awsAccountId(String awsAccountId) {
            return awsAccountId(Output.of(awsAccountId));
        }

        /**
         * @param name Display name for the analysis.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Display name for the analysis.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param parameters The parameters for the creation of the analysis, which you want to use to override the default settings. An analysis can have any type of parameters, and some parameters might accept multiple values. See parameters.
         * 
         * @return builder
         * 
         */
        public Builder parameters(@Nullable Output<AnalysisParametersArgs> parameters) {
            $.parameters = parameters;
            return this;
        }

        /**
         * @param parameters The parameters for the creation of the analysis, which you want to use to override the default settings. An analysis can have any type of parameters, and some parameters might accept multiple values. See parameters.
         * 
         * @return builder
         * 
         */
        public Builder parameters(AnalysisParametersArgs parameters) {
            return parameters(Output.of(parameters));
        }

        /**
         * @param permissions A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
         * 
         * @return builder
         * 
         */
        public Builder permissions(@Nullable Output<List<AnalysisPermissionArgs>> permissions) {
            $.permissions = permissions;
            return this;
        }

        /**
         * @param permissions A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
         * 
         * @return builder
         * 
         */
        public Builder permissions(List<AnalysisPermissionArgs> permissions) {
            return permissions(Output.of(permissions));
        }

        /**
         * @param permissions A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
         * 
         * @return builder
         * 
         */
        public Builder permissions(AnalysisPermissionArgs... permissions) {
            return permissions(List.of(permissions));
        }

        /**
         * @param recoveryWindowInDays A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. Use `0` to force deletion without recovery. Minimum value of `7`. Maximum value of `30`. Default to `30`.
         * 
         * @return builder
         * 
         */
        public Builder recoveryWindowInDays(@Nullable Output<Integer> recoveryWindowInDays) {
            $.recoveryWindowInDays = recoveryWindowInDays;
            return this;
        }

        /**
         * @param recoveryWindowInDays A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. Use `0` to force deletion without recovery. Minimum value of `7`. Maximum value of `30`. Default to `30`.
         * 
         * @return builder
         * 
         */
        public Builder recoveryWindowInDays(Integer recoveryWindowInDays) {
            return recoveryWindowInDays(Output.of(recoveryWindowInDays));
        }

        /**
         * @param sourceEntity The entity that you are using as a source when you create the analysis (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
         * 
         * @return builder
         * 
         */
        public Builder sourceEntity(@Nullable Output<AnalysisSourceEntityArgs> sourceEntity) {
            $.sourceEntity = sourceEntity;
            return this;
        }

        /**
         * @param sourceEntity The entity that you are using as a source when you create the analysis (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
         * 
         * @return builder
         * 
         */
        public Builder sourceEntity(AnalysisSourceEntityArgs sourceEntity) {
            return sourceEntity(Output.of(sourceEntity));
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param themeArn The Amazon Resource Name (ARN) of the theme that is being used for this analysis. The theme ARN must exist in the same AWS account where you create the analysis.
         * 
         * @return builder
         * 
         */
        public Builder themeArn(@Nullable Output<String> themeArn) {
            $.themeArn = themeArn;
            return this;
        }

        /**
         * @param themeArn The Amazon Resource Name (ARN) of the theme that is being used for this analysis. The theme ARN must exist in the same AWS account where you create the analysis.
         * 
         * @return builder
         * 
         */
        public Builder themeArn(String themeArn) {
            return themeArn(Output.of(themeArn));
        }

        public AnalysisArgs build() {
            $.analysisId = Objects.requireNonNull($.analysisId, "expected parameter 'analysisId' to be non-null");
            return $;
        }
    }

}
