// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.pinpoint;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.pinpoint.EmailChannelArgs;
import com.pulumi.aws.pinpoint.inputs.EmailChannelState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Pinpoint Email Channel resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.pinpoint.EmailChannel;
 * import com.pulumi.aws.pinpoint.EmailChannelArgs;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var app = new App(&#34;app&#34;);
 * 
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(&#34;pinpoint.amazonaws.com&#34;)
 *                     .build())
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .build())
 *             .build());
 * 
 *         var role = new Role(&#34;role&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var email = new EmailChannel(&#34;email&#34;, EmailChannelArgs.builder()        
 *             .applicationId(app.applicationId())
 *             .fromAddress(&#34;user@example.com&#34;)
 *             .roleArn(role.arn())
 *             .build());
 * 
 *         var identity = new DomainIdentity(&#34;identity&#34;, DomainIdentityArgs.builder()        
 *             .domain(&#34;example.com&#34;)
 *             .build());
 * 
 *         final var rolePolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .actions(                
 *                     &#34;mobileanalytics:PutEvents&#34;,
 *                     &#34;mobileanalytics:PutItems&#34;)
 *                 .resources(&#34;*&#34;)
 *                 .build())
 *             .build());
 * 
 *         var rolePolicyRolePolicy = new RolePolicy(&#34;rolePolicyRolePolicy&#34;, RolePolicyArgs.builder()        
 *             .role(role.id())
 *             .policy(rolePolicyPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import Pinpoint Email Channel using the `application-id`. For exampleterraform import {
 * 
 *  to = aws_pinpoint_email_channel.email
 * 
 *  id = &#34;application-id&#34; } Using `TODO import`, import Pinpoint Email Channel using the `application-id`. For exampleconsole % TODO import aws_pinpoint_email_channel.email application-id
 * 
 */
@ResourceType(type="aws:pinpoint/emailChannel:EmailChannel")
public class EmailChannel extends com.pulumi.resources.CustomResource {
    /**
     * The application ID.
     * 
     */
    @Export(name="applicationId", refs={String.class}, tree="[0]")
    private Output<String> applicationId;

    /**
     * @return The application ID.
     * 
     */
    public Output<String> applicationId() {
        return this.applicationId;
    }
    /**
     * The ARN of the Amazon SES configuration set that you want to apply to messages that you send through the channel.
     * 
     */
    @Export(name="configurationSet", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> configurationSet;

    /**
     * @return The ARN of the Amazon SES configuration set that you want to apply to messages that you send through the channel.
     * 
     */
    public Output<Optional<String>> configurationSet() {
        return Codegen.optional(this.configurationSet);
    }
    /**
     * Whether the channel is enabled or disabled. Defaults to `true`.
     * 
     */
    @Export(name="enabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enabled;

    /**
     * @return Whether the channel is enabled or disabled. Defaults to `true`.
     * 
     */
    public Output<Optional<Boolean>> enabled() {
        return Codegen.optional(this.enabled);
    }
    /**
     * The email address used to send emails from. You can use email only (`user@example.com`) or friendly address (`User &lt;user@example.com&gt;`). This field comply with [RFC 5322](https://www.ietf.org/rfc/rfc5322.txt).
     * 
     */
    @Export(name="fromAddress", refs={String.class}, tree="[0]")
    private Output<String> fromAddress;

    /**
     * @return The email address used to send emails from. You can use email only (`user@example.com`) or friendly address (`User &lt;user@example.com&gt;`). This field comply with [RFC 5322](https://www.ietf.org/rfc/rfc5322.txt).
     * 
     */
    public Output<String> fromAddress() {
        return this.fromAddress;
    }
    /**
     * The ARN of an identity verified with SES.
     * 
     */
    @Export(name="identity", refs={String.class}, tree="[0]")
    private Output<String> identity;

    /**
     * @return The ARN of an identity verified with SES.
     * 
     */
    public Output<String> identity() {
        return this.identity;
    }
    /**
     * Messages per second that can be sent.
     * 
     */
    @Export(name="messagesPerSecond", refs={Integer.class}, tree="[0]")
    private Output<Integer> messagesPerSecond;

    /**
     * @return Messages per second that can be sent.
     * 
     */
    public Output<Integer> messagesPerSecond() {
        return this.messagesPerSecond;
    }
    /**
     * The ARN of an IAM Role used to submit events to Mobile Analytics&#39; event ingestion service.
     * 
     */
    @Export(name="roleArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> roleArn;

    /**
     * @return The ARN of an IAM Role used to submit events to Mobile Analytics&#39; event ingestion service.
     * 
     */
    public Output<Optional<String>> roleArn() {
        return Codegen.optional(this.roleArn);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public EmailChannel(String name) {
        this(name, EmailChannelArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public EmailChannel(String name, EmailChannelArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public EmailChannel(String name, EmailChannelArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:pinpoint/emailChannel:EmailChannel", name, args == null ? EmailChannelArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private EmailChannel(String name, Output<String> id, @Nullable EmailChannelState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:pinpoint/emailChannel:EmailChannel", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static EmailChannel get(String name, Output<String> id, @Nullable EmailChannelState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new EmailChannel(name, id, state, options);
    }
}
