// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.pinpoint;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.pinpoint.AppArgs;
import com.pulumi.aws.pinpoint.inputs.AppState;
import com.pulumi.aws.pinpoint.outputs.AppCampaignHook;
import com.pulumi.aws.pinpoint.outputs.AppLimits;
import com.pulumi.aws.pinpoint.outputs.AppQuietTime;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Pinpoint App resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.AppArgs;
 * import com.pulumi.aws.pinpoint.inputs.AppLimitsArgs;
 * import com.pulumi.aws.pinpoint.inputs.AppQuietTimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new App(&#34;example&#34;, AppArgs.builder()        
 *             .limits(AppLimitsArgs.builder()
 *                 .maximumDuration(600)
 *                 .build())
 *             .quietTime(AppQuietTimeArgs.builder()
 *                 .end(&#34;06:00&#34;)
 *                 .start(&#34;00:00&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import Pinpoint App using the `application-id`. For exampleterraform import {
 * 
 *  to = aws_pinpoint_app.name
 * 
 *  id = &#34;application-id&#34; } Using `TODO import`, import Pinpoint App using the `application-id`. For exampleconsole % TODO import aws_pinpoint_app.name application-id
 * 
 */
@ResourceType(type="aws:pinpoint/app:App")
public class App extends com.pulumi.resources.CustomResource {
    /**
     * The Application ID of the Pinpoint App.
     * 
     */
    @Export(name="applicationId", refs={String.class}, tree="[0]")
    private Output<String> applicationId;

    /**
     * @return The Application ID of the Pinpoint App.
     * 
     */
    public Output<String> applicationId() {
        return this.applicationId;
    }
    /**
     * Amazon Resource Name (ARN) of the PinPoint Application
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the PinPoint Application
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign
     * 
     */
    @Export(name="campaignHook", refs={AppCampaignHook.class}, tree="[0]")
    private Output</* @Nullable */ AppCampaignHook> campaignHook;

    /**
     * @return Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign
     * 
     */
    public Output<Optional<AppCampaignHook>> campaignHook() {
        return Codegen.optional(this.campaignHook);
    }
    /**
     * The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign overrides the default with limits of its own
     * 
     */
    @Export(name="limits", refs={AppLimits.class}, tree="[0]")
    private Output</* @Nullable */ AppLimits> limits;

    /**
     * @return The default campaign limits for the app. These limits apply to each campaign for the app, unless the campaign overrides the default with limits of its own
     * 
     */
    public Output<Optional<AppLimits>> limits() {
        return Codegen.optional(this.limits);
    }
    /**
     * The application name. By default generated by TODO
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The application name. By default generated by TODO
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The name of the Pinpoint application. Conflicts with `name`
     * 
     */
    @Export(name="namePrefix", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> namePrefix;

    /**
     * @return The name of the Pinpoint application. Conflicts with `name`
     * 
     */
    public Output<Optional<String>> namePrefix() {
        return Codegen.optional(this.namePrefix);
    }
    /**
     * The default quiet time for the app. Each campaign for this app sends no messages during this time unless the campaign overrides the default with a quiet time of its own
     * 
     */
    @Export(name="quietTime", refs={AppQuietTime.class}, tree="[0]")
    private Output</* @Nullable */ AppQuietTime> quietTime;

    /**
     * @return The default quiet time for the app. Each campaign for this app sends no messages during this time unless the campaign overrides the default with a quiet time of its own
     * 
     */
    public Output<Optional<AppQuietTime>> quietTime() {
        return Codegen.optional(this.quietTime);
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public App(String name) {
        this(name, AppArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public App(String name, @Nullable AppArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public App(String name, @Nullable AppArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:pinpoint/app:App", name, args == null ? AppArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private App(String name, Output<String> id, @Nullable AppState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:pinpoint/app:App", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static App get(String name, Output<String> id, @Nullable AppState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new App(name, id, state, options);
    }
}
