// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.pinpoint;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.pinpoint.AdmChannelArgs;
import com.pulumi.aws.pinpoint.inputs.AdmChannelState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Pinpoint ADM (Amazon Device Messaging) Channel resource.
 * 
 * &gt; **Note:** All arguments including the Client ID and Client Secret will be stored in the raw state as plain-text.
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.pinpoint.App;
 * import com.pulumi.aws.pinpoint.AdmChannel;
 * import com.pulumi.aws.pinpoint.AdmChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var app = new App(&#34;app&#34;);
 * 
 *         var channel = new AdmChannel(&#34;channel&#34;, AdmChannelArgs.builder()        
 *             .applicationId(app.applicationId())
 *             .clientId(&#34;&#34;)
 *             .clientSecret(&#34;&#34;)
 *             .enabled(true)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import Pinpoint ADM Channel using the `application-id`. For exampleterraform import {
 * 
 *  to = aws_pinpoint_adm_channel.channel
 * 
 *  id = &#34;application-id&#34; } Using `TODO import`, import Pinpoint ADM Channel using the `application-id`. For exampleconsole % TODO import aws_pinpoint_adm_channel.channel application-id
 * 
 */
@ResourceType(type="aws:pinpoint/admChannel:AdmChannel")
public class AdmChannel extends com.pulumi.resources.CustomResource {
    /**
     * The application ID.
     * 
     */
    @Export(name="applicationId", refs={String.class}, tree="[0]")
    private Output<String> applicationId;

    /**
     * @return The application ID.
     * 
     */
    public Output<String> applicationId() {
        return this.applicationId;
    }
    /**
     * Client ID (part of OAuth Credentials) obtained via Amazon Developer Account.
     * 
     */
    @Export(name="clientId", refs={String.class}, tree="[0]")
    private Output<String> clientId;

    /**
     * @return Client ID (part of OAuth Credentials) obtained via Amazon Developer Account.
     * 
     */
    public Output<String> clientId() {
        return this.clientId;
    }
    /**
     * Client Secret (part of OAuth Credentials) obtained via Amazon Developer Account.
     * 
     */
    @Export(name="clientSecret", refs={String.class}, tree="[0]")
    private Output<String> clientSecret;

    /**
     * @return Client Secret (part of OAuth Credentials) obtained via Amazon Developer Account.
     * 
     */
    public Output<String> clientSecret() {
        return this.clientSecret;
    }
    /**
     * Specifies whether to enable the channel. Defaults to `true`.
     * 
     */
    @Export(name="enabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> enabled;

    /**
     * @return Specifies whether to enable the channel. Defaults to `true`.
     * 
     */
    public Output<Optional<Boolean>> enabled() {
        return Codegen.optional(this.enabled);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AdmChannel(String name) {
        this(name, AdmChannelArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AdmChannel(String name, AdmChannelArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AdmChannel(String name, AdmChannelArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:pinpoint/admChannel:AdmChannel", name, args == null ? AdmChannelArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AdmChannel(String name, Output<String> id, @Nullable AdmChannelState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:pinpoint/admChannel:AdmChannel", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "clientId",
                "clientSecret"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AdmChannel get(String name, Output<String> id, @Nullable AdmChannelState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AdmChannel(name, id, state, options);
    }
}
