// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.organizations;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.organizations.OrganizationalUnitArgs;
import com.pulumi.aws.organizations.inputs.OrganizationalUnitState;
import com.pulumi.aws.organizations.outputs.OrganizationalUnitAccount;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to create an organizational unit.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.OrganizationalUnit;
 * import com.pulumi.aws.organizations.OrganizationalUnitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new OrganizationalUnit(&#34;example&#34;, OrganizationalUnitArgs.builder()        
 *             .parentId(aws_organizations_organization.example().roots()[0].id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import AWS Organizations Organizational Units using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:organizations/organizationalUnit:OrganizationalUnit example ou-1234567
 * ```
 * 
 */
@ResourceType(type="aws:organizations/organizationalUnit:OrganizationalUnit")
public class OrganizationalUnit extends com.pulumi.resources.CustomResource {
    /**
     * List of child accounts for this Organizational Unit. Does not return account information for child Organizational Units. All elements have these attributes:
     * 
     */
    @Export(name="accounts", refs={List.class,OrganizationalUnitAccount.class}, tree="[0,1]")
    private Output<List<OrganizationalUnitAccount>> accounts;

    /**
     * @return List of child accounts for this Organizational Unit. Does not return account information for child Organizational Units. All elements have these attributes:
     * 
     */
    public Output<List<OrganizationalUnitAccount>> accounts() {
        return this.accounts;
    }
    /**
     * ARN of the organizational unit
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the organizational unit
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The name for the organizational unit
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name for the organizational unit
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * ID of the parent organizational unit, which may be the root
     * 
     */
    @Export(name="parentId", refs={String.class}, tree="[0]")
    private Output<String> parentId;

    /**
     * @return ID of the parent organizational unit, which may be the root
     * 
     */
    public Output<String> parentId() {
        return this.parentId;
    }
    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public OrganizationalUnit(String name) {
        this(name, OrganizationalUnitArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public OrganizationalUnit(String name, OrganizationalUnitArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public OrganizationalUnit(String name, OrganizationalUnitArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:organizations/organizationalUnit:OrganizationalUnit", name, args == null ? OrganizationalUnitArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private OrganizationalUnit(String name, Output<String> id, @Nullable OrganizationalUnitState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:organizations/organizationalUnit:OrganizationalUnit", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static OrganizationalUnit get(String name, Output<String> id, @Nullable OrganizationalUnitState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new OrganizationalUnit(name, id, state, options);
    }
}
