// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.organizations;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.organizations.OrganizationArgs;
import com.pulumi.aws.organizations.inputs.OrganizationState;
import com.pulumi.aws.organizations.outputs.OrganizationAccount;
import com.pulumi.aws.organizations.outputs.OrganizationNonMasterAccount;
import com.pulumi.aws.organizations.outputs.OrganizationRoot;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to create an organization.
 * 
 * !&gt; **WARNING:** When migrating from a `feature_set` of `CONSOLIDATED_BILLING` to `ALL`, the Organization account owner will received an email stating the following: &#34;You started the process to enable all features for your AWS organization. As part of that process, all member accounts that joined your organization by invitation must approve the change. You don’t need approval from member accounts that you directly created from within your AWS organization.&#34; After all member accounts have accepted the invitation, the Organization account owner must then finalize the changes via the [AWS Console](https://console.aws.amazon.com/organizations/home#/organization/settings/migration-progress). Until these steps are performed, the provider will perpetually show a difference, and the `DescribeOrganization` API will continue to show the `FeatureSet` as `CONSOLIDATED_BILLING`. See the [AWS Organizations documentation](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html) for more information.
 * 
 * !&gt; **WARNING:** [Warning from the AWS Docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html): &#34;We recommend that you enable integration between AWS Organizations and the specified AWS service by using the console or commands that are provided by the specified service. Doing so ensures that the service is aware that it can create the resources that are required for the integration. How the service creates those resources in the organization&#39;s accounts depends on that service. For more information, see the documentation for the other AWS service.&#34;
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var org = new Organization(&#34;org&#34;, OrganizationArgs.builder()        
 *             .awsServiceAccessPrincipals(            
 *                 &#34;cloudtrail.amazonaws.com&#34;,
 *                 &#34;config.amazonaws.com&#34;)
 *             .featureSet(&#34;ALL&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import the AWS organization using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:organizations/organization:Organization my_org o-1234567
 * ```
 * 
 */
@ResourceType(type="aws:organizations/organization:Organization")
public class Organization extends com.pulumi.resources.CustomResource {
    /**
     * List of organization accounts including the master account. For a list excluding the master account, see the `non_master_accounts` attribute. All elements have these attributes:
     * 
     */
    @Export(name="accounts", refs={List.class,OrganizationAccount.class}, tree="[0,1]")
    private Output<List<OrganizationAccount>> accounts;

    /**
     * @return List of organization accounts including the master account. For a list excluding the master account, see the `non_master_accounts` attribute. All elements have these attributes:
     * 
     */
    public Output<List<OrganizationAccount>> accounts() {
        return this.accounts;
    }
    /**
     * ARN of the root
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the root
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
     * 
     */
    @Export(name="awsServiceAccessPrincipals", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> awsServiceAccessPrincipals;

    /**
     * @return List of AWS service principal names for which you want to enable integration with your organization. This is typically in the form of a URL, such as service-abbreviation.amazonaws.com. Organization must have `feature_set` set to `ALL`. Some services do not support enablement via this endpoint, see [warning in aws docs](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAWSServiceAccess.html).
     * 
     */
    public Output<Optional<List<String>>> awsServiceAccessPrincipals() {
        return Codegen.optional(this.awsServiceAccessPrincipals);
    }
    /**
     * List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
     * 
     */
    @Export(name="enabledPolicyTypes", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> enabledPolicyTypes;

    /**
     * @return List of Organizations policy types to enable in the Organization Root. Organization must have `feature_set` set to `ALL`. For additional information about valid policy types (e.g., `AISERVICES_OPT_OUT_POLICY`, `BACKUP_POLICY`, `SERVICE_CONTROL_POLICY`, and `TAG_POLICY`), see the [AWS Organizations API Reference](https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnablePolicyType.html).
     * 
     */
    public Output<Optional<List<String>>> enabledPolicyTypes() {
        return Codegen.optional(this.enabledPolicyTypes);
    }
    /**
     * Specify &#34;ALL&#34; (default) or &#34;CONSOLIDATED_BILLING&#34;.
     * 
     */
    @Export(name="featureSet", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> featureSet;

    /**
     * @return Specify &#34;ALL&#34; (default) or &#34;CONSOLIDATED_BILLING&#34;.
     * 
     */
    public Output<Optional<String>> featureSet() {
        return Codegen.optional(this.featureSet);
    }
    /**
     * ARN of the master account
     * 
     */
    @Export(name="masterAccountArn", refs={String.class}, tree="[0]")
    private Output<String> masterAccountArn;

    /**
     * @return ARN of the master account
     * 
     */
    public Output<String> masterAccountArn() {
        return this.masterAccountArn;
    }
    /**
     * Email address of the master account
     * 
     */
    @Export(name="masterAccountEmail", refs={String.class}, tree="[0]")
    private Output<String> masterAccountEmail;

    /**
     * @return Email address of the master account
     * 
     */
    public Output<String> masterAccountEmail() {
        return this.masterAccountEmail;
    }
    /**
     * Identifier of the master account
     * 
     */
    @Export(name="masterAccountId", refs={String.class}, tree="[0]")
    private Output<String> masterAccountId;

    /**
     * @return Identifier of the master account
     * 
     */
    public Output<String> masterAccountId() {
        return this.masterAccountId;
    }
    /**
     * List of organization accounts excluding the master account. For a list including the master account, see the `accounts` attribute. All elements have these attributes:
     * 
     */
    @Export(name="nonMasterAccounts", refs={List.class,OrganizationNonMasterAccount.class}, tree="[0,1]")
    private Output<List<OrganizationNonMasterAccount>> nonMasterAccounts;

    /**
     * @return List of organization accounts excluding the master account. For a list including the master account, see the `accounts` attribute. All elements have these attributes:
     * 
     */
    public Output<List<OrganizationNonMasterAccount>> nonMasterAccounts() {
        return this.nonMasterAccounts;
    }
    /**
     * List of organization roots. All elements have these attributes:
     * 
     */
    @Export(name="roots", refs={List.class,OrganizationRoot.class}, tree="[0,1]")
    private Output<List<OrganizationRoot>> roots;

    /**
     * @return List of organization roots. All elements have these attributes:
     * 
     */
    public Output<List<OrganizationRoot>> roots() {
        return this.roots;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Organization(String name) {
        this(name, OrganizationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Organization(String name, @Nullable OrganizationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Organization(String name, @Nullable OrganizationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:organizations/organization:Organization", name, args == null ? OrganizationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Organization(String name, Output<String> id, @Nullable OrganizationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:organizations/organization:Organization", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Organization get(String name, Output<String> id, @Nullable OrganizationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Organization(name, id, state, options);
    }
}
