// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.opsworks;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class UserProfileArgs extends com.pulumi.resources.ResourceArgs {

    public static final UserProfileArgs Empty = new UserProfileArgs();

    /**
     * Whether users can specify their own SSH public key through the My Settings page
     * 
     */
    @Import(name="allowSelfManagement")
    private @Nullable Output<Boolean> allowSelfManagement;

    /**
     * @return Whether users can specify their own SSH public key through the My Settings page
     * 
     */
    public Optional<Output<Boolean>> allowSelfManagement() {
        return Optional.ofNullable(this.allowSelfManagement);
    }

    /**
     * The users public key
     * 
     */
    @Import(name="sshPublicKey")
    private @Nullable Output<String> sshPublicKey;

    /**
     * @return The users public key
     * 
     */
    public Optional<Output<String>> sshPublicKey() {
        return Optional.ofNullable(this.sshPublicKey);
    }

    /**
     * The ssh username, with witch this user wants to log in
     * 
     */
    @Import(name="sshUsername", required=true)
    private Output<String> sshUsername;

    /**
     * @return The ssh username, with witch this user wants to log in
     * 
     */
    public Output<String> sshUsername() {
        return this.sshUsername;
    }

    /**
     * The user&#39;s IAM ARN
     * 
     */
    @Import(name="userArn", required=true)
    private Output<String> userArn;

    /**
     * @return The user&#39;s IAM ARN
     * 
     */
    public Output<String> userArn() {
        return this.userArn;
    }

    private UserProfileArgs() {}

    private UserProfileArgs(UserProfileArgs $) {
        this.allowSelfManagement = $.allowSelfManagement;
        this.sshPublicKey = $.sshPublicKey;
        this.sshUsername = $.sshUsername;
        this.userArn = $.userArn;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(UserProfileArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private UserProfileArgs $;

        public Builder() {
            $ = new UserProfileArgs();
        }

        public Builder(UserProfileArgs defaults) {
            $ = new UserProfileArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allowSelfManagement Whether users can specify their own SSH public key through the My Settings page
         * 
         * @return builder
         * 
         */
        public Builder allowSelfManagement(@Nullable Output<Boolean> allowSelfManagement) {
            $.allowSelfManagement = allowSelfManagement;
            return this;
        }

        /**
         * @param allowSelfManagement Whether users can specify their own SSH public key through the My Settings page
         * 
         * @return builder
         * 
         */
        public Builder allowSelfManagement(Boolean allowSelfManagement) {
            return allowSelfManagement(Output.of(allowSelfManagement));
        }

        /**
         * @param sshPublicKey The users public key
         * 
         * @return builder
         * 
         */
        public Builder sshPublicKey(@Nullable Output<String> sshPublicKey) {
            $.sshPublicKey = sshPublicKey;
            return this;
        }

        /**
         * @param sshPublicKey The users public key
         * 
         * @return builder
         * 
         */
        public Builder sshPublicKey(String sshPublicKey) {
            return sshPublicKey(Output.of(sshPublicKey));
        }

        /**
         * @param sshUsername The ssh username, with witch this user wants to log in
         * 
         * @return builder
         * 
         */
        public Builder sshUsername(Output<String> sshUsername) {
            $.sshUsername = sshUsername;
            return this;
        }

        /**
         * @param sshUsername The ssh username, with witch this user wants to log in
         * 
         * @return builder
         * 
         */
        public Builder sshUsername(String sshUsername) {
            return sshUsername(Output.of(sshUsername));
        }

        /**
         * @param userArn The user&#39;s IAM ARN
         * 
         * @return builder
         * 
         */
        public Builder userArn(Output<String> userArn) {
            $.userArn = userArn;
            return this;
        }

        /**
         * @param userArn The user&#39;s IAM ARN
         * 
         * @return builder
         * 
         */
        public Builder userArn(String userArn) {
            return userArn(Output.of(userArn));
        }

        public UserProfileArgs build() {
            $.sshUsername = Objects.requireNonNull($.sshUsername, "expected parameter 'sshUsername' to be non-null");
            $.userArn = Objects.requireNonNull($.userArn, "expected parameter 'userArn' to be non-null");
            return $;
        }
    }

}
