// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.opsworks;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.opsworks.UserProfileArgs;
import com.pulumi.aws.opsworks.inputs.UserProfileState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an OpsWorks User Profile resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.UserProfile;
 * import com.pulumi.aws.opsworks.UserProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myProfile = new UserProfile(&#34;myProfile&#34;, UserProfileArgs.builder()        
 *             .userArn(aws_iam_user.user().arn())
 *             .sshUsername(&#34;my_user&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:opsworks/userProfile:UserProfile")
public class UserProfile extends com.pulumi.resources.CustomResource {
    /**
     * Whether users can specify their own SSH public key through the My Settings page
     * 
     */
    @Export(name="allowSelfManagement", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> allowSelfManagement;

    /**
     * @return Whether users can specify their own SSH public key through the My Settings page
     * 
     */
    public Output<Optional<Boolean>> allowSelfManagement() {
        return Codegen.optional(this.allowSelfManagement);
    }
    /**
     * The users public key
     * 
     */
    @Export(name="sshPublicKey", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> sshPublicKey;

    /**
     * @return The users public key
     * 
     */
    public Output<Optional<String>> sshPublicKey() {
        return Codegen.optional(this.sshPublicKey);
    }
    /**
     * The ssh username, with witch this user wants to log in
     * 
     */
    @Export(name="sshUsername", refs={String.class}, tree="[0]")
    private Output<String> sshUsername;

    /**
     * @return The ssh username, with witch this user wants to log in
     * 
     */
    public Output<String> sshUsername() {
        return this.sshUsername;
    }
    /**
     * The user&#39;s IAM ARN
     * 
     */
    @Export(name="userArn", refs={String.class}, tree="[0]")
    private Output<String> userArn;

    /**
     * @return The user&#39;s IAM ARN
     * 
     */
    public Output<String> userArn() {
        return this.userArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public UserProfile(String name) {
        this(name, UserProfileArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public UserProfile(String name, UserProfileArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public UserProfile(String name, UserProfileArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opsworks/userProfile:UserProfile", name, args == null ? UserProfileArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private UserProfile(String name, Output<String> id, @Nullable UserProfileState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opsworks/userProfile:UserProfile", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static UserProfile get(String name, Output<String> id, @Nullable UserProfileState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new UserProfile(name, id, state, options);
    }
}
