// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.opsworks;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.opsworks.PermissionArgs;
import com.pulumi.aws.opsworks.inputs.PermissionState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides an OpsWorks permission resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opsworks.Permission;
 * import com.pulumi.aws.opsworks.PermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var myStackPermission = new Permission(&#34;myStackPermission&#34;, PermissionArgs.builder()        
 *             .allowSsh(true)
 *             .allowSudo(true)
 *             .level(&#34;iam_only&#34;)
 *             .userArn(aws_iam_user.user().arn())
 *             .stackId(aws_opsworks_stack.stack().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:opsworks/permission:Permission")
public class Permission extends com.pulumi.resources.CustomResource {
    /**
     * Whether the user is allowed to use SSH to communicate with the instance
     * 
     */
    @Export(name="allowSsh", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> allowSsh;

    /**
     * @return Whether the user is allowed to use SSH to communicate with the instance
     * 
     */
    public Output<Boolean> allowSsh() {
        return this.allowSsh;
    }
    /**
     * Whether the user is allowed to use sudo to elevate privileges
     * 
     */
    @Export(name="allowSudo", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> allowSudo;

    /**
     * @return Whether the user is allowed to use sudo to elevate privileges
     * 
     */
    public Output<Boolean> allowSudo() {
        return this.allowSudo;
    }
    /**
     * The users permission level. Mus be one of `deny`, `show`, `deploy`, `manage`, `iam_only`
     * 
     */
    @Export(name="level", refs={String.class}, tree="[0]")
    private Output<String> level;

    /**
     * @return The users permission level. Mus be one of `deny`, `show`, `deploy`, `manage`, `iam_only`
     * 
     */
    public Output<String> level() {
        return this.level;
    }
    /**
     * The stack to set the permissions for
     * 
     */
    @Export(name="stackId", refs={String.class}, tree="[0]")
    private Output<String> stackId;

    /**
     * @return The stack to set the permissions for
     * 
     */
    public Output<String> stackId() {
        return this.stackId;
    }
    /**
     * The user&#39;s IAM ARN to set permissions for
     * 
     */
    @Export(name="userArn", refs={String.class}, tree="[0]")
    private Output<String> userArn;

    /**
     * @return The user&#39;s IAM ARN to set permissions for
     * 
     */
    public Output<String> userArn() {
        return this.userArn;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Permission(String name) {
        this(name, PermissionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Permission(String name, PermissionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Permission(String name, PermissionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opsworks/permission:Permission", name, args == null ? PermissionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Permission(String name, Output<String> id, @Nullable PermissionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opsworks/permission:Permission", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Permission get(String name, Output<String> id, @Nullable PermissionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Permission(name, id, state, options);
    }
}
