// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.opsworks;

import com.pulumi.aws.opsworks.inputs.InstanceEbsBlockDeviceArgs;
import com.pulumi.aws.opsworks.inputs.InstanceEphemeralBlockDeviceArgs;
import com.pulumi.aws.opsworks.inputs.InstanceRootBlockDeviceArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class InstanceArgs extends com.pulumi.resources.ResourceArgs {

    public static final InstanceArgs Empty = new InstanceArgs();

    /**
     * OpsWorks agent to install. Default is `INHERIT`.
     * 
     */
    @Import(name="agentVersion")
    private @Nullable Output<String> agentVersion;

    /**
     * @return OpsWorks agent to install. Default is `INHERIT`.
     * 
     */
    public Optional<Output<String>> agentVersion() {
        return Optional.ofNullable(this.agentVersion);
    }

    /**
     * AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
     * 
     */
    @Import(name="amiId")
    private @Nullable Output<String> amiId;

    /**
     * @return AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
     * 
     */
    public Optional<Output<String>> amiId() {
        return Optional.ofNullable(this.amiId);
    }

    /**
     * Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
     * 
     */
    @Import(name="architecture")
    private @Nullable Output<String> architecture;

    /**
     * @return Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
     * 
     */
    public Optional<Output<String>> architecture() {
        return Optional.ofNullable(this.architecture);
    }

    /**
     * Creates load-based or time-based instances.  Valid values are `load`, `timer`.
     * 
     */
    @Import(name="autoScalingType")
    private @Nullable Output<String> autoScalingType;

    /**
     * @return Creates load-based or time-based instances.  Valid values are `load`, `timer`.
     * 
     */
    public Optional<Output<String>> autoScalingType() {
        return Optional.ofNullable(this.autoScalingType);
    }

    /**
     * Name of the availability zone where instances will be created by default.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return Name of the availability zone where instances will be created by default.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * Time that the instance was created.
     * 
     */
    @Import(name="createdAt")
    private @Nullable Output<String> createdAt;

    /**
     * @return Time that the instance was created.
     * 
     */
    public Optional<Output<String>> createdAt() {
        return Optional.ofNullable(this.createdAt);
    }

    /**
     * Whether to delete EBS volume on deletion. Default is `true`.
     * 
     */
    @Import(name="deleteEbs")
    private @Nullable Output<Boolean> deleteEbs;

    /**
     * @return Whether to delete EBS volume on deletion. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> deleteEbs() {
        return Optional.ofNullable(this.deleteEbs);
    }

    /**
     * Whether to delete the Elastic IP on deletion.
     * 
     */
    @Import(name="deleteEip")
    private @Nullable Output<Boolean> deleteEip;

    /**
     * @return Whether to delete the Elastic IP on deletion.
     * 
     */
    public Optional<Output<Boolean>> deleteEip() {
        return Optional.ofNullable(this.deleteEip);
    }

    /**
     * Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     * 
     */
    @Import(name="ebsBlockDevices")
    private @Nullable Output<List<InstanceEbsBlockDeviceArgs>> ebsBlockDevices;

    /**
     * @return Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
     * 
     */
    public Optional<Output<List<InstanceEbsBlockDeviceArgs>>> ebsBlockDevices() {
        return Optional.ofNullable(this.ebsBlockDevices);
    }

    /**
     * Whether the launched EC2 instance will be EBS-optimized.
     * 
     */
    @Import(name="ebsOptimized")
    private @Nullable Output<Boolean> ebsOptimized;

    /**
     * @return Whether the launched EC2 instance will be EBS-optimized.
     * 
     */
    public Optional<Output<Boolean>> ebsOptimized() {
        return Optional.ofNullable(this.ebsOptimized);
    }

    /**
     * ECS cluster&#39;s ARN for container instances.
     * 
     */
    @Import(name="ecsClusterArn")
    private @Nullable Output<String> ecsClusterArn;

    /**
     * @return ECS cluster&#39;s ARN for container instances.
     * 
     */
    public Optional<Output<String>> ecsClusterArn() {
        return Optional.ofNullable(this.ecsClusterArn);
    }

    /**
     * Instance Elastic IP address.
     * 
     */
    @Import(name="elasticIp")
    private @Nullable Output<String> elasticIp;

    /**
     * @return Instance Elastic IP address.
     * 
     */
    public Optional<Output<String>> elasticIp() {
        return Optional.ofNullable(this.elasticIp);
    }

    /**
     * Configuration block for ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below.
     * 
     */
    @Import(name="ephemeralBlockDevices")
    private @Nullable Output<List<InstanceEphemeralBlockDeviceArgs>> ephemeralBlockDevices;

    /**
     * @return Configuration block for ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below.
     * 
     */
    public Optional<Output<List<InstanceEphemeralBlockDeviceArgs>>> ephemeralBlockDevices() {
        return Optional.ofNullable(this.ephemeralBlockDevices);
    }

    /**
     * Instance&#39;s host name.
     * 
     */
    @Import(name="hostname")
    private @Nullable Output<String> hostname;

    /**
     * @return Instance&#39;s host name.
     * 
     */
    public Optional<Output<String>> hostname() {
        return Optional.ofNullable(this.hostname);
    }

    /**
     * For registered instances, infrastructure class: ec2 or on-premises.
     * 
     */
    @Import(name="infrastructureClass")
    private @Nullable Output<String> infrastructureClass;

    /**
     * @return For registered instances, infrastructure class: ec2 or on-premises.
     * 
     */
    public Optional<Output<String>> infrastructureClass() {
        return Optional.ofNullable(this.infrastructureClass);
    }

    /**
     * Controls where to install OS and package updates when the instance boots.  Default is `true`.
     * 
     */
    @Import(name="installUpdatesOnBoot")
    private @Nullable Output<Boolean> installUpdatesOnBoot;

    /**
     * @return Controls where to install OS and package updates when the instance boots.  Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> installUpdatesOnBoot() {
        return Optional.ofNullable(this.installUpdatesOnBoot);
    }

    /**
     * ARN of the instance&#39;s IAM profile.
     * 
     */
    @Import(name="instanceProfileArn")
    private @Nullable Output<String> instanceProfileArn;

    /**
     * @return ARN of the instance&#39;s IAM profile.
     * 
     */
    public Optional<Output<String>> instanceProfileArn() {
        return Optional.ofNullable(this.instanceProfileArn);
    }

    /**
     * Type of instance to start.
     * 
     */
    @Import(name="instanceType")
    private @Nullable Output<String> instanceType;

    /**
     * @return Type of instance to start.
     * 
     */
    public Optional<Output<String>> instanceType() {
        return Optional.ofNullable(this.instanceType);
    }

    /**
     * List of the layers the instance will belong to.
     * 
     */
    @Import(name="layerIds", required=true)
    private Output<List<String>> layerIds;

    /**
     * @return List of the layers the instance will belong to.
     * 
     */
    public Output<List<String>> layerIds() {
        return this.layerIds;
    }

    /**
     * Name of operating system that will be installed.
     * 
     */
    @Import(name="os")
    private @Nullable Output<String> os;

    /**
     * @return Name of operating system that will be installed.
     * 
     */
    public Optional<Output<String>> os() {
        return Optional.ofNullable(this.os);
    }

    /**
     * Configuration block for the root block device of the instance. See Block Devices below.
     * 
     */
    @Import(name="rootBlockDevices")
    private @Nullable Output<List<InstanceRootBlockDeviceArgs>> rootBlockDevices;

    /**
     * @return Configuration block for the root block device of the instance. See Block Devices below.
     * 
     */
    public Optional<Output<List<InstanceRootBlockDeviceArgs>>> rootBlockDevices() {
        return Optional.ofNullable(this.rootBlockDevices);
    }

    /**
     * Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
     * 
     */
    @Import(name="rootDeviceType")
    private @Nullable Output<String> rootDeviceType;

    /**
     * @return Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
     * 
     */
    public Optional<Output<String>> rootDeviceType() {
        return Optional.ofNullable(this.rootDeviceType);
    }

    /**
     * Associated security groups.
     * 
     */
    @Import(name="securityGroupIds")
    private @Nullable Output<List<String>> securityGroupIds;

    /**
     * @return Associated security groups.
     * 
     */
    public Optional<Output<List<String>>> securityGroupIds() {
        return Optional.ofNullable(this.securityGroupIds);
    }

    /**
     * Name of the SSH keypair that instances will have by default.
     * 
     */
    @Import(name="sshKeyName")
    private @Nullable Output<String> sshKeyName;

    /**
     * @return Name of the SSH keypair that instances will have by default.
     * 
     */
    public Optional<Output<String>> sshKeyName() {
        return Optional.ofNullable(this.sshKeyName);
    }

    /**
     * Identifier of the stack the instance will belong to.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="stackId", required=true)
    private Output<String> stackId;

    /**
     * @return Identifier of the stack the instance will belong to.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> stackId() {
        return this.stackId;
    }

    /**
     * Desired state of the instance. Valid values are `running` or `stopped`.
     * 
     */
    @Import(name="state")
    private @Nullable Output<String> state;

    /**
     * @return Desired state of the instance. Valid values are `running` or `stopped`.
     * 
     */
    public Optional<Output<String>> state() {
        return Optional.ofNullable(this.state);
    }

    /**
     * Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
     * 
     */
    @Import(name="status")
    private @Nullable Output<String> status;

    /**
     * @return Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
     * 
     */
    public Optional<Output<String>> status() {
        return Optional.ofNullable(this.status);
    }

    /**
     * Subnet ID to attach to.
     * 
     */
    @Import(name="subnetId")
    private @Nullable Output<String> subnetId;

    /**
     * @return Subnet ID to attach to.
     * 
     */
    public Optional<Output<String>> subnetId() {
        return Optional.ofNullable(this.subnetId);
    }

    /**
     * Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
     * 
     */
    @Import(name="tenancy")
    private @Nullable Output<String> tenancy;

    /**
     * @return Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
     * 
     */
    public Optional<Output<String>> tenancy() {
        return Optional.ofNullable(this.tenancy);
    }

    /**
     * Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
     * 
     */
    @Import(name="virtualizationType")
    private @Nullable Output<String> virtualizationType;

    /**
     * @return Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
     * 
     */
    public Optional<Output<String>> virtualizationType() {
        return Optional.ofNullable(this.virtualizationType);
    }

    private InstanceArgs() {}

    private InstanceArgs(InstanceArgs $) {
        this.agentVersion = $.agentVersion;
        this.amiId = $.amiId;
        this.architecture = $.architecture;
        this.autoScalingType = $.autoScalingType;
        this.availabilityZone = $.availabilityZone;
        this.createdAt = $.createdAt;
        this.deleteEbs = $.deleteEbs;
        this.deleteEip = $.deleteEip;
        this.ebsBlockDevices = $.ebsBlockDevices;
        this.ebsOptimized = $.ebsOptimized;
        this.ecsClusterArn = $.ecsClusterArn;
        this.elasticIp = $.elasticIp;
        this.ephemeralBlockDevices = $.ephemeralBlockDevices;
        this.hostname = $.hostname;
        this.infrastructureClass = $.infrastructureClass;
        this.installUpdatesOnBoot = $.installUpdatesOnBoot;
        this.instanceProfileArn = $.instanceProfileArn;
        this.instanceType = $.instanceType;
        this.layerIds = $.layerIds;
        this.os = $.os;
        this.rootBlockDevices = $.rootBlockDevices;
        this.rootDeviceType = $.rootDeviceType;
        this.securityGroupIds = $.securityGroupIds;
        this.sshKeyName = $.sshKeyName;
        this.stackId = $.stackId;
        this.state = $.state;
        this.status = $.status;
        this.subnetId = $.subnetId;
        this.tenancy = $.tenancy;
        this.virtualizationType = $.virtualizationType;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(InstanceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private InstanceArgs $;

        public Builder() {
            $ = new InstanceArgs();
        }

        public Builder(InstanceArgs defaults) {
            $ = new InstanceArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param agentVersion OpsWorks agent to install. Default is `INHERIT`.
         * 
         * @return builder
         * 
         */
        public Builder agentVersion(@Nullable Output<String> agentVersion) {
            $.agentVersion = agentVersion;
            return this;
        }

        /**
         * @param agentVersion OpsWorks agent to install. Default is `INHERIT`.
         * 
         * @return builder
         * 
         */
        public Builder agentVersion(String agentVersion) {
            return agentVersion(Output.of(agentVersion));
        }

        /**
         * @param amiId AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
         * 
         * @return builder
         * 
         */
        public Builder amiId(@Nullable Output<String> amiId) {
            $.amiId = amiId;
            return this;
        }

        /**
         * @param amiId AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
         * 
         * @return builder
         * 
         */
        public Builder amiId(String amiId) {
            return amiId(Output.of(amiId));
        }

        /**
         * @param architecture Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
         * 
         * @return builder
         * 
         */
        public Builder architecture(@Nullable Output<String> architecture) {
            $.architecture = architecture;
            return this;
        }

        /**
         * @param architecture Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
         * 
         * @return builder
         * 
         */
        public Builder architecture(String architecture) {
            return architecture(Output.of(architecture));
        }

        /**
         * @param autoScalingType Creates load-based or time-based instances.  Valid values are `load`, `timer`.
         * 
         * @return builder
         * 
         */
        public Builder autoScalingType(@Nullable Output<String> autoScalingType) {
            $.autoScalingType = autoScalingType;
            return this;
        }

        /**
         * @param autoScalingType Creates load-based or time-based instances.  Valid values are `load`, `timer`.
         * 
         * @return builder
         * 
         */
        public Builder autoScalingType(String autoScalingType) {
            return autoScalingType(Output.of(autoScalingType));
        }

        /**
         * @param availabilityZone Name of the availability zone where instances will be created by default.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone Name of the availability zone where instances will be created by default.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param createdAt Time that the instance was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(@Nullable Output<String> createdAt) {
            $.createdAt = createdAt;
            return this;
        }

        /**
         * @param createdAt Time that the instance was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(String createdAt) {
            return createdAt(Output.of(createdAt));
        }

        /**
         * @param deleteEbs Whether to delete EBS volume on deletion. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder deleteEbs(@Nullable Output<Boolean> deleteEbs) {
            $.deleteEbs = deleteEbs;
            return this;
        }

        /**
         * @param deleteEbs Whether to delete EBS volume on deletion. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder deleteEbs(Boolean deleteEbs) {
            return deleteEbs(Output.of(deleteEbs));
        }

        /**
         * @param deleteEip Whether to delete the Elastic IP on deletion.
         * 
         * @return builder
         * 
         */
        public Builder deleteEip(@Nullable Output<Boolean> deleteEip) {
            $.deleteEip = deleteEip;
            return this;
        }

        /**
         * @param deleteEip Whether to delete the Elastic IP on deletion.
         * 
         * @return builder
         * 
         */
        public Builder deleteEip(Boolean deleteEip) {
            return deleteEip(Output.of(deleteEip));
        }

        /**
         * @param ebsBlockDevices Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
         * 
         * @return builder
         * 
         */
        public Builder ebsBlockDevices(@Nullable Output<List<InstanceEbsBlockDeviceArgs>> ebsBlockDevices) {
            $.ebsBlockDevices = ebsBlockDevices;
            return this;
        }

        /**
         * @param ebsBlockDevices Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
         * 
         * @return builder
         * 
         */
        public Builder ebsBlockDevices(List<InstanceEbsBlockDeviceArgs> ebsBlockDevices) {
            return ebsBlockDevices(Output.of(ebsBlockDevices));
        }

        /**
         * @param ebsBlockDevices Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
         * 
         * @return builder
         * 
         */
        public Builder ebsBlockDevices(InstanceEbsBlockDeviceArgs... ebsBlockDevices) {
            return ebsBlockDevices(List.of(ebsBlockDevices));
        }

        /**
         * @param ebsOptimized Whether the launched EC2 instance will be EBS-optimized.
         * 
         * @return builder
         * 
         */
        public Builder ebsOptimized(@Nullable Output<Boolean> ebsOptimized) {
            $.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * @param ebsOptimized Whether the launched EC2 instance will be EBS-optimized.
         * 
         * @return builder
         * 
         */
        public Builder ebsOptimized(Boolean ebsOptimized) {
            return ebsOptimized(Output.of(ebsOptimized));
        }

        /**
         * @param ecsClusterArn ECS cluster&#39;s ARN for container instances.
         * 
         * @return builder
         * 
         */
        public Builder ecsClusterArn(@Nullable Output<String> ecsClusterArn) {
            $.ecsClusterArn = ecsClusterArn;
            return this;
        }

        /**
         * @param ecsClusterArn ECS cluster&#39;s ARN for container instances.
         * 
         * @return builder
         * 
         */
        public Builder ecsClusterArn(String ecsClusterArn) {
            return ecsClusterArn(Output.of(ecsClusterArn));
        }

        /**
         * @param elasticIp Instance Elastic IP address.
         * 
         * @return builder
         * 
         */
        public Builder elasticIp(@Nullable Output<String> elasticIp) {
            $.elasticIp = elasticIp;
            return this;
        }

        /**
         * @param elasticIp Instance Elastic IP address.
         * 
         * @return builder
         * 
         */
        public Builder elasticIp(String elasticIp) {
            return elasticIp(Output.of(elasticIp));
        }

        /**
         * @param ephemeralBlockDevices Configuration block for ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below.
         * 
         * @return builder
         * 
         */
        public Builder ephemeralBlockDevices(@Nullable Output<List<InstanceEphemeralBlockDeviceArgs>> ephemeralBlockDevices) {
            $.ephemeralBlockDevices = ephemeralBlockDevices;
            return this;
        }

        /**
         * @param ephemeralBlockDevices Configuration block for ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below.
         * 
         * @return builder
         * 
         */
        public Builder ephemeralBlockDevices(List<InstanceEphemeralBlockDeviceArgs> ephemeralBlockDevices) {
            return ephemeralBlockDevices(Output.of(ephemeralBlockDevices));
        }

        /**
         * @param ephemeralBlockDevices Configuration block for ephemeral (also known as &#34;Instance Store&#34;) volumes on the instance. See Block Devices below.
         * 
         * @return builder
         * 
         */
        public Builder ephemeralBlockDevices(InstanceEphemeralBlockDeviceArgs... ephemeralBlockDevices) {
            return ephemeralBlockDevices(List.of(ephemeralBlockDevices));
        }

        /**
         * @param hostname Instance&#39;s host name.
         * 
         * @return builder
         * 
         */
        public Builder hostname(@Nullable Output<String> hostname) {
            $.hostname = hostname;
            return this;
        }

        /**
         * @param hostname Instance&#39;s host name.
         * 
         * @return builder
         * 
         */
        public Builder hostname(String hostname) {
            return hostname(Output.of(hostname));
        }

        /**
         * @param infrastructureClass For registered instances, infrastructure class: ec2 or on-premises.
         * 
         * @return builder
         * 
         */
        public Builder infrastructureClass(@Nullable Output<String> infrastructureClass) {
            $.infrastructureClass = infrastructureClass;
            return this;
        }

        /**
         * @param infrastructureClass For registered instances, infrastructure class: ec2 or on-premises.
         * 
         * @return builder
         * 
         */
        public Builder infrastructureClass(String infrastructureClass) {
            return infrastructureClass(Output.of(infrastructureClass));
        }

        /**
         * @param installUpdatesOnBoot Controls where to install OS and package updates when the instance boots.  Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder installUpdatesOnBoot(@Nullable Output<Boolean> installUpdatesOnBoot) {
            $.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        /**
         * @param installUpdatesOnBoot Controls where to install OS and package updates when the instance boots.  Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            return installUpdatesOnBoot(Output.of(installUpdatesOnBoot));
        }

        /**
         * @param instanceProfileArn ARN of the instance&#39;s IAM profile.
         * 
         * @return builder
         * 
         */
        public Builder instanceProfileArn(@Nullable Output<String> instanceProfileArn) {
            $.instanceProfileArn = instanceProfileArn;
            return this;
        }

        /**
         * @param instanceProfileArn ARN of the instance&#39;s IAM profile.
         * 
         * @return builder
         * 
         */
        public Builder instanceProfileArn(String instanceProfileArn) {
            return instanceProfileArn(Output.of(instanceProfileArn));
        }

        /**
         * @param instanceType Type of instance to start.
         * 
         * @return builder
         * 
         */
        public Builder instanceType(@Nullable Output<String> instanceType) {
            $.instanceType = instanceType;
            return this;
        }

        /**
         * @param instanceType Type of instance to start.
         * 
         * @return builder
         * 
         */
        public Builder instanceType(String instanceType) {
            return instanceType(Output.of(instanceType));
        }

        /**
         * @param layerIds List of the layers the instance will belong to.
         * 
         * @return builder
         * 
         */
        public Builder layerIds(Output<List<String>> layerIds) {
            $.layerIds = layerIds;
            return this;
        }

        /**
         * @param layerIds List of the layers the instance will belong to.
         * 
         * @return builder
         * 
         */
        public Builder layerIds(List<String> layerIds) {
            return layerIds(Output.of(layerIds));
        }

        /**
         * @param layerIds List of the layers the instance will belong to.
         * 
         * @return builder
         * 
         */
        public Builder layerIds(String... layerIds) {
            return layerIds(List.of(layerIds));
        }

        /**
         * @param os Name of operating system that will be installed.
         * 
         * @return builder
         * 
         */
        public Builder os(@Nullable Output<String> os) {
            $.os = os;
            return this;
        }

        /**
         * @param os Name of operating system that will be installed.
         * 
         * @return builder
         * 
         */
        public Builder os(String os) {
            return os(Output.of(os));
        }

        /**
         * @param rootBlockDevices Configuration block for the root block device of the instance. See Block Devices below.
         * 
         * @return builder
         * 
         */
        public Builder rootBlockDevices(@Nullable Output<List<InstanceRootBlockDeviceArgs>> rootBlockDevices) {
            $.rootBlockDevices = rootBlockDevices;
            return this;
        }

        /**
         * @param rootBlockDevices Configuration block for the root block device of the instance. See Block Devices below.
         * 
         * @return builder
         * 
         */
        public Builder rootBlockDevices(List<InstanceRootBlockDeviceArgs> rootBlockDevices) {
            return rootBlockDevices(Output.of(rootBlockDevices));
        }

        /**
         * @param rootBlockDevices Configuration block for the root block device of the instance. See Block Devices below.
         * 
         * @return builder
         * 
         */
        public Builder rootBlockDevices(InstanceRootBlockDeviceArgs... rootBlockDevices) {
            return rootBlockDevices(List.of(rootBlockDevices));
        }

        /**
         * @param rootDeviceType Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
         * 
         * @return builder
         * 
         */
        public Builder rootDeviceType(@Nullable Output<String> rootDeviceType) {
            $.rootDeviceType = rootDeviceType;
            return this;
        }

        /**
         * @param rootDeviceType Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
         * 
         * @return builder
         * 
         */
        public Builder rootDeviceType(String rootDeviceType) {
            return rootDeviceType(Output.of(rootDeviceType));
        }

        /**
         * @param securityGroupIds Associated security groups.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(@Nullable Output<List<String>> securityGroupIds) {
            $.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * @param securityGroupIds Associated security groups.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(List<String> securityGroupIds) {
            return securityGroupIds(Output.of(securityGroupIds));
        }

        /**
         * @param securityGroupIds Associated security groups.
         * 
         * @return builder
         * 
         */
        public Builder securityGroupIds(String... securityGroupIds) {
            return securityGroupIds(List.of(securityGroupIds));
        }

        /**
         * @param sshKeyName Name of the SSH keypair that instances will have by default.
         * 
         * @return builder
         * 
         */
        public Builder sshKeyName(@Nullable Output<String> sshKeyName) {
            $.sshKeyName = sshKeyName;
            return this;
        }

        /**
         * @param sshKeyName Name of the SSH keypair that instances will have by default.
         * 
         * @return builder
         * 
         */
        public Builder sshKeyName(String sshKeyName) {
            return sshKeyName(Output.of(sshKeyName));
        }

        /**
         * @param stackId Identifier of the stack the instance will belong to.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder stackId(Output<String> stackId) {
            $.stackId = stackId;
            return this;
        }

        /**
         * @param stackId Identifier of the stack the instance will belong to.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder stackId(String stackId) {
            return stackId(Output.of(stackId));
        }

        /**
         * @param state Desired state of the instance. Valid values are `running` or `stopped`.
         * 
         * @return builder
         * 
         */
        public Builder state(@Nullable Output<String> state) {
            $.state = state;
            return this;
        }

        /**
         * @param state Desired state of the instance. Valid values are `running` or `stopped`.
         * 
         * @return builder
         * 
         */
        public Builder state(String state) {
            return state(Output.of(state));
        }

        /**
         * @param status Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
         * 
         * @return builder
         * 
         */
        public Builder status(@Nullable Output<String> status) {
            $.status = status;
            return this;
        }

        /**
         * @param status Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
         * 
         * @return builder
         * 
         */
        public Builder status(String status) {
            return status(Output.of(status));
        }

        /**
         * @param subnetId Subnet ID to attach to.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(@Nullable Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId Subnet ID to attach to.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        /**
         * @param tenancy Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
         * 
         * @return builder
         * 
         */
        public Builder tenancy(@Nullable Output<String> tenancy) {
            $.tenancy = tenancy;
            return this;
        }

        /**
         * @param tenancy Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
         * 
         * @return builder
         * 
         */
        public Builder tenancy(String tenancy) {
            return tenancy(Output.of(tenancy));
        }

        /**
         * @param virtualizationType Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
         * 
         * @return builder
         * 
         */
        public Builder virtualizationType(@Nullable Output<String> virtualizationType) {
            $.virtualizationType = virtualizationType;
            return this;
        }

        /**
         * @param virtualizationType Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
         * 
         * @return builder
         * 
         */
        public Builder virtualizationType(String virtualizationType) {
            return virtualizationType(Output.of(virtualizationType));
        }

        public InstanceArgs build() {
            $.layerIds = Objects.requireNonNull($.layerIds, "expected parameter 'layerIds' to be non-null");
            $.stackId = Objects.requireNonNull($.stackId, "expected parameter 'stackId' to be non-null");
            return $;
        }
    }

}
