// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.opensearch.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class DomainCognitoOptionsArgs extends com.pulumi.resources.ResourceArgs {

    public static final DomainCognitoOptionsArgs Empty = new DomainCognitoOptionsArgs();

    /**
     * Whether Amazon Cognito authentication with Dashboard is enabled or not. Default is `false`.
     * 
     */
    @Import(name="enabled")
    private @Nullable Output<Boolean> enabled;

    /**
     * @return Whether Amazon Cognito authentication with Dashboard is enabled or not. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> enabled() {
        return Optional.ofNullable(this.enabled);
    }

    /**
     * ID of the Cognito Identity Pool to use.
     * 
     */
    @Import(name="identityPoolId", required=true)
    private Output<String> identityPoolId;

    /**
     * @return ID of the Cognito Identity Pool to use.
     * 
     */
    public Output<String> identityPoolId() {
        return this.identityPoolId;
    }

    /**
     * ARN of the IAM role that has the AmazonOpenSearchServiceCognitoAccess policy attached.
     * 
     */
    @Import(name="roleArn", required=true)
    private Output<String> roleArn;

    /**
     * @return ARN of the IAM role that has the AmazonOpenSearchServiceCognitoAccess policy attached.
     * 
     */
    public Output<String> roleArn() {
        return this.roleArn;
    }

    /**
     * ID of the Cognito User Pool to use.
     * 
     */
    @Import(name="userPoolId", required=true)
    private Output<String> userPoolId;

    /**
     * @return ID of the Cognito User Pool to use.
     * 
     */
    public Output<String> userPoolId() {
        return this.userPoolId;
    }

    private DomainCognitoOptionsArgs() {}

    private DomainCognitoOptionsArgs(DomainCognitoOptionsArgs $) {
        this.enabled = $.enabled;
        this.identityPoolId = $.identityPoolId;
        this.roleArn = $.roleArn;
        this.userPoolId = $.userPoolId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DomainCognitoOptionsArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DomainCognitoOptionsArgs $;

        public Builder() {
            $ = new DomainCognitoOptionsArgs();
        }

        public Builder(DomainCognitoOptionsArgs defaults) {
            $ = new DomainCognitoOptionsArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param enabled Whether Amazon Cognito authentication with Dashboard is enabled or not. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder enabled(@Nullable Output<Boolean> enabled) {
            $.enabled = enabled;
            return this;
        }

        /**
         * @param enabled Whether Amazon Cognito authentication with Dashboard is enabled or not. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder enabled(Boolean enabled) {
            return enabled(Output.of(enabled));
        }

        /**
         * @param identityPoolId ID of the Cognito Identity Pool to use.
         * 
         * @return builder
         * 
         */
        public Builder identityPoolId(Output<String> identityPoolId) {
            $.identityPoolId = identityPoolId;
            return this;
        }

        /**
         * @param identityPoolId ID of the Cognito Identity Pool to use.
         * 
         * @return builder
         * 
         */
        public Builder identityPoolId(String identityPoolId) {
            return identityPoolId(Output.of(identityPoolId));
        }

        /**
         * @param roleArn ARN of the IAM role that has the AmazonOpenSearchServiceCognitoAccess policy attached.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(Output<String> roleArn) {
            $.roleArn = roleArn;
            return this;
        }

        /**
         * @param roleArn ARN of the IAM role that has the AmazonOpenSearchServiceCognitoAccess policy attached.
         * 
         * @return builder
         * 
         */
        public Builder roleArn(String roleArn) {
            return roleArn(Output.of(roleArn));
        }

        /**
         * @param userPoolId ID of the Cognito User Pool to use.
         * 
         * @return builder
         * 
         */
        public Builder userPoolId(Output<String> userPoolId) {
            $.userPoolId = userPoolId;
            return this;
        }

        /**
         * @param userPoolId ID of the Cognito User Pool to use.
         * 
         * @return builder
         * 
         */
        public Builder userPoolId(String userPoolId) {
            return userPoolId(Output.of(userPoolId));
        }

        public DomainCognitoOptionsArgs build() {
            $.identityPoolId = Objects.requireNonNull($.identityPoolId, "expected parameter 'identityPoolId' to be non-null");
            $.roleArn = Objects.requireNonNull($.roleArn, "expected parameter 'roleArn' to be non-null");
            $.userPoolId = Objects.requireNonNull($.userPoolId, "expected parameter 'userPoolId' to be non-null");
            return $;
        }
    }

}
