// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.opensearch;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
import com.pulumi.aws.opensearch.inputs.ServerlessAccessPolicyState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS OpenSearch Serverless Access Policy. See AWS documentation for [data access policies](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html) and [supported data access policy permissions](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html#serverless-data-supported-permissions).
 * 
 * ## Example Usage
 * ### Grant all collection and index permissions
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicy;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 * 
 *         var example = new ServerlessAccessPolicy(&#34;example&#34;, ServerlessAccessPolicyArgs.builder()        
 *             .type(&#34;data&#34;)
 *             .description(&#34;read and write permissions&#34;)
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty(&#34;Rules&#34;, jsonArray(
 *                         jsonObject(
 *                             jsonProperty(&#34;ResourceType&#34;, &#34;index&#34;),
 *                             jsonProperty(&#34;Resource&#34;, jsonArray(&#34;index/example-collection/*&#34;)),
 *                             jsonProperty(&#34;Permission&#34;, jsonArray(&#34;aoss:*&#34;))
 *                         ), 
 *                         jsonObject(
 *                             jsonProperty(&#34;ResourceType&#34;, &#34;collection&#34;),
 *                             jsonProperty(&#34;Resource&#34;, jsonArray(&#34;collection/example-collection&#34;)),
 *                             jsonProperty(&#34;Permission&#34;, jsonArray(&#34;aoss:*&#34;))
 *                         )
 *                     )),
 *                     jsonProperty(&#34;Principal&#34;, jsonArray(current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.arn())))
 *                 ))))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Grant read-only collection and index permissions
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicy;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 * 
 *         var example = new ServerlessAccessPolicy(&#34;example&#34;, ServerlessAccessPolicyArgs.builder()        
 *             .type(&#34;data&#34;)
 *             .description(&#34;read-only permissions&#34;)
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty(&#34;Rules&#34;, jsonArray(
 *                         jsonObject(
 *                             jsonProperty(&#34;ResourceType&#34;, &#34;index&#34;),
 *                             jsonProperty(&#34;Resource&#34;, jsonArray(&#34;index/example-collection/*&#34;)),
 *                             jsonProperty(&#34;Permission&#34;, jsonArray(
 *                                 &#34;aoss:DescribeIndex&#34;, 
 *                                 &#34;aoss:ReadDocument&#34;
 *                             ))
 *                         ), 
 *                         jsonObject(
 *                             jsonProperty(&#34;ResourceType&#34;, &#34;collection&#34;),
 *                             jsonProperty(&#34;Resource&#34;, jsonArray(&#34;collection/example-collection&#34;)),
 *                             jsonProperty(&#34;Permission&#34;, jsonArray(&#34;aoss:DescribeCollectionItems&#34;))
 *                         )
 *                     )),
 *                     jsonProperty(&#34;Principal&#34;, jsonArray(current.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.arn())))
 *                 ))))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Grant SAML identity permissions
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicy;
 * import com.pulumi.aws.opensearch.ServerlessAccessPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessAccessPolicy(&#34;example&#34;, ServerlessAccessPolicyArgs.builder()        
 *             .type(&#34;data&#34;)
 *             .description(&#34;saml permissions&#34;)
 *             .policy(serializeJson(
 *                 jsonArray(jsonObject(
 *                     jsonProperty(&#34;Rules&#34;, jsonArray(
 *                         jsonObject(
 *                             jsonProperty(&#34;ResourceType&#34;, &#34;index&#34;),
 *                             jsonProperty(&#34;Resource&#34;, jsonArray(&#34;index/example-collection/*&#34;)),
 *                             jsonProperty(&#34;Permission&#34;, jsonArray(&#34;aoss:*&#34;))
 *                         ), 
 *                         jsonObject(
 *                             jsonProperty(&#34;ResourceType&#34;, &#34;collection&#34;),
 *                             jsonProperty(&#34;Resource&#34;, jsonArray(&#34;collection/example-collection&#34;)),
 *                             jsonProperty(&#34;Permission&#34;, jsonArray(&#34;aoss:*&#34;))
 *                         )
 *                     )),
 *                     jsonProperty(&#34;Principal&#34;, jsonArray(
 *                         &#34;saml/123456789012/myprovider/user/Annie&#34;, 
 *                         &#34;saml/123456789012/anotherprovider/group/Accounting&#34;
 *                     ))
 *                 ))))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import OpenSearchServerless Access Policy using the `name` and `type` arguments separated by a slash (`/`). For example:
 * 
 * ```sh
 *  $ pulumi import aws:opensearch/serverlessAccessPolicy:ServerlessAccessPolicy example example/data
 * ```
 * 
 */
@ResourceType(type="aws:opensearch/serverlessAccessPolicy:ServerlessAccessPolicy")
public class ServerlessAccessPolicy extends com.pulumi.resources.CustomResource {
    /**
     * Description of the policy. Typically used to store information about the permissions defined in the policy.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description of the policy. Typically used to store information about the permissions defined in the policy.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Name of the policy.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the policy.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * JSON policy document to use as the content for the new policy
     * 
     */
    @Export(name="policy", refs={String.class}, tree="[0]")
    private Output<String> policy;

    /**
     * @return JSON policy document to use as the content for the new policy
     * 
     */
    public Output<String> policy() {
        return this.policy;
    }
    /**
     * Version of the policy.
     * 
     */
    @Export(name="policyVersion", refs={String.class}, tree="[0]")
    private Output<String> policyVersion;

    /**
     * @return Version of the policy.
     * 
     */
    public Output<String> policyVersion() {
        return this.policyVersion;
    }
    /**
     * Type of access policy. Must be `data`.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output<String> type;

    /**
     * @return Type of access policy. Must be `data`.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ServerlessAccessPolicy(String name) {
        this(name, ServerlessAccessPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ServerlessAccessPolicy(String name, ServerlessAccessPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ServerlessAccessPolicy(String name, ServerlessAccessPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opensearch/serverlessAccessPolicy:ServerlessAccessPolicy", name, args == null ? ServerlessAccessPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ServerlessAccessPolicy(String name, Output<String> id, @Nullable ServerlessAccessPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opensearch/serverlessAccessPolicy:ServerlessAccessPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ServerlessAccessPolicy get(String name, Output<String> id, @Nullable ServerlessAccessPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ServerlessAccessPolicy(name, id, state, options);
    }
}
