// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.opensearch;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.opensearch.OutboundConnectionArgs;
import com.pulumi.aws.opensearch.inputs.OutboundConnectionState;
import com.pulumi.aws.opensearch.outputs.OutboundConnectionLocalDomainInfo;
import com.pulumi.aws.opensearch.outputs.OutboundConnectionRemoteDomainInfo;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages an AWS Opensearch Outbound Connection.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.opensearch.OutboundConnection;
 * import com.pulumi.aws.opensearch.OutboundConnectionArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionLocalDomainInfoArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 * 
 *         final var currentRegion = AwsFunctions.getRegion();
 * 
 *         var foo = new OutboundConnection(&#34;foo&#34;, OutboundConnectionArgs.builder()        
 *             .connectionAlias(&#34;outbound_connection&#34;)
 *             .localDomainInfo(OutboundConnectionLocalDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -&gt; getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.local_domain().domain_name())
 *                 .build())
 *             .remoteDomainInfo(OutboundConnectionRemoteDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -&gt; getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.remote_domain().domain_name())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import AWS Opensearch Outbound Connections using the Outbound Connection ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:opensearch/outboundConnection:OutboundConnection foo connection-id
 * ```
 * 
 */
@ResourceType(type="aws:opensearch/outboundConnection:OutboundConnection")
public class OutboundConnection extends com.pulumi.resources.CustomResource {
    /**
     * Specifies the connection alias that will be used by the customer for this connection.
     * 
     */
    @Export(name="connectionAlias", refs={String.class}, tree="[0]")
    private Output<String> connectionAlias;

    /**
     * @return Specifies the connection alias that will be used by the customer for this connection.
     * 
     */
    public Output<String> connectionAlias() {
        return this.connectionAlias;
    }
    /**
     * Status of the connection request.
     * 
     */
    @Export(name="connectionStatus", refs={String.class}, tree="[0]")
    private Output<String> connectionStatus;

    /**
     * @return Status of the connection request.
     * 
     */
    public Output<String> connectionStatus() {
        return this.connectionStatus;
    }
    /**
     * Configuration block for the local Opensearch domain.
     * 
     */
    @Export(name="localDomainInfo", refs={OutboundConnectionLocalDomainInfo.class}, tree="[0]")
    private Output<OutboundConnectionLocalDomainInfo> localDomainInfo;

    /**
     * @return Configuration block for the local Opensearch domain.
     * 
     */
    public Output<OutboundConnectionLocalDomainInfo> localDomainInfo() {
        return this.localDomainInfo;
    }
    /**
     * Configuration block for the remote Opensearch domain.
     * 
     */
    @Export(name="remoteDomainInfo", refs={OutboundConnectionRemoteDomainInfo.class}, tree="[0]")
    private Output<OutboundConnectionRemoteDomainInfo> remoteDomainInfo;

    /**
     * @return Configuration block for the remote Opensearch domain.
     * 
     */
    public Output<OutboundConnectionRemoteDomainInfo> remoteDomainInfo() {
        return this.remoteDomainInfo;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public OutboundConnection(String name) {
        this(name, OutboundConnectionArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public OutboundConnection(String name, OutboundConnectionArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public OutboundConnection(String name, OutboundConnectionArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opensearch/outboundConnection:OutboundConnection", name, args == null ? OutboundConnectionArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private OutboundConnection(String name, Output<String> id, @Nullable OutboundConnectionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opensearch/outboundConnection:OutboundConnection", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static OutboundConnection get(String name, Output<String> id, @Nullable OutboundConnectionState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new OutboundConnection(name, id, state, options);
    }
}
