// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.opensearch;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.opensearch.InboundConnectionAccepterArgs;
import com.pulumi.aws.opensearch.inputs.InboundConnectionAccepterState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages an [AWS Opensearch Inbound Connection Accepter](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_AcceptInboundConnection.html). If connecting domains from different AWS accounts, ensure that the accepter is configured to use the AWS account where the _remote_ opensearch domain exists.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.opensearch.OutboundConnection;
 * import com.pulumi.aws.opensearch.OutboundConnectionArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionLocalDomainInfoArgs;
 * import com.pulumi.aws.opensearch.inputs.OutboundConnectionRemoteDomainInfoArgs;
 * import com.pulumi.aws.opensearch.InboundConnectionAccepter;
 * import com.pulumi.aws.opensearch.InboundConnectionAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 * 
 *         final var currentRegion = AwsFunctions.getRegion();
 * 
 *         var fooOutboundConnection = new OutboundConnection(&#34;fooOutboundConnection&#34;, OutboundConnectionArgs.builder()        
 *             .connectionAlias(&#34;outbound_connection&#34;)
 *             .localDomainInfo(OutboundConnectionLocalDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -&gt; getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.local_domain().domain_name())
 *                 .build())
 *             .remoteDomainInfo(OutboundConnectionRemoteDomainInfoArgs.builder()
 *                 .ownerId(currentCallerIdentity.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()))
 *                 .region(currentRegion.applyValue(getRegionResult -&gt; getRegionResult.name()))
 *                 .domainName(aws_opensearch_domain.remote_domain().domain_name())
 *                 .build())
 *             .build());
 * 
 *         var fooInboundConnectionAccepter = new InboundConnectionAccepter(&#34;fooInboundConnectionAccepter&#34;, InboundConnectionAccepterArgs.builder()        
 *             .connectionId(fooOutboundConnection.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import AWS Opensearch Inbound Connection Accepters using the Inbound Connection ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:opensearch/inboundConnectionAccepter:InboundConnectionAccepter foo connection-id
 * ```
 * 
 */
@ResourceType(type="aws:opensearch/inboundConnectionAccepter:InboundConnectionAccepter")
public class InboundConnectionAccepter extends com.pulumi.resources.CustomResource {
    /**
     * Specifies the ID of the connection to accept.
     * 
     */
    @Export(name="connectionId", refs={String.class}, tree="[0]")
    private Output<String> connectionId;

    /**
     * @return Specifies the ID of the connection to accept.
     * 
     */
    public Output<String> connectionId() {
        return this.connectionId;
    }
    /**
     * Status of the connection request.
     * 
     */
    @Export(name="connectionStatus", refs={String.class}, tree="[0]")
    private Output<String> connectionStatus;

    /**
     * @return Status of the connection request.
     * 
     */
    public Output<String> connectionStatus() {
        return this.connectionStatus;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public InboundConnectionAccepter(String name) {
        this(name, InboundConnectionAccepterArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public InboundConnectionAccepter(String name, InboundConnectionAccepterArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public InboundConnectionAccepter(String name, InboundConnectionAccepterArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opensearch/inboundConnectionAccepter:InboundConnectionAccepter", name, args == null ? InboundConnectionAccepterArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private InboundConnectionAccepter(String name, Output<String> id, @Nullable InboundConnectionAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:opensearch/inboundConnectionAccepter:InboundConnectionAccepter", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static InboundConnectionAccepter get(String name, Output<String> id, @Nullable InboundConnectionAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new InboundConnectionAccepter(name, id, state, options);
    }
}
