// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.oam;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.oam.SinkArgs;
import com.pulumi.aws.oam.inputs.SinkState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS CloudWatch Observability Access Manager Sink.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.oam.Sink;
 * import com.pulumi.aws.oam.SinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Sink(&#34;example&#34;, SinkArgs.builder()        
 *             .tags(Map.of(&#34;Env&#34;, &#34;prod&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import CloudWatch Observability Access Manager Sink using the `arn`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:oam/sink:Sink example arn:aws:oam:us-west-2:123456789012:sink/sink-id
 * ```
 * 
 */
@ResourceType(type="aws:oam/sink:Sink")
public class Sink extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the Sink.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the Sink.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Name for the sink.
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name for the sink.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * ID string that AWS generated as part of the sink ARN.
     * 
     */
    @Export(name="sinkId", refs={String.class}, tree="[0]")
    private Output<String> sinkId;

    /**
     * @return ID string that AWS generated as part of the sink ARN.
     * 
     */
    public Output<String> sinkId() {
        return this.sinkId;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Sink(String name) {
        this(name, SinkArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Sink(String name, @Nullable SinkArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Sink(String name, @Nullable SinkArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:oam/sink:Sink", name, args == null ? SinkArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Sink(String name, Output<String> id, @Nullable SinkState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:oam/sink:Sink", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Sink get(String name, Output<String> id, @Nullable SinkState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Sink(name, id, state, options);
    }
}
