// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.networkmanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.networkmanager.LinkAssociationArgs;
import com.pulumi.aws.networkmanager.inputs.LinkAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Associates a link to a device.
 * A device can be associated to multiple links and a link can be associated to multiple devices.
 * The device and link must be in the same global network and the same site.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.LinkAssociation;
 * import com.pulumi.aws.networkmanager.LinkAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new LinkAssociation(&#34;example&#34;, LinkAssociationArgs.builder()        
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .linkId(aws_networkmanager_link.example().id())
 *             .deviceId(aws_networkmanager_device.example().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_networkmanager_link_association` using the global network ID, link ID and device ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:networkmanager/linkAssociation:LinkAssociation example global-network-0d47f6t230mz46dy4,link-444555aaabbb11223,device-07f6fd08867abc123
 * ```
 * 
 */
@ResourceType(type="aws:networkmanager/linkAssociation:LinkAssociation")
public class LinkAssociation extends com.pulumi.resources.CustomResource {
    /**
     * The ID of the device.
     * 
     */
    @Export(name="deviceId", refs={String.class}, tree="[0]")
    private Output<String> deviceId;

    /**
     * @return The ID of the device.
     * 
     */
    public Output<String> deviceId() {
        return this.deviceId;
    }
    /**
     * The ID of the global network.
     * 
     */
    @Export(name="globalNetworkId", refs={String.class}, tree="[0]")
    private Output<String> globalNetworkId;

    /**
     * @return The ID of the global network.
     * 
     */
    public Output<String> globalNetworkId() {
        return this.globalNetworkId;
    }
    /**
     * The ID of the link.
     * 
     */
    @Export(name="linkId", refs={String.class}, tree="[0]")
    private Output<String> linkId;

    /**
     * @return The ID of the link.
     * 
     */
    public Output<String> linkId() {
        return this.linkId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LinkAssociation(String name) {
        this(name, LinkAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LinkAssociation(String name, LinkAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LinkAssociation(String name, LinkAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/linkAssociation:LinkAssociation", name, args == null ? LinkAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LinkAssociation(String name, Output<String> id, @Nullable LinkAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/linkAssociation:LinkAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LinkAssociation get(String name, Output<String> id, @Nullable LinkAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LinkAssociation(name, id, state, options);
    }
}
