// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.networkmanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.networkmanager.LinkArgs;
import com.pulumi.aws.networkmanager.inputs.LinkState;
import com.pulumi.aws.networkmanager.outputs.LinkBandwidth;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Creates a link for a site.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.Link;
 * import com.pulumi.aws.networkmanager.LinkArgs;
 * import com.pulumi.aws.networkmanager.inputs.LinkBandwidthArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Link(&#34;example&#34;, LinkArgs.builder()        
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .siteId(aws_networkmanager_site.example().id())
 *             .bandwidth(LinkBandwidthArgs.builder()
 *                 .uploadSpeed(10)
 *                 .downloadSpeed(50)
 *                 .build())
 *             .providerName(&#34;MegaCorp&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_networkmanager_link` using the link ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:networkmanager/link:Link example arn:aws:networkmanager::123456789012:link/global-network-0d47f6t230mz46dy4/link-444555aaabbb11223
 * ```
 * 
 */
@ResourceType(type="aws:networkmanager/link:Link")
public class Link extends com.pulumi.resources.CustomResource {
    /**
     * Link Amazon Resource Name (ARN).
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Link Amazon Resource Name (ARN).
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The upload speed and download speed in Mbps. Documented below.
     * 
     */
    @Export(name="bandwidth", refs={LinkBandwidth.class}, tree="[0]")
    private Output<LinkBandwidth> bandwidth;

    /**
     * @return The upload speed and download speed in Mbps. Documented below.
     * 
     */
    public Output<LinkBandwidth> bandwidth() {
        return this.bandwidth;
    }
    /**
     * A description of the link.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A description of the link.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * The ID of the global network.
     * 
     */
    @Export(name="globalNetworkId", refs={String.class}, tree="[0]")
    private Output<String> globalNetworkId;

    /**
     * @return The ID of the global network.
     * 
     */
    public Output<String> globalNetworkId() {
        return this.globalNetworkId;
    }
    /**
     * The provider of the link.
     * 
     */
    @Export(name="providerName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> providerName;

    /**
     * @return The provider of the link.
     * 
     */
    public Output<Optional<String>> providerName() {
        return Codegen.optional(this.providerName);
    }
    /**
     * The ID of the site.
     * 
     */
    @Export(name="siteId", refs={String.class}, tree="[0]")
    private Output<String> siteId;

    /**
     * @return The ID of the site.
     * 
     */
    public Output<String> siteId() {
        return this.siteId;
    }
    /**
     * Key-value tags for the link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value tags for the link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The type of the link.
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> type;

    /**
     * @return The type of the link.
     * 
     */
    public Output<Optional<String>> type() {
        return Codegen.optional(this.type);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Link(String name) {
        this(name, LinkArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Link(String name, LinkArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Link(String name, LinkArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/link:Link", name, args == null ? LinkArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Link(String name, Output<String> id, @Nullable LinkState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/link:Link", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Link get(String name, Output<String> id, @Nullable LinkState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Link(name, id, state, options);
    }
}
