// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.networkmanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.networkmanager.CustomerGatewayAssociationArgs;
import com.pulumi.aws.networkmanager.inputs.CustomerGatewayAssociationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Associates a customer gateway with a device and optionally, with a link.
 * If you specify a link, it must be associated with the specified device.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.GlobalNetworkArgs;
 * import com.pulumi.aws.networkmanager.Site;
 * import com.pulumi.aws.networkmanager.SiteArgs;
 * import com.pulumi.aws.networkmanager.Device;
 * import com.pulumi.aws.networkmanager.DeviceArgs;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import com.pulumi.aws.networkmanager.TransitGatewayRegistration;
 * import com.pulumi.aws.networkmanager.TransitGatewayRegistrationArgs;
 * import com.pulumi.aws.networkmanager.CustomerGatewayAssociation;
 * import com.pulumi.aws.networkmanager.CustomerGatewayAssociationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork(&#34;exampleGlobalNetwork&#34;, GlobalNetworkArgs.builder()        
 *             .description(&#34;example&#34;)
 *             .build());
 * 
 *         var exampleSite = new Site(&#34;exampleSite&#34;, SiteArgs.builder()        
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .build());
 * 
 *         var exampleDevice = new Device(&#34;exampleDevice&#34;, DeviceArgs.builder()        
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .siteId(exampleSite.id())
 *             .build());
 * 
 *         var exampleCustomerGateway = new CustomerGateway(&#34;exampleCustomerGateway&#34;, CustomerGatewayArgs.builder()        
 *             .bgpAsn(65000)
 *             .ipAddress(&#34;172.83.124.10&#34;)
 *             .type(&#34;ipsec.1&#34;)
 *             .build());
 * 
 *         var exampleTransitGateway = new TransitGateway(&#34;exampleTransitGateway&#34;);
 * 
 *         var exampleVpnConnection = new VpnConnection(&#34;exampleVpnConnection&#34;, VpnConnectionArgs.builder()        
 *             .customerGatewayId(exampleCustomerGateway.id())
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .type(exampleCustomerGateway.type())
 *             .staticRoutesOnly(true)
 *             .build());
 * 
 *         var exampleTransitGatewayRegistration = new TransitGatewayRegistration(&#34;exampleTransitGatewayRegistration&#34;, TransitGatewayRegistrationArgs.builder()        
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .transitGatewayArn(exampleTransitGateway.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleVpnConnection)
 *                 .build());
 * 
 *         var exampleCustomerGatewayAssociation = new CustomerGatewayAssociation(&#34;exampleCustomerGatewayAssociation&#34;, CustomerGatewayAssociationArgs.builder()        
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .customerGatewayArn(exampleCustomerGateway.arn())
 *             .deviceId(exampleDevice.id())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleTransitGatewayRegistration)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_networkmanager_customer_gateway_association` using the global network ID and customer gateway ARN. For example:
 * 
 * ```sh
 *  $ pulumi import aws:networkmanager/customerGatewayAssociation:CustomerGatewayAssociation example global-network-0d47f6t230mz46dy4,arn:aws:ec2:us-west-2:123456789012:customer-gateway/cgw-123abc05e04123abc
 * ```
 * 
 */
@ResourceType(type="aws:networkmanager/customerGatewayAssociation:CustomerGatewayAssociation")
public class CustomerGatewayAssociation extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the customer gateway.
     * 
     */
    @Export(name="customerGatewayArn", refs={String.class}, tree="[0]")
    private Output<String> customerGatewayArn;

    /**
     * @return The Amazon Resource Name (ARN) of the customer gateway.
     * 
     */
    public Output<String> customerGatewayArn() {
        return this.customerGatewayArn;
    }
    /**
     * The ID of the device.
     * 
     */
    @Export(name="deviceId", refs={String.class}, tree="[0]")
    private Output<String> deviceId;

    /**
     * @return The ID of the device.
     * 
     */
    public Output<String> deviceId() {
        return this.deviceId;
    }
    /**
     * The ID of the global network.
     * 
     */
    @Export(name="globalNetworkId", refs={String.class}, tree="[0]")
    private Output<String> globalNetworkId;

    /**
     * @return The ID of the global network.
     * 
     */
    public Output<String> globalNetworkId() {
        return this.globalNetworkId;
    }
    /**
     * The ID of the link.
     * 
     */
    @Export(name="linkId", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> linkId;

    /**
     * @return The ID of the link.
     * 
     */
    public Output<Optional<String>> linkId() {
        return Codegen.optional(this.linkId);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public CustomerGatewayAssociation(String name) {
        this(name, CustomerGatewayAssociationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public CustomerGatewayAssociation(String name, CustomerGatewayAssociationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public CustomerGatewayAssociation(String name, CustomerGatewayAssociationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/customerGatewayAssociation:CustomerGatewayAssociation", name, args == null ? CustomerGatewayAssociationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private CustomerGatewayAssociation(String name, Output<String> id, @Nullable CustomerGatewayAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/customerGatewayAssociation:CustomerGatewayAssociation", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static CustomerGatewayAssociation get(String name, Output<String> id, @Nullable CustomerGatewayAssociationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new CustomerGatewayAssociation(name, id, state, options);
    }
}
