// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.networkmanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
import com.pulumi.aws.networkmanager.inputs.CoreNetworkPolicyAttachmentState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a Core Network Policy Attachment resource. This puts a Core Network Policy to an existing Core Network and executes the change set, which deploys changes globally based on the policy submitted (Sets the policy to `LIVE`).
 * 
 * &gt; **NOTE:** Deleting this resource will not delete the current policy defined in this resource. Deleting this resource will also not revert the current `LIVE` policy to the previous version.
 * 
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleCoreNetwork = new CoreNetwork(&#34;exampleCoreNetwork&#34;, CoreNetworkArgs.builder()        
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .build());
 * 
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment(&#34;exampleCoreNetworkPolicyAttachment&#34;, CoreNetworkPolicyAttachmentArgs.builder()        
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(data.aws_networkmanager_core_network_policy_document().example().json())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### With VPC Attachment (Single Region)
 * 
 * The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument of the `aws.networkmanager.CoreNetwork` resource to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork(&#34;exampleGlobalNetwork&#34;);
 * 
 *         var exampleCoreNetwork = new CoreNetwork(&#34;exampleCoreNetwork&#34;, CoreNetworkArgs.builder()        
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .createBasePolicy(true)
 *             .build());
 * 
 *         var exampleVpcAttachment = new VpcAttachment(&#34;exampleVpcAttachment&#34;, VpcAttachmentArgs.builder()        
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example().stream().map(element -&gt; element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example().arn())
 *             .build());
 * 
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges(&#34;65022-65534&#34;)
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location(&#34;us-west-2&#34;)
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name(&#34;segment&#34;)
 *                 .build())
 *             .segmentActions(GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                 .action(&#34;create-route&#34;)
 *                 .segment(&#34;segment&#34;)
 *                 .destinationCidrBlocks(&#34;0.0.0.0/0&#34;)
 *                 .destinations(exampleVpcAttachment.id())
 *                 .build())
 *             .build());
 * 
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment(&#34;exampleCoreNetworkPolicyAttachment&#34;, CoreNetworkPolicyAttachmentArgs.builder()        
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -&gt; getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -&gt; exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -&gt; getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### With VPC Attachment (Multi-Region)
 * 
 * The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument of the `aws.networkmanager.CoreNetwork` resource to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument. For multi-region in a core network that does not yet have a `LIVE` policy, pass a list of regions to the `aws.networkmanager.CoreNetwork` `base_policy_regions` argument. In the example below, `us-west-2` and `us-east-1` are specified in the base policy.
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork(&#34;exampleGlobalNetwork&#34;);
 * 
 *         var exampleCoreNetwork = new CoreNetwork(&#34;exampleCoreNetwork&#34;, CoreNetworkArgs.builder()        
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyRegions(            
 *                 &#34;us-west-2&#34;,
 *                 &#34;us-east-1&#34;)
 *             .createBasePolicy(true)
 *             .build());
 * 
 *         var exampleUsWest2 = new VpcAttachment(&#34;exampleUsWest2&#34;, VpcAttachmentArgs.builder()        
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_west_2().stream().map(element -&gt; element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_west_2().arn())
 *             .build());
 * 
 *         var exampleUsEast1 = new VpcAttachment(&#34;exampleUsEast1&#34;, VpcAttachmentArgs.builder()        
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_east_1().stream().map(element -&gt; element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_east_1().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(&#34;alternate&#34;)
 *                 .build());
 * 
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges(&#34;65022-65534&#34;)
 *                 .edgeLocations(                
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location(&#34;us-west-2&#34;)
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location(&#34;us-east-1&#34;)
 *                         .build())
 *                 .build())
 *             .segments(            
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name(&#34;segment&#34;)
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name(&#34;segment2&#34;)
 *                     .build())
 *             .segmentActions(            
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action(&#34;create-route&#34;)
 *                     .segment(&#34;segment&#34;)
 *                     .destinationCidrBlocks(&#34;10.0.0.0/16&#34;)
 *                     .destinations(exampleUsWest2.id())
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action(&#34;create-route&#34;)
 *                     .segment(&#34;segment&#34;)
 *                     .destinationCidrBlocks(&#34;10.1.0.0/16&#34;)
 *                     .destinations(exampleUsEast1.id())
 *                     .build())
 *             .build());
 * 
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment(&#34;exampleCoreNetworkPolicyAttachment&#34;, CoreNetworkPolicyAttachmentArgs.builder()        
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -&gt; getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -&gt; exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -&gt; getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import `aws_networkmanager_core_network_policy_attachment` using the core network ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:networkmanager/coreNetworkPolicyAttachment:CoreNetworkPolicyAttachment example core-network-0d47f6t230mz46dy4
 * ```
 * 
 */
@ResourceType(type="aws:networkmanager/coreNetworkPolicyAttachment:CoreNetworkPolicyAttachment")
public class CoreNetworkPolicyAttachment extends com.pulumi.resources.CustomResource {
    /**
     * The ID of the core network that a policy will be attached to and made `LIVE`.
     * 
     */
    @Export(name="coreNetworkId", refs={String.class}, tree="[0]")
    private Output<String> coreNetworkId;

    /**
     * @return The ID of the core network that a policy will be attached to and made `LIVE`.
     * 
     */
    public Output<String> coreNetworkId() {
        return this.coreNetworkId;
    }
    /**
     * Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
     * 
     */
    @Export(name="policyDocument", refs={String.class}, tree="[0]")
    private Output<String> policyDocument;

    /**
     * @return Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
     * 
     */
    public Output<String> policyDocument() {
        return this.policyDocument;
    }
    /**
     * Current state of a core network.
     * 
     */
    @Export(name="state", refs={String.class}, tree="[0]")
    private Output<String> state;

    /**
     * @return Current state of a core network.
     * 
     */
    public Output<String> state() {
        return this.state;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public CoreNetworkPolicyAttachment(String name) {
        this(name, CoreNetworkPolicyAttachmentArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public CoreNetworkPolicyAttachment(String name, CoreNetworkPolicyAttachmentArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public CoreNetworkPolicyAttachment(String name, CoreNetworkPolicyAttachmentArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/coreNetworkPolicyAttachment:CoreNetworkPolicyAttachment", name, args == null ? CoreNetworkPolicyAttachmentArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private CoreNetworkPolicyAttachment(String name, Output<String> id, @Nullable CoreNetworkPolicyAttachmentState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/coreNetworkPolicyAttachment:CoreNetworkPolicyAttachment", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static CoreNetworkPolicyAttachment get(String name, Output<String> id, @Nullable CoreNetworkPolicyAttachmentState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new CoreNetworkPolicyAttachment(name, id, state, options);
    }
}
