// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.networkmanager;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
import com.pulumi.aws.networkmanager.inputs.AttachmentAccepterState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS NetworkManager Attachment Accepter.
 * 
 * ## Example Usage
 * ### Example with VPC attachment
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new AttachmentAccepter(&#34;test&#34;, AttachmentAccepterArgs.builder()        
 *             .attachmentId(aws_networkmanager_vpc_attachment.vpc().id())
 *             .attachmentType(aws_networkmanager_vpc_attachment.vpc().attachment_type())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Example with site-to-site VPN attachment
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var test = new AttachmentAccepter(&#34;test&#34;, AttachmentAccepterArgs.builder()        
 *             .attachmentId(aws_networkmanager_site_to_site_vpn_attachment.vpn().id())
 *             .attachmentType(aws_networkmanager_site_to_site_vpn_attachment.vpn().attachment_type())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:networkmanager/attachmentAccepter:AttachmentAccepter")
public class AttachmentAccepter extends com.pulumi.resources.CustomResource {
    /**
     * The ID of the attachment.
     * 
     */
    @Export(name="attachmentId", refs={String.class}, tree="[0]")
    private Output<String> attachmentId;

    /**
     * @return The ID of the attachment.
     * 
     */
    public Output<String> attachmentId() {
        return this.attachmentId;
    }
    /**
     * The policy rule number associated with the attachment.
     * 
     */
    @Export(name="attachmentPolicyRuleNumber", refs={Integer.class}, tree="[0]")
    private Output<Integer> attachmentPolicyRuleNumber;

    /**
     * @return The policy rule number associated with the attachment.
     * 
     */
    public Output<Integer> attachmentPolicyRuleNumber() {
        return this.attachmentPolicyRuleNumber;
    }
    /**
     * The type of attachment. Valid values can be found in the [AWS Documentation](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListAttachments.html#API_ListAttachments_RequestSyntax)
     * 
     */
    @Export(name="attachmentType", refs={String.class}, tree="[0]")
    private Output<String> attachmentType;

    /**
     * @return The type of attachment. Valid values can be found in the [AWS Documentation](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListAttachments.html#API_ListAttachments_RequestSyntax)
     * 
     */
    public Output<String> attachmentType() {
        return this.attachmentType;
    }
    /**
     * The ARN of a core network.
     * 
     */
    @Export(name="coreNetworkArn", refs={String.class}, tree="[0]")
    private Output<String> coreNetworkArn;

    /**
     * @return The ARN of a core network.
     * 
     */
    public Output<String> coreNetworkArn() {
        return this.coreNetworkArn;
    }
    /**
     * The id of a core network.
     * 
     */
    @Export(name="coreNetworkId", refs={String.class}, tree="[0]")
    private Output<String> coreNetworkId;

    /**
     * @return The id of a core network.
     * 
     */
    public Output<String> coreNetworkId() {
        return this.coreNetworkId;
    }
    /**
     * The Region where the edge is located.
     * 
     */
    @Export(name="edgeLocation", refs={String.class}, tree="[0]")
    private Output<String> edgeLocation;

    /**
     * @return The Region where the edge is located.
     * 
     */
    public Output<String> edgeLocation() {
        return this.edgeLocation;
    }
    /**
     * The ID of the attachment account owner.
     * 
     */
    @Export(name="ownerAccountId", refs={String.class}, tree="[0]")
    private Output<String> ownerAccountId;

    /**
     * @return The ID of the attachment account owner.
     * 
     */
    public Output<String> ownerAccountId() {
        return this.ownerAccountId;
    }
    /**
     * The attachment resource ARN.
     * 
     */
    @Export(name="resourceArn", refs={String.class}, tree="[0]")
    private Output<String> resourceArn;

    /**
     * @return The attachment resource ARN.
     * 
     */
    public Output<String> resourceArn() {
        return this.resourceArn;
    }
    /**
     * The name of the segment attachment.
     * 
     */
    @Export(name="segmentName", refs={String.class}, tree="[0]")
    private Output<String> segmentName;

    /**
     * @return The name of the segment attachment.
     * 
     */
    public Output<String> segmentName() {
        return this.segmentName;
    }
    /**
     * The state of the attachment.
     * 
     */
    @Export(name="state", refs={String.class}, tree="[0]")
    private Output<String> state;

    /**
     * @return The state of the attachment.
     * 
     */
    public Output<String> state() {
        return this.state;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public AttachmentAccepter(String name) {
        this(name, AttachmentAccepterArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public AttachmentAccepter(String name, AttachmentAccepterArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public AttachmentAccepter(String name, AttachmentAccepterArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/attachmentAccepter:AttachmentAccepter", name, args == null ? AttachmentAccepterArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private AttachmentAccepter(String name, Output<String> id, @Nullable AttachmentAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkmanager/attachmentAccepter:AttachmentAccepter", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static AttachmentAccepter get(String name, Output<String> id, @Nullable AttachmentAccepterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new AttachmentAccepter(name, id, state, options);
    }
}
