// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.networkfirewall;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationState;
import com.pulumi.aws.networkfirewall.outputs.LoggingConfigurationLoggingConfiguration;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides an AWS Network Firewall Logging Configuration Resource
 * 
 * ## Example Usage
 * ### Logging to S3
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration(&#34;example&#34;, LoggingConfigurationArgs.builder()        
 *             .firewallArn(aws_networkfirewall_firewall.example().arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.ofEntries(
 *                         Map.entry(&#34;bucketName&#34;, aws_s3_bucket.example().bucket()),
 *                         Map.entry(&#34;prefix&#34;, &#34;/example&#34;)
 *                     ))
 *                     .logDestinationType(&#34;S3&#34;)
 *                     .logType(&#34;FLOW&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Logging to CloudWatch
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration(&#34;example&#34;, LoggingConfigurationArgs.builder()        
 *             .firewallArn(aws_networkfirewall_firewall.example().arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of(&#34;logGroup&#34;, aws_cloudwatch_log_group.example().name()))
 *                     .logDestinationType(&#34;CloudWatchLogs&#34;)
 *                     .logType(&#34;ALERT&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Logging to Kinesis Data Firehose
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.LoggingConfiguration;
 * import com.pulumi.aws.networkfirewall.LoggingConfigurationArgs;
 * import com.pulumi.aws.networkfirewall.inputs.LoggingConfigurationLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new LoggingConfiguration(&#34;example&#34;, LoggingConfigurationArgs.builder()        
 *             .firewallArn(aws_networkfirewall_firewall.example().arn())
 *             .loggingConfiguration(LoggingConfigurationLoggingConfigurationArgs.builder()
 *                 .logDestinationConfigs(LoggingConfigurationLoggingConfigurationLogDestinationConfigArgs.builder()
 *                     .logDestination(Map.of(&#34;deliveryStream&#34;, aws_kinesis_firehose_delivery_stream.example().name()))
 *                     .logDestinationType(&#34;KinesisDataFirehose&#34;)
 *                     .logType(&#34;ALERT&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Network Firewall Logging Configurations using the `firewall_arn`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:networkfirewall/loggingConfiguration:LoggingConfiguration example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
 * ```
 * 
 */
@ResourceType(type="aws:networkfirewall/loggingConfiguration:LoggingConfiguration")
public class LoggingConfiguration extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the Network Firewall firewall.
     * 
     */
    @Export(name="firewallArn", refs={String.class}, tree="[0]")
    private Output<String> firewallArn;

    /**
     * @return The Amazon Resource Name (ARN) of the Network Firewall firewall.
     * 
     */
    public Output<String> firewallArn() {
        return this.firewallArn;
    }
    /**
     * A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     * 
     */
    @Export(name="loggingConfiguration", refs={LoggingConfigurationLoggingConfiguration.class}, tree="[0]")
    private Output<LoggingConfigurationLoggingConfiguration> loggingConfiguration;

    /**
     * @return A configuration block describing how AWS Network Firewall performs logging for a firewall. See Logging Configuration below for details.
     * 
     */
    public Output<LoggingConfigurationLoggingConfiguration> loggingConfiguration() {
        return this.loggingConfiguration;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public LoggingConfiguration(String name) {
        this(name, LoggingConfigurationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public LoggingConfiguration(String name, LoggingConfigurationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public LoggingConfiguration(String name, LoggingConfigurationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkfirewall/loggingConfiguration:LoggingConfiguration", name, args == null ? LoggingConfigurationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private LoggingConfiguration(String name, Output<String> id, @Nullable LoggingConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkfirewall/loggingConfiguration:LoggingConfiguration", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static LoggingConfiguration get(String name, Output<String> id, @Nullable LoggingConfigurationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new LoggingConfiguration(name, id, state, options);
    }
}
