// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.networkfirewall;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.networkfirewall.FirewallArgs;
import com.pulumi.aws.networkfirewall.inputs.FirewallState;
import com.pulumi.aws.networkfirewall.outputs.FirewallEncryptionConfiguration;
import com.pulumi.aws.networkfirewall.outputs.FirewallFirewallStatus;
import com.pulumi.aws.networkfirewall.outputs.FirewallSubnetMapping;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an AWS Network Firewall Firewall Resource
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkfirewall.Firewall;
 * import com.pulumi.aws.networkfirewall.FirewallArgs;
 * import com.pulumi.aws.networkfirewall.inputs.FirewallSubnetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Firewall(&#34;example&#34;, FirewallArgs.builder()        
 *             .firewallPolicyArn(aws_networkfirewall_firewall_policy.example().arn())
 *             .vpcId(aws_vpc.example().id())
 *             .subnetMappings(FirewallSubnetMappingArgs.builder()
 *                 .subnetId(aws_subnet.example().id())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry(&#34;Tag1&#34;, &#34;Value1&#34;),
 *                 Map.entry(&#34;Tag2&#34;, &#34;Value2&#34;)
 *             ))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Network Firewall Firewalls using their `arn`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:networkfirewall/firewall:Firewall example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
 * ```
 * 
 */
@ResourceType(type="aws:networkfirewall/firewall:Firewall")
public class Firewall extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) that identifies the firewall.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) that identifies the firewall.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * A boolean flag indicating whether it is possible to delete the firewall. Defaults to `false`.
     * 
     */
    @Export(name="deleteProtection", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> deleteProtection;

    /**
     * @return A boolean flag indicating whether it is possible to delete the firewall. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> deleteProtection() {
        return Codegen.optional(this.deleteProtection);
    }
    /**
     * A friendly description of the firewall.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A friendly description of the firewall.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * KMS encryption configuration settings. See Encryption Configuration below for details.
     * 
     */
    @Export(name="encryptionConfiguration", refs={FirewallEncryptionConfiguration.class}, tree="[0]")
    private Output</* @Nullable */ FirewallEncryptionConfiguration> encryptionConfiguration;

    /**
     * @return KMS encryption configuration settings. See Encryption Configuration below for details.
     * 
     */
    public Output<Optional<FirewallEncryptionConfiguration>> encryptionConfiguration() {
        return Codegen.optional(this.encryptionConfiguration);
    }
    /**
     * The Amazon Resource Name (ARN) of the VPC Firewall policy.
     * 
     */
    @Export(name="firewallPolicyArn", refs={String.class}, tree="[0]")
    private Output<String> firewallPolicyArn;

    /**
     * @return The Amazon Resource Name (ARN) of the VPC Firewall policy.
     * 
     */
    public Output<String> firewallPolicyArn() {
        return this.firewallPolicyArn;
    }
    /**
     * A boolean flag indicating whether it is possible to change the associated firewall policy. Defaults to `false`.
     * 
     */
    @Export(name="firewallPolicyChangeProtection", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> firewallPolicyChangeProtection;

    /**
     * @return A boolean flag indicating whether it is possible to change the associated firewall policy. Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> firewallPolicyChangeProtection() {
        return Codegen.optional(this.firewallPolicyChangeProtection);
    }
    /**
     * Nested list of information about the current status of the firewall.
     * 
     */
    @Export(name="firewallStatuses", refs={List.class,FirewallFirewallStatus.class}, tree="[0,1]")
    private Output<List<FirewallFirewallStatus>> firewallStatuses;

    /**
     * @return Nested list of information about the current status of the firewall.
     * 
     */
    public Output<List<FirewallFirewallStatus>> firewallStatuses() {
        return this.firewallStatuses;
    }
    /**
     * A friendly name of the firewall.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return A friendly name of the firewall.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * A boolean flag indicating whether it is possible to change the associated subnet(s). Defaults to `false`.
     * 
     */
    @Export(name="subnetChangeProtection", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> subnetChangeProtection;

    /**
     * @return A boolean flag indicating whether it is possible to change the associated subnet(s). Defaults to `false`.
     * 
     */
    public Output<Optional<Boolean>> subnetChangeProtection() {
        return Codegen.optional(this.subnetChangeProtection);
    }
    /**
     * Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     * 
     */
    @Export(name="subnetMappings", refs={List.class,FirewallSubnetMapping.class}, tree="[0,1]")
    private Output<List<FirewallSubnetMapping>> subnetMappings;

    /**
     * @return Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
     * 
     */
    public Output<List<FirewallSubnetMapping>> subnetMappings() {
        return this.subnetMappings;
    }
    /**
     * Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * A string token used when updating a firewall.
     * 
     */
    @Export(name="updateToken", refs={String.class}, tree="[0]")
    private Output<String> updateToken;

    /**
     * @return A string token used when updating a firewall.
     * 
     */
    public Output<String> updateToken() {
        return this.updateToken;
    }
    /**
     * The unique identifier of the VPC where AWS Network Firewall should create the firewall.
     * 
     */
    @Export(name="vpcId", refs={String.class}, tree="[0]")
    private Output<String> vpcId;

    /**
     * @return The unique identifier of the VPC where AWS Network Firewall should create the firewall.
     * 
     */
    public Output<String> vpcId() {
        return this.vpcId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Firewall(String name) {
        this(name, FirewallArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Firewall(String name, FirewallArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Firewall(String name, FirewallArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkfirewall/firewall:Firewall", name, args == null ? FirewallArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Firewall(String name, Output<String> id, @Nullable FirewallState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:networkfirewall/firewall:Firewall", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Firewall get(String name, Output<String> id, @Nullable FirewallState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Firewall(name, id, state, options);
    }
}
