// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.neptune.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterInstanceState extends com.pulumi.resources.ResourceArgs {

    public static final ClusterInstanceState Empty = new ClusterInstanceState();

    /**
     * The hostname of the instance. See also `endpoint` and `port`.
     * 
     */
    @Import(name="address")
    private @Nullable Output<String> address;

    /**
     * @return The hostname of the instance. See also `endpoint` and `port`.
     * 
     */
    public Optional<Output<String>> address() {
        return Optional.ofNullable(this.address);
    }

    /**
     * Specifies whether any instance modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return Specifies whether any instance modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * Amazon Resource Name (ARN) of neptune instance
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of neptune instance
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
     * 
     */
    @Import(name="autoMinorVersionUpgrade")
    private @Nullable Output<Boolean> autoMinorVersionUpgrade;

    /**
     * @return Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> autoMinorVersionUpgrade() {
        return Optional.ofNullable(this.autoMinorVersionUpgrade);
    }

    /**
     * The EC2 Availability Zone that the neptune instance is created in.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return The EC2 Availability Zone that the neptune instance is created in.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * The identifier of the `aws.neptune.Cluster` in which to launch this instance.
     * 
     */
    @Import(name="clusterIdentifier")
    private @Nullable Output<String> clusterIdentifier;

    /**
     * @return The identifier of the `aws.neptune.Cluster` in which to launch this instance.
     * 
     */
    public Optional<Output<String>> clusterIdentifier() {
        return Optional.ofNullable(this.clusterIdentifier);
    }

    /**
     * The region-unique, immutable identifier for the neptune instance.
     * 
     */
    @Import(name="dbiResourceId")
    private @Nullable Output<String> dbiResourceId;

    /**
     * @return The region-unique, immutable identifier for the neptune instance.
     * 
     */
    public Optional<Output<String>> dbiResourceId() {
        return Optional.ofNullable(this.dbiResourceId);
    }

    /**
     * The connection endpoint in `address:port` format.
     * 
     */
    @Import(name="endpoint")
    private @Nullable Output<String> endpoint;

    /**
     * @return The connection endpoint in `address:port` format.
     * 
     */
    public Optional<Output<String>> endpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    /**
     * The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
     * 
     */
    @Import(name="engine")
    private @Nullable Output<String> engine;

    /**
     * @return The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
     * 
     */
    public Optional<Output<String>> engine() {
        return Optional.ofNullable(this.engine);
    }

    /**
     * The neptune engine version.
     * 
     */
    @Import(name="engineVersion")
    private @Nullable Output<String> engineVersion;

    /**
     * @return The neptune engine version.
     * 
     */
    public Optional<Output<String>> engineVersion() {
        return Optional.ofNullable(this.engineVersion);
    }

    /**
     * The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
     * 
     */
    @Import(name="identifier")
    private @Nullable Output<String> identifier;

    /**
     * @return The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
     * 
     */
    public Optional<Output<String>> identifier() {
        return Optional.ofNullable(this.identifier);
    }

    /**
     * Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     * 
     */
    @Import(name="identifierPrefix")
    private @Nullable Output<String> identifierPrefix;

    /**
     * @return Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     * 
     */
    public Optional<Output<String>> identifierPrefix() {
        return Optional.ofNullable(this.identifierPrefix);
    }

    /**
     * The instance class to use.
     * 
     */
    @Import(name="instanceClass")
    private @Nullable Output<String> instanceClass;

    /**
     * @return The instance class to use.
     * 
     */
    public Optional<Output<String>> instanceClass() {
        return Optional.ofNullable(this.instanceClass);
    }

    /**
     * The ARN for the KMS encryption key if one is set to the neptune cluster.
     * 
     */
    @Import(name="kmsKeyArn")
    private @Nullable Output<String> kmsKeyArn;

    /**
     * @return The ARN for the KMS encryption key if one is set to the neptune cluster.
     * 
     */
    public Optional<Output<String>> kmsKeyArn() {
        return Optional.ofNullable(this.kmsKeyArn);
    }

    /**
     * The name of the neptune parameter group to associate with this instance.
     * 
     */
    @Import(name="neptuneParameterGroupName")
    private @Nullable Output<String> neptuneParameterGroupName;

    /**
     * @return The name of the neptune parameter group to associate with this instance.
     * 
     */
    public Optional<Output<String>> neptuneParameterGroupName() {
        return Optional.ofNullable(this.neptuneParameterGroupName);
    }

    /**
     * A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
     * 
     */
    @Import(name="neptuneSubnetGroupName")
    private @Nullable Output<String> neptuneSubnetGroupName;

    /**
     * @return A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
     * 
     */
    public Optional<Output<String>> neptuneSubnetGroupName() {
        return Optional.ofNullable(this.neptuneSubnetGroupName);
    }

    /**
     * The port on which the DB accepts connections. Defaults to `8182`.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return The port on which the DB accepts connections. Defaults to `8182`.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;
     * 
     */
    @Import(name="preferredBackupWindow")
    private @Nullable Output<String> preferredBackupWindow;

    /**
     * @return The daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;
     * 
     */
    public Optional<Output<String>> preferredBackupWindow() {
        return Optional.ofNullable(this.preferredBackupWindow);
    }

    /**
     * The window to perform maintenance in.
     * Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
     * 
     */
    @Import(name="preferredMaintenanceWindow")
    private @Nullable Output<String> preferredMaintenanceWindow;

    /**
     * @return The window to perform maintenance in.
     * Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
     * 
     */
    public Optional<Output<String>> preferredMaintenanceWindow() {
        return Optional.ofNullable(this.preferredMaintenanceWindow);
    }

    /**
     * Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     * 
     */
    @Import(name="promotionTier")
    private @Nullable Output<Integer> promotionTier;

    /**
     * @return Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     * 
     */
    public Optional<Output<Integer>> promotionTier() {
        return Optional.ofNullable(this.promotionTier);
    }

    /**
     * Bool to control if instance is publicly accessible. Default is `false`.
     * 
     */
    @Import(name="publiclyAccessible")
    private @Nullable Output<Boolean> publiclyAccessible;

    /**
     * @return Bool to control if instance is publicly accessible. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> publiclyAccessible() {
        return Optional.ofNullable(this.publiclyAccessible);
    }

    /**
     * Specifies whether the neptune cluster is encrypted.
     * 
     */
    @Import(name="storageEncrypted")
    private @Nullable Output<Boolean> storageEncrypted;

    /**
     * @return Specifies whether the neptune cluster is encrypted.
     * 
     */
    public Optional<Output<Boolean>> storageEncrypted() {
        return Optional.ofNullable(this.storageEncrypted);
    }

    /**
     * A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
     * 
     */
    @Import(name="writer")
    private @Nullable Output<Boolean> writer;

    /**
     * @return Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
     * 
     */
    public Optional<Output<Boolean>> writer() {
        return Optional.ofNullable(this.writer);
    }

    private ClusterInstanceState() {}

    private ClusterInstanceState(ClusterInstanceState $) {
        this.address = $.address;
        this.applyImmediately = $.applyImmediately;
        this.arn = $.arn;
        this.autoMinorVersionUpgrade = $.autoMinorVersionUpgrade;
        this.availabilityZone = $.availabilityZone;
        this.clusterIdentifier = $.clusterIdentifier;
        this.dbiResourceId = $.dbiResourceId;
        this.endpoint = $.endpoint;
        this.engine = $.engine;
        this.engineVersion = $.engineVersion;
        this.identifier = $.identifier;
        this.identifierPrefix = $.identifierPrefix;
        this.instanceClass = $.instanceClass;
        this.kmsKeyArn = $.kmsKeyArn;
        this.neptuneParameterGroupName = $.neptuneParameterGroupName;
        this.neptuneSubnetGroupName = $.neptuneSubnetGroupName;
        this.port = $.port;
        this.preferredBackupWindow = $.preferredBackupWindow;
        this.preferredMaintenanceWindow = $.preferredMaintenanceWindow;
        this.promotionTier = $.promotionTier;
        this.publiclyAccessible = $.publiclyAccessible;
        this.storageEncrypted = $.storageEncrypted;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.writer = $.writer;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterInstanceState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterInstanceState $;

        public Builder() {
            $ = new ClusterInstanceState();
        }

        public Builder(ClusterInstanceState defaults) {
            $ = new ClusterInstanceState(Objects.requireNonNull(defaults));
        }

        /**
         * @param address The hostname of the instance. See also `endpoint` and `port`.
         * 
         * @return builder
         * 
         */
        public Builder address(@Nullable Output<String> address) {
            $.address = address;
            return this;
        }

        /**
         * @param address The hostname of the instance. See also `endpoint` and `port`.
         * 
         * @return builder
         * 
         */
        public Builder address(String address) {
            return address(Output.of(address));
        }

        /**
         * @param applyImmediately Specifies whether any instance modifications
         * are applied immediately, or during the next maintenance window. Default is`false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately Specifies whether any instance modifications
         * are applied immediately, or during the next maintenance window. Default is`false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of neptune instance
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of neptune instance
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(@Nullable Output<Boolean> autoMinorVersionUpgrade) {
            $.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            return autoMinorVersionUpgrade(Output.of(autoMinorVersionUpgrade));
        }

        /**
         * @param availabilityZone The EC2 Availability Zone that the neptune instance is created in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone The EC2 Availability Zone that the neptune instance is created in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param clusterIdentifier The identifier of the `aws.neptune.Cluster` in which to launch this instance.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(@Nullable Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier The identifier of the `aws.neptune.Cluster` in which to launch this instance.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param dbiResourceId The region-unique, immutable identifier for the neptune instance.
         * 
         * @return builder
         * 
         */
        public Builder dbiResourceId(@Nullable Output<String> dbiResourceId) {
            $.dbiResourceId = dbiResourceId;
            return this;
        }

        /**
         * @param dbiResourceId The region-unique, immutable identifier for the neptune instance.
         * 
         * @return builder
         * 
         */
        public Builder dbiResourceId(String dbiResourceId) {
            return dbiResourceId(Output.of(dbiResourceId));
        }

        /**
         * @param endpoint The connection endpoint in `address:port` format.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(@Nullable Output<String> endpoint) {
            $.endpoint = endpoint;
            return this;
        }

        /**
         * @param endpoint The connection endpoint in `address:port` format.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(String endpoint) {
            return endpoint(Output.of(endpoint));
        }

        /**
         * @param engine The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
         * 
         * @return builder
         * 
         */
        public Builder engine(@Nullable Output<String> engine) {
            $.engine = engine;
            return this;
        }

        /**
         * @param engine The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
         * 
         * @return builder
         * 
         */
        public Builder engine(String engine) {
            return engine(Output.of(engine));
        }

        /**
         * @param engineVersion The neptune engine version.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(@Nullable Output<String> engineVersion) {
            $.engineVersion = engineVersion;
            return this;
        }

        /**
         * @param engineVersion The neptune engine version.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(String engineVersion) {
            return engineVersion(Output.of(engineVersion));
        }

        /**
         * @param identifier The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder identifier(@Nullable Output<String> identifier) {
            $.identifier = identifier;
            return this;
        }

        /**
         * @param identifier The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder identifier(String identifier) {
            return identifier(Output.of(identifier));
        }

        /**
         * @param identifierPrefix Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
         * 
         * @return builder
         * 
         */
        public Builder identifierPrefix(@Nullable Output<String> identifierPrefix) {
            $.identifierPrefix = identifierPrefix;
            return this;
        }

        /**
         * @param identifierPrefix Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
         * 
         * @return builder
         * 
         */
        public Builder identifierPrefix(String identifierPrefix) {
            return identifierPrefix(Output.of(identifierPrefix));
        }

        /**
         * @param instanceClass The instance class to use.
         * 
         * @return builder
         * 
         */
        public Builder instanceClass(@Nullable Output<String> instanceClass) {
            $.instanceClass = instanceClass;
            return this;
        }

        /**
         * @param instanceClass The instance class to use.
         * 
         * @return builder
         * 
         */
        public Builder instanceClass(String instanceClass) {
            return instanceClass(Output.of(instanceClass));
        }

        /**
         * @param kmsKeyArn The ARN for the KMS encryption key if one is set to the neptune cluster.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyArn(@Nullable Output<String> kmsKeyArn) {
            $.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * @param kmsKeyArn The ARN for the KMS encryption key if one is set to the neptune cluster.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyArn(String kmsKeyArn) {
            return kmsKeyArn(Output.of(kmsKeyArn));
        }

        /**
         * @param neptuneParameterGroupName The name of the neptune parameter group to associate with this instance.
         * 
         * @return builder
         * 
         */
        public Builder neptuneParameterGroupName(@Nullable Output<String> neptuneParameterGroupName) {
            $.neptuneParameterGroupName = neptuneParameterGroupName;
            return this;
        }

        /**
         * @param neptuneParameterGroupName The name of the neptune parameter group to associate with this instance.
         * 
         * @return builder
         * 
         */
        public Builder neptuneParameterGroupName(String neptuneParameterGroupName) {
            return neptuneParameterGroupName(Output.of(neptuneParameterGroupName));
        }

        /**
         * @param neptuneSubnetGroupName A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
         * 
         * @return builder
         * 
         */
        public Builder neptuneSubnetGroupName(@Nullable Output<String> neptuneSubnetGroupName) {
            $.neptuneSubnetGroupName = neptuneSubnetGroupName;
            return this;
        }

        /**
         * @param neptuneSubnetGroupName A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
         * 
         * @return builder
         * 
         */
        public Builder neptuneSubnetGroupName(String neptuneSubnetGroupName) {
            return neptuneSubnetGroupName(Output.of(neptuneSubnetGroupName));
        }

        /**
         * @param port The port on which the DB accepts connections. Defaults to `8182`.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port The port on which the DB accepts connections. Defaults to `8182`.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(@Nullable Output<String> preferredBackupWindow) {
            $.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(String preferredBackupWindow) {
            return preferredBackupWindow(Output.of(preferredBackupWindow));
        }

        /**
         * @param preferredMaintenanceWindow The window to perform maintenance in.
         * Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(@Nullable Output<String> preferredMaintenanceWindow) {
            $.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * @param preferredMaintenanceWindow The window to perform maintenance in.
         * Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            return preferredMaintenanceWindow(Output.of(preferredMaintenanceWindow));
        }

        /**
         * @param promotionTier Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
         * 
         * @return builder
         * 
         */
        public Builder promotionTier(@Nullable Output<Integer> promotionTier) {
            $.promotionTier = promotionTier;
            return this;
        }

        /**
         * @param promotionTier Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
         * 
         * @return builder
         * 
         */
        public Builder promotionTier(Integer promotionTier) {
            return promotionTier(Output.of(promotionTier));
        }

        /**
         * @param publiclyAccessible Bool to control if instance is publicly accessible. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(@Nullable Output<Boolean> publiclyAccessible) {
            $.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * @param publiclyAccessible Bool to control if instance is publicly accessible. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            return publiclyAccessible(Output.of(publiclyAccessible));
        }

        /**
         * @param storageEncrypted Specifies whether the neptune cluster is encrypted.
         * 
         * @return builder
         * 
         */
        public Builder storageEncrypted(@Nullable Output<Boolean> storageEncrypted) {
            $.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * @param storageEncrypted Specifies whether the neptune cluster is encrypted.
         * 
         * @return builder
         * 
         */
        public Builder storageEncrypted(Boolean storageEncrypted) {
            return storageEncrypted(Output.of(storageEncrypted));
        }

        /**
         * @param tags A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param writer Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
         * 
         * @return builder
         * 
         */
        public Builder writer(@Nullable Output<Boolean> writer) {
            $.writer = writer;
            return this;
        }

        /**
         * @param writer Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
         * 
         * @return builder
         * 
         */
        public Builder writer(Boolean writer) {
            return writer(Output.of(writer));
        }

        public ClusterInstanceState build() {
            return $;
        }
    }

}
