// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.neptune.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterEndpointState extends com.pulumi.resources.ResourceArgs {

    public static final ClusterEndpointState Empty = new ClusterEndpointState();

    /**
     * The Neptune Cluster Endpoint Amazon Resource Name (ARN).
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return The Neptune Cluster Endpoint Amazon Resource Name (ARN).
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The identifier of the endpoint.
     * 
     */
    @Import(name="clusterEndpointIdentifier")
    private @Nullable Output<String> clusterEndpointIdentifier;

    /**
     * @return The identifier of the endpoint.
     * 
     */
    public Optional<Output<String>> clusterEndpointIdentifier() {
        return Optional.ofNullable(this.clusterEndpointIdentifier);
    }

    /**
     * The DB cluster identifier of the DB cluster associated with the endpoint.
     * 
     */
    @Import(name="clusterIdentifier")
    private @Nullable Output<String> clusterIdentifier;

    /**
     * @return The DB cluster identifier of the DB cluster associated with the endpoint.
     * 
     */
    public Optional<Output<String>> clusterIdentifier() {
        return Optional.ofNullable(this.clusterIdentifier);
    }

    /**
     * The DNS address of the endpoint.
     * 
     */
    @Import(name="endpoint")
    private @Nullable Output<String> endpoint;

    /**
     * @return The DNS address of the endpoint.
     * 
     */
    public Optional<Output<String>> endpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    /**
     * The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
     * 
     */
    @Import(name="endpointType")
    private @Nullable Output<String> endpointType;

    /**
     * @return The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
     * 
     */
    public Optional<Output<String>> endpointType() {
        return Optional.ofNullable(this.endpointType);
    }

    /**
     * List of DB instance identifiers that aren&#39;t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     * 
     */
    @Import(name="excludedMembers")
    private @Nullable Output<List<String>> excludedMembers;

    /**
     * @return List of DB instance identifiers that aren&#39;t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
     * 
     */
    public Optional<Output<List<String>>> excludedMembers() {
        return Optional.ofNullable(this.excludedMembers);
    }

    /**
     * List of DB instance identifiers that are part of the custom endpoint group.
     * 
     */
    @Import(name="staticMembers")
    private @Nullable Output<List<String>> staticMembers;

    /**
     * @return List of DB instance identifiers that are part of the custom endpoint group.
     * 
     */
    public Optional<Output<List<String>>> staticMembers() {
        return Optional.ofNullable(this.staticMembers);
    }

    /**
     * A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    private ClusterEndpointState() {}

    private ClusterEndpointState(ClusterEndpointState $) {
        this.arn = $.arn;
        this.clusterEndpointIdentifier = $.clusterEndpointIdentifier;
        this.clusterIdentifier = $.clusterIdentifier;
        this.endpoint = $.endpoint;
        this.endpointType = $.endpointType;
        this.excludedMembers = $.excludedMembers;
        this.staticMembers = $.staticMembers;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterEndpointState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterEndpointState $;

        public Builder() {
            $ = new ClusterEndpointState();
        }

        public Builder(ClusterEndpointState defaults) {
            $ = new ClusterEndpointState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn The Neptune Cluster Endpoint Amazon Resource Name (ARN).
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn The Neptune Cluster Endpoint Amazon Resource Name (ARN).
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param clusterEndpointIdentifier The identifier of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder clusterEndpointIdentifier(@Nullable Output<String> clusterEndpointIdentifier) {
            $.clusterEndpointIdentifier = clusterEndpointIdentifier;
            return this;
        }

        /**
         * @param clusterEndpointIdentifier The identifier of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder clusterEndpointIdentifier(String clusterEndpointIdentifier) {
            return clusterEndpointIdentifier(Output.of(clusterEndpointIdentifier));
        }

        /**
         * @param clusterIdentifier The DB cluster identifier of the DB cluster associated with the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(@Nullable Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier The DB cluster identifier of the DB cluster associated with the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param endpoint The DNS address of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(@Nullable Output<String> endpoint) {
            $.endpoint = endpoint;
            return this;
        }

        /**
         * @param endpoint The DNS address of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(String endpoint) {
            return endpoint(Output.of(endpoint));
        }

        /**
         * @param endpointType The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
         * 
         * @return builder
         * 
         */
        public Builder endpointType(@Nullable Output<String> endpointType) {
            $.endpointType = endpointType;
            return this;
        }

        /**
         * @param endpointType The type of the endpoint. One of: `READER`, `WRITER`, `ANY`.
         * 
         * @return builder
         * 
         */
        public Builder endpointType(String endpointType) {
            return endpointType(Output.of(endpointType));
        }

        /**
         * @param excludedMembers List of DB instance identifiers that aren&#39;t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
         * 
         * @return builder
         * 
         */
        public Builder excludedMembers(@Nullable Output<List<String>> excludedMembers) {
            $.excludedMembers = excludedMembers;
            return this;
        }

        /**
         * @param excludedMembers List of DB instance identifiers that aren&#39;t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
         * 
         * @return builder
         * 
         */
        public Builder excludedMembers(List<String> excludedMembers) {
            return excludedMembers(Output.of(excludedMembers));
        }

        /**
         * @param excludedMembers List of DB instance identifiers that aren&#39;t part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.
         * 
         * @return builder
         * 
         */
        public Builder excludedMembers(String... excludedMembers) {
            return excludedMembers(List.of(excludedMembers));
        }

        /**
         * @param staticMembers List of DB instance identifiers that are part of the custom endpoint group.
         * 
         * @return builder
         * 
         */
        public Builder staticMembers(@Nullable Output<List<String>> staticMembers) {
            $.staticMembers = staticMembers;
            return this;
        }

        /**
         * @param staticMembers List of DB instance identifiers that are part of the custom endpoint group.
         * 
         * @return builder
         * 
         */
        public Builder staticMembers(List<String> staticMembers) {
            return staticMembers(Output.of(staticMembers));
        }

        /**
         * @param staticMembers List of DB instance identifiers that are part of the custom endpoint group.
         * 
         * @return builder
         * 
         */
        public Builder staticMembers(String... staticMembers) {
            return staticMembers(List.of(staticMembers));
        }

        /**
         * @param tags A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the Neptune cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        public ClusterEndpointState build() {
            return $;
        }
    }

}
