// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.neptune;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterInstanceArgs extends com.pulumi.resources.ResourceArgs {

    public static final ClusterInstanceArgs Empty = new ClusterInstanceArgs();

    /**
     * Specifies whether any instance modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return Specifies whether any instance modifications
     * are applied immediately, or during the next maintenance window. Default is`false`.
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
     * 
     */
    @Import(name="autoMinorVersionUpgrade")
    private @Nullable Output<Boolean> autoMinorVersionUpgrade;

    /**
     * @return Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> autoMinorVersionUpgrade() {
        return Optional.ofNullable(this.autoMinorVersionUpgrade);
    }

    /**
     * The EC2 Availability Zone that the neptune instance is created in.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return The EC2 Availability Zone that the neptune instance is created in.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * The identifier of the `aws.neptune.Cluster` in which to launch this instance.
     * 
     */
    @Import(name="clusterIdentifier", required=true)
    private Output<String> clusterIdentifier;

    /**
     * @return The identifier of the `aws.neptune.Cluster` in which to launch this instance.
     * 
     */
    public Output<String> clusterIdentifier() {
        return this.clusterIdentifier;
    }

    /**
     * The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
     * 
     */
    @Import(name="engine")
    private @Nullable Output<String> engine;

    /**
     * @return The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
     * 
     */
    public Optional<Output<String>> engine() {
        return Optional.ofNullable(this.engine);
    }

    /**
     * The neptune engine version.
     * 
     */
    @Import(name="engineVersion")
    private @Nullable Output<String> engineVersion;

    /**
     * @return The neptune engine version.
     * 
     */
    public Optional<Output<String>> engineVersion() {
        return Optional.ofNullable(this.engineVersion);
    }

    /**
     * The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
     * 
     */
    @Import(name="identifier")
    private @Nullable Output<String> identifier;

    /**
     * @return The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
     * 
     */
    public Optional<Output<String>> identifier() {
        return Optional.ofNullable(this.identifier);
    }

    /**
     * Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     * 
     */
    @Import(name="identifierPrefix")
    private @Nullable Output<String> identifierPrefix;

    /**
     * @return Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     * 
     */
    public Optional<Output<String>> identifierPrefix() {
        return Optional.ofNullable(this.identifierPrefix);
    }

    /**
     * The instance class to use.
     * 
     */
    @Import(name="instanceClass", required=true)
    private Output<String> instanceClass;

    /**
     * @return The instance class to use.
     * 
     */
    public Output<String> instanceClass() {
        return this.instanceClass;
    }

    /**
     * The name of the neptune parameter group to associate with this instance.
     * 
     */
    @Import(name="neptuneParameterGroupName")
    private @Nullable Output<String> neptuneParameterGroupName;

    /**
     * @return The name of the neptune parameter group to associate with this instance.
     * 
     */
    public Optional<Output<String>> neptuneParameterGroupName() {
        return Optional.ofNullable(this.neptuneParameterGroupName);
    }

    /**
     * A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
     * 
     */
    @Import(name="neptuneSubnetGroupName")
    private @Nullable Output<String> neptuneSubnetGroupName;

    /**
     * @return A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
     * 
     */
    public Optional<Output<String>> neptuneSubnetGroupName() {
        return Optional.ofNullable(this.neptuneSubnetGroupName);
    }

    /**
     * The port on which the DB accepts connections. Defaults to `8182`.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return The port on which the DB accepts connections. Defaults to `8182`.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;
     * 
     */
    @Import(name="preferredBackupWindow")
    private @Nullable Output<String> preferredBackupWindow;

    /**
     * @return The daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;
     * 
     */
    public Optional<Output<String>> preferredBackupWindow() {
        return Optional.ofNullable(this.preferredBackupWindow);
    }

    /**
     * The window to perform maintenance in.
     * Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
     * 
     */
    @Import(name="preferredMaintenanceWindow")
    private @Nullable Output<String> preferredMaintenanceWindow;

    /**
     * @return The window to perform maintenance in.
     * Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
     * 
     */
    public Optional<Output<String>> preferredMaintenanceWindow() {
        return Optional.ofNullable(this.preferredMaintenanceWindow);
    }

    /**
     * Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     * 
     */
    @Import(name="promotionTier")
    private @Nullable Output<Integer> promotionTier;

    /**
     * @return Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
     * 
     */
    public Optional<Output<Integer>> promotionTier() {
        return Optional.ofNullable(this.promotionTier);
    }

    /**
     * Bool to control if instance is publicly accessible. Default is `false`.
     * 
     */
    @Import(name="publiclyAccessible")
    private @Nullable Output<Boolean> publiclyAccessible;

    /**
     * @return Bool to control if instance is publicly accessible. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> publiclyAccessible() {
        return Optional.ofNullable(this.publiclyAccessible);
    }

    /**
     * A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private ClusterInstanceArgs() {}

    private ClusterInstanceArgs(ClusterInstanceArgs $) {
        this.applyImmediately = $.applyImmediately;
        this.autoMinorVersionUpgrade = $.autoMinorVersionUpgrade;
        this.availabilityZone = $.availabilityZone;
        this.clusterIdentifier = $.clusterIdentifier;
        this.engine = $.engine;
        this.engineVersion = $.engineVersion;
        this.identifier = $.identifier;
        this.identifierPrefix = $.identifierPrefix;
        this.instanceClass = $.instanceClass;
        this.neptuneParameterGroupName = $.neptuneParameterGroupName;
        this.neptuneSubnetGroupName = $.neptuneSubnetGroupName;
        this.port = $.port;
        this.preferredBackupWindow = $.preferredBackupWindow;
        this.preferredMaintenanceWindow = $.preferredMaintenanceWindow;
        this.promotionTier = $.promotionTier;
        this.publiclyAccessible = $.publiclyAccessible;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterInstanceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterInstanceArgs $;

        public Builder() {
            $ = new ClusterInstanceArgs();
        }

        public Builder(ClusterInstanceArgs defaults) {
            $ = new ClusterInstanceArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param applyImmediately Specifies whether any instance modifications
         * are applied immediately, or during the next maintenance window. Default is`false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately Specifies whether any instance modifications
         * are applied immediately, or during the next maintenance window. Default is`false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(@Nullable Output<Boolean> autoMinorVersionUpgrade) {
            $.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades will be applied automatically to the instance during the maintenance window. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            return autoMinorVersionUpgrade(Output.of(autoMinorVersionUpgrade));
        }

        /**
         * @param availabilityZone The EC2 Availability Zone that the neptune instance is created in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone The EC2 Availability Zone that the neptune instance is created in.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param clusterIdentifier The identifier of the `aws.neptune.Cluster` in which to launch this instance.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier The identifier of the `aws.neptune.Cluster` in which to launch this instance.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param engine The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
         * 
         * @return builder
         * 
         */
        public Builder engine(@Nullable Output<String> engine) {
            $.engine = engine;
            return this;
        }

        /**
         * @param engine The name of the database engine to be used for the neptune instance. Defaults to `neptune`. Valid Values: `neptune`.
         * 
         * @return builder
         * 
         */
        public Builder engine(String engine) {
            return engine(Output.of(engine));
        }

        /**
         * @param engineVersion The neptune engine version.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(@Nullable Output<String> engineVersion) {
            $.engineVersion = engineVersion;
            return this;
        }

        /**
         * @param engineVersion The neptune engine version.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(String engineVersion) {
            return engineVersion(Output.of(engineVersion));
        }

        /**
         * @param identifier The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder identifier(@Nullable Output<String> identifier) {
            $.identifier = identifier;
            return this;
        }

        /**
         * @param identifier The identifier for the neptune instance, if omitted, this provider will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder identifier(String identifier) {
            return identifier(Output.of(identifier));
        }

        /**
         * @param identifierPrefix Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
         * 
         * @return builder
         * 
         */
        public Builder identifierPrefix(@Nullable Output<String> identifierPrefix) {
            $.identifierPrefix = identifierPrefix;
            return this;
        }

        /**
         * @param identifierPrefix Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
         * 
         * @return builder
         * 
         */
        public Builder identifierPrefix(String identifierPrefix) {
            return identifierPrefix(Output.of(identifierPrefix));
        }

        /**
         * @param instanceClass The instance class to use.
         * 
         * @return builder
         * 
         */
        public Builder instanceClass(Output<String> instanceClass) {
            $.instanceClass = instanceClass;
            return this;
        }

        /**
         * @param instanceClass The instance class to use.
         * 
         * @return builder
         * 
         */
        public Builder instanceClass(String instanceClass) {
            return instanceClass(Output.of(instanceClass));
        }

        /**
         * @param neptuneParameterGroupName The name of the neptune parameter group to associate with this instance.
         * 
         * @return builder
         * 
         */
        public Builder neptuneParameterGroupName(@Nullable Output<String> neptuneParameterGroupName) {
            $.neptuneParameterGroupName = neptuneParameterGroupName;
            return this;
        }

        /**
         * @param neptuneParameterGroupName The name of the neptune parameter group to associate with this instance.
         * 
         * @return builder
         * 
         */
        public Builder neptuneParameterGroupName(String neptuneParameterGroupName) {
            return neptuneParameterGroupName(Output.of(neptuneParameterGroupName));
        }

        /**
         * @param neptuneSubnetGroupName A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
         * 
         * @return builder
         * 
         */
        public Builder neptuneSubnetGroupName(@Nullable Output<String> neptuneSubnetGroupName) {
            $.neptuneSubnetGroupName = neptuneSubnetGroupName;
            return this;
        }

        /**
         * @param neptuneSubnetGroupName A subnet group to associate with this neptune instance. **NOTE:** This must match the `neptune_subnet_group_name` of the attached `aws.neptune.Cluster`.
         * 
         * @return builder
         * 
         */
        public Builder neptuneSubnetGroupName(String neptuneSubnetGroupName) {
            return neptuneSubnetGroupName(Output.of(neptuneSubnetGroupName));
        }

        /**
         * @param port The port on which the DB accepts connections. Defaults to `8182`.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port The port on which the DB accepts connections. Defaults to `8182`.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(@Nullable Output<String> preferredBackupWindow) {
            $.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(String preferredBackupWindow) {
            return preferredBackupWindow(Output.of(preferredBackupWindow));
        }

        /**
         * @param preferredMaintenanceWindow The window to perform maintenance in.
         * Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(@Nullable Output<String> preferredMaintenanceWindow) {
            $.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * @param preferredMaintenanceWindow The window to perform maintenance in.
         * Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            return preferredMaintenanceWindow(Output.of(preferredMaintenanceWindow));
        }

        /**
         * @param promotionTier Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
         * 
         * @return builder
         * 
         */
        public Builder promotionTier(@Nullable Output<Integer> promotionTier) {
            $.promotionTier = promotionTier;
            return this;
        }

        /**
         * @param promotionTier Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoter to writer.
         * 
         * @return builder
         * 
         */
        public Builder promotionTier(Integer promotionTier) {
            return promotionTier(Output.of(promotionTier));
        }

        /**
         * @param publiclyAccessible Bool to control if instance is publicly accessible. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(@Nullable Output<Boolean> publiclyAccessible) {
            $.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * @param publiclyAccessible Bool to control if instance is publicly accessible. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            return publiclyAccessible(Output.of(publiclyAccessible));
        }

        /**
         * @param tags A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public ClusterInstanceArgs build() {
            $.clusterIdentifier = Objects.requireNonNull($.clusterIdentifier, "expected parameter 'clusterIdentifier' to be non-null");
            $.instanceClass = Objects.requireNonNull($.instanceClass, "expected parameter 'instanceClass' to be non-null");
            return $;
        }
    }

}
