// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.msk.inputs;

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs;
import com.pulumi.aws.msk.inputs.ClusterClientAuthenticationArgs;
import com.pulumi.aws.msk.inputs.ClusterConfigurationInfoArgs;
import com.pulumi.aws.msk.inputs.ClusterEncryptionInfoArgs;
import com.pulumi.aws.msk.inputs.ClusterLoggingInfoArgs;
import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterState extends com.pulumi.resources.ResourceArgs {

    public static final ClusterState Empty = new ClusterState();

    /**
     * Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokers")
    private @Nullable Output<String> bootstrapBrokers;

    /**
     * @return Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokers() {
        return Optional.ofNullable(this.bootstrapBrokers);
    }

    /**
     * One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokersPublicSaslIam")
    private @Nullable Output<String> bootstrapBrokersPublicSaslIam;

    /**
     * @return One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokersPublicSaslIam() {
        return Optional.ofNullable(this.bootstrapBrokersPublicSaslIam);
    }

    /**
     * One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokersPublicSaslScram")
    private @Nullable Output<String> bootstrapBrokersPublicSaslScram;

    /**
     * @return One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokersPublicSaslScram() {
        return Optional.ofNullable(this.bootstrapBrokersPublicSaslScram);
    }

    /**
     * One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokersPublicTls")
    private @Nullable Output<String> bootstrapBrokersPublicTls;

    /**
     * @return One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokersPublicTls() {
        return Optional.ofNullable(this.bootstrapBrokersPublicTls);
    }

    /**
     * One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokersSaslIam")
    private @Nullable Output<String> bootstrapBrokersSaslIam;

    /**
     * @return One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokersSaslIam() {
        return Optional.ofNullable(this.bootstrapBrokersSaslIam);
    }

    /**
     * One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokersSaslScram")
    private @Nullable Output<String> bootstrapBrokersSaslScram;

    /**
     * @return One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokersSaslScram() {
        return Optional.ofNullable(this.bootstrapBrokersSaslScram);
    }

    /**
     * One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokersTls")
    private @Nullable Output<String> bootstrapBrokersTls;

    /**
     * @return One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokersTls() {
        return Optional.ofNullable(this.bootstrapBrokersTls);
    }

    /**
     * A string containing one or more DNS names (or IP addresses) and SASL IAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokersVpcConnectivitySaslIam")
    private @Nullable Output<String> bootstrapBrokersVpcConnectivitySaslIam;

    /**
     * @return A string containing one or more DNS names (or IP addresses) and SASL IAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokersVpcConnectivitySaslIam() {
        return Optional.ofNullable(this.bootstrapBrokersVpcConnectivitySaslIam);
    }

    /**
     * A string containing one or more DNS names (or IP addresses) and SASL SCRAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokersVpcConnectivitySaslScram")
    private @Nullable Output<String> bootstrapBrokersVpcConnectivitySaslScram;

    /**
     * @return A string containing one or more DNS names (or IP addresses) and SASL SCRAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokersVpcConnectivitySaslScram() {
        return Optional.ofNullable(this.bootstrapBrokersVpcConnectivitySaslScram);
    }

    /**
     * A string containing one or more DNS names (or IP addresses) and TLS port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    @Import(name="bootstrapBrokersVpcConnectivityTls")
    private @Nullable Output<String> bootstrapBrokersVpcConnectivityTls;

    /**
     * @return A string containing one or more DNS names (or IP addresses) and TLS port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
     * 
     */
    public Optional<Output<String>> bootstrapBrokersVpcConnectivityTls() {
        return Optional.ofNullable(this.bootstrapBrokersVpcConnectivityTls);
    }

    /**
     * Configuration block for the broker nodes of the Kafka cluster.
     * 
     */
    @Import(name="brokerNodeGroupInfo")
    private @Nullable Output<ClusterBrokerNodeGroupInfoArgs> brokerNodeGroupInfo;

    /**
     * @return Configuration block for the broker nodes of the Kafka cluster.
     * 
     */
    public Optional<Output<ClusterBrokerNodeGroupInfoArgs>> brokerNodeGroupInfo() {
        return Optional.ofNullable(this.brokerNodeGroupInfo);
    }

    /**
     * Configuration block for specifying a client authentication. See below.
     * 
     */
    @Import(name="clientAuthentication")
    private @Nullable Output<ClusterClientAuthenticationArgs> clientAuthentication;

    /**
     * @return Configuration block for specifying a client authentication. See below.
     * 
     */
    public Optional<Output<ClusterClientAuthenticationArgs>> clientAuthentication() {
        return Optional.ofNullable(this.clientAuthentication);
    }

    /**
     * Name of the MSK cluster.
     * 
     */
    @Import(name="clusterName")
    private @Nullable Output<String> clusterName;

    /**
     * @return Name of the MSK cluster.
     * 
     */
    public Optional<Output<String>> clusterName() {
        return Optional.ofNullable(this.clusterName);
    }

    /**
     * Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
     * 
     */
    @Import(name="configurationInfo")
    private @Nullable Output<ClusterConfigurationInfoArgs> configurationInfo;

    /**
     * @return Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
     * 
     */
    public Optional<Output<ClusterConfigurationInfoArgs>> configurationInfo() {
        return Optional.ofNullable(this.configurationInfo);
    }

    /**
     * Current version of the MSK Cluster used for updates, e.g., `K13V1IB3VIYZZH`
     * * `encryption_info.0.encryption_at_rest_kms_key_arn` - The ARN of the KMS key used for encryption at rest of the broker data volumes.
     * 
     */
    @Import(name="currentVersion")
    private @Nullable Output<String> currentVersion;

    /**
     * @return Current version of the MSK Cluster used for updates, e.g., `K13V1IB3VIYZZH`
     * * `encryption_info.0.encryption_at_rest_kms_key_arn` - The ARN of the KMS key used for encryption at rest of the broker data volumes.
     * 
     */
    public Optional<Output<String>> currentVersion() {
        return Optional.ofNullable(this.currentVersion);
    }

    /**
     * Configuration block for specifying encryption. See below.
     * 
     */
    @Import(name="encryptionInfo")
    private @Nullable Output<ClusterEncryptionInfoArgs> encryptionInfo;

    /**
     * @return Configuration block for specifying encryption. See below.
     * 
     */
    public Optional<Output<ClusterEncryptionInfoArgs>> encryptionInfo() {
        return Optional.ofNullable(this.encryptionInfo);
    }

    /**
     * Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
     * 
     */
    @Import(name="enhancedMonitoring")
    private @Nullable Output<String> enhancedMonitoring;

    /**
     * @return Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
     * 
     */
    public Optional<Output<String>> enhancedMonitoring() {
        return Optional.ofNullable(this.enhancedMonitoring);
    }

    /**
     * Specify the desired Kafka software version.
     * 
     */
    @Import(name="kafkaVersion")
    private @Nullable Output<String> kafkaVersion;

    /**
     * @return Specify the desired Kafka software version.
     * 
     */
    public Optional<Output<String>> kafkaVersion() {
        return Optional.ofNullable(this.kafkaVersion);
    }

    /**
     * Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
     * 
     */
    @Import(name="loggingInfo")
    private @Nullable Output<ClusterLoggingInfoArgs> loggingInfo;

    /**
     * @return Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
     * 
     */
    public Optional<Output<ClusterLoggingInfoArgs>> loggingInfo() {
        return Optional.ofNullable(this.loggingInfo);
    }

    /**
     * The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
     * 
     */
    @Import(name="numberOfBrokerNodes")
    private @Nullable Output<Integer> numberOfBrokerNodes;

    /**
     * @return The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
     * 
     */
    public Optional<Output<Integer>> numberOfBrokerNodes() {
        return Optional.ofNullable(this.numberOfBrokerNodes);
    }

    /**
     * Configuration block for JMX and Node monitoring for the MSK cluster. See below.
     * 
     */
    @Import(name="openMonitoring")
    private @Nullable Output<ClusterOpenMonitoringArgs> openMonitoring;

    /**
     * @return Configuration block for JMX and Node monitoring for the MSK cluster. See below.
     * 
     */
    public Optional<Output<ClusterOpenMonitoringArgs>> openMonitoring() {
        return Optional.ofNullable(this.openMonitoring);
    }

    /**
     * Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
     * 
     */
    @Import(name="storageMode")
    private @Nullable Output<String> storageMode;

    /**
     * @return Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
     * 
     */
    public Optional<Output<String>> storageMode() {
        return Optional.ofNullable(this.storageMode);
    }

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
     * 
     */
    @Import(name="zookeeperConnectString")
    private @Nullable Output<String> zookeeperConnectString;

    /**
     * @return A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
     * 
     */
    public Optional<Output<String>> zookeeperConnectString() {
        return Optional.ofNullable(this.zookeeperConnectString);
    }

    /**
     * A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
     * 
     */
    @Import(name="zookeeperConnectStringTls")
    private @Nullable Output<String> zookeeperConnectStringTls;

    /**
     * @return A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
     * 
     */
    public Optional<Output<String>> zookeeperConnectStringTls() {
        return Optional.ofNullable(this.zookeeperConnectStringTls);
    }

    private ClusterState() {}

    private ClusterState(ClusterState $) {
        this.arn = $.arn;
        this.bootstrapBrokers = $.bootstrapBrokers;
        this.bootstrapBrokersPublicSaslIam = $.bootstrapBrokersPublicSaslIam;
        this.bootstrapBrokersPublicSaslScram = $.bootstrapBrokersPublicSaslScram;
        this.bootstrapBrokersPublicTls = $.bootstrapBrokersPublicTls;
        this.bootstrapBrokersSaslIam = $.bootstrapBrokersSaslIam;
        this.bootstrapBrokersSaslScram = $.bootstrapBrokersSaslScram;
        this.bootstrapBrokersTls = $.bootstrapBrokersTls;
        this.bootstrapBrokersVpcConnectivitySaslIam = $.bootstrapBrokersVpcConnectivitySaslIam;
        this.bootstrapBrokersVpcConnectivitySaslScram = $.bootstrapBrokersVpcConnectivitySaslScram;
        this.bootstrapBrokersVpcConnectivityTls = $.bootstrapBrokersVpcConnectivityTls;
        this.brokerNodeGroupInfo = $.brokerNodeGroupInfo;
        this.clientAuthentication = $.clientAuthentication;
        this.clusterName = $.clusterName;
        this.configurationInfo = $.configurationInfo;
        this.currentVersion = $.currentVersion;
        this.encryptionInfo = $.encryptionInfo;
        this.enhancedMonitoring = $.enhancedMonitoring;
        this.kafkaVersion = $.kafkaVersion;
        this.loggingInfo = $.loggingInfo;
        this.numberOfBrokerNodes = $.numberOfBrokerNodes;
        this.openMonitoring = $.openMonitoring;
        this.storageMode = $.storageMode;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.zookeeperConnectString = $.zookeeperConnectString;
        this.zookeeperConnectStringTls = $.zookeeperConnectStringTls;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterState $;

        public Builder() {
            $ = new ClusterState();
        }

        public Builder(ClusterState defaults) {
            $ = new ClusterState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param bootstrapBrokers Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokers(@Nullable Output<String> bootstrapBrokers) {
            $.bootstrapBrokers = bootstrapBrokers;
            return this;
        }

        /**
         * @param bootstrapBrokers Comma separated list of one or more hostname:port pairs of kafka brokers suitable to bootstrap connectivity to the kafka cluster. Contains a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `PLAINTEXT` or `TLS_PLAINTEXT`. The resource sorts values alphabetically. AWS may not always return all endpoints so this value is not guaranteed to be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokers(String bootstrapBrokers) {
            return bootstrapBrokers(Output.of(bootstrapBrokers));
        }

        /**
         * @param bootstrapBrokersPublicSaslIam One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersPublicSaslIam(@Nullable Output<String> bootstrapBrokersPublicSaslIam) {
            $.bootstrapBrokersPublicSaslIam = bootstrapBrokersPublicSaslIam;
            return this;
        }

        /**
         * @param bootstrapBrokersPublicSaslIam One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9198`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersPublicSaslIam(String bootstrapBrokersPublicSaslIam) {
            return bootstrapBrokersPublicSaslIam(Output.of(bootstrapBrokersPublicSaslIam));
        }

        /**
         * @param bootstrapBrokersPublicSaslScram One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersPublicSaslScram(@Nullable Output<String> bootstrapBrokersPublicSaslScram) {
            $.bootstrapBrokersPublicSaslScram = bootstrapBrokersPublicSaslScram;
            return this;
        }

        /**
         * @param bootstrapBrokersPublicSaslScram One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9196`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersPublicSaslScram(String bootstrapBrokersPublicSaslScram) {
            return bootstrapBrokersPublicSaslScram(Output.of(bootstrapBrokersPublicSaslScram));
        }

        /**
         * @param bootstrapBrokersPublicTls One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersPublicTls(@Nullable Output<String> bootstrapBrokersPublicTls) {
            $.bootstrapBrokersPublicTls = bootstrapBrokersPublicTls;
            return this;
        }

        /**
         * @param bootstrapBrokersPublicTls One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-2-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194,b-3-public.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9194`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `broker_node_group_info.0.connectivity_info.0.public_access.0.type` is set to `SERVICE_PROVIDED_EIPS` and the cluster fulfill all other requirements for public access. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersPublicTls(String bootstrapBrokersPublicTls) {
            return bootstrapBrokersPublicTls(Output.of(bootstrapBrokersPublicTls));
        }

        /**
         * @param bootstrapBrokersSaslIam One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersSaslIam(@Nullable Output<String> bootstrapBrokersSaslIam) {
            $.bootstrapBrokersSaslIam = bootstrapBrokersSaslIam;
            return this;
        }

        /**
         * @param bootstrapBrokersSaslIam One or more DNS names (or IP addresses) and SASL IAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9098`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.iam` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersSaslIam(String bootstrapBrokersSaslIam) {
            return bootstrapBrokersSaslIam(Output.of(bootstrapBrokersSaslIam));
        }

        /**
         * @param bootstrapBrokersSaslScram One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersSaslScram(@Nullable Output<String> bootstrapBrokersSaslScram) {
            $.bootstrapBrokersSaslScram = bootstrapBrokersSaslScram;
            return this;
        }

        /**
         * @param bootstrapBrokersSaslScram One or more DNS names (or IP addresses) and SASL SCRAM port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9096`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS` and `client_authentication.0.sasl.0.scram` is set to `true`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersSaslScram(String bootstrapBrokersSaslScram) {
            return bootstrapBrokersSaslScram(Output.of(bootstrapBrokersSaslScram));
        }

        /**
         * @param bootstrapBrokersTls One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersTls(@Nullable Output<String> bootstrapBrokersTls) {
            $.bootstrapBrokersTls = bootstrapBrokersTls;
            return this;
        }

        /**
         * @param bootstrapBrokersTls One or more DNS names (or IP addresses) and TLS port pairs. For example, `b-1.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-2.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094,b-3.exampleClusterName.abcde.c2.kafka.us-east-1.amazonaws.com:9094`. This attribute will have a value if `encryption_info.0.encryption_in_transit.0.client_broker` is set to `TLS_PLAINTEXT` or `TLS`. The resource sorts the list alphabetically. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersTls(String bootstrapBrokersTls) {
            return bootstrapBrokersTls(Output.of(bootstrapBrokersTls));
        }

        /**
         * @param bootstrapBrokersVpcConnectivitySaslIam A string containing one or more DNS names (or IP addresses) and SASL IAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersVpcConnectivitySaslIam(@Nullable Output<String> bootstrapBrokersVpcConnectivitySaslIam) {
            $.bootstrapBrokersVpcConnectivitySaslIam = bootstrapBrokersVpcConnectivitySaslIam;
            return this;
        }

        /**
         * @param bootstrapBrokersVpcConnectivitySaslIam A string containing one or more DNS names (or IP addresses) and SASL IAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersVpcConnectivitySaslIam(String bootstrapBrokersVpcConnectivitySaslIam) {
            return bootstrapBrokersVpcConnectivitySaslIam(Output.of(bootstrapBrokersVpcConnectivitySaslIam));
        }

        /**
         * @param bootstrapBrokersVpcConnectivitySaslScram A string containing one or more DNS names (or IP addresses) and SASL SCRAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersVpcConnectivitySaslScram(@Nullable Output<String> bootstrapBrokersVpcConnectivitySaslScram) {
            $.bootstrapBrokersVpcConnectivitySaslScram = bootstrapBrokersVpcConnectivitySaslScram;
            return this;
        }

        /**
         * @param bootstrapBrokersVpcConnectivitySaslScram A string containing one or more DNS names (or IP addresses) and SASL SCRAM port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersVpcConnectivitySaslScram(String bootstrapBrokersVpcConnectivitySaslScram) {
            return bootstrapBrokersVpcConnectivitySaslScram(Output.of(bootstrapBrokersVpcConnectivitySaslScram));
        }

        /**
         * @param bootstrapBrokersVpcConnectivityTls A string containing one or more DNS names (or IP addresses) and TLS port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersVpcConnectivityTls(@Nullable Output<String> bootstrapBrokersVpcConnectivityTls) {
            $.bootstrapBrokersVpcConnectivityTls = bootstrapBrokersVpcConnectivityTls;
            return this;
        }

        /**
         * @param bootstrapBrokersVpcConnectivityTls A string containing one or more DNS names (or IP addresses) and TLS port pairs for VPC connectivity. AWS may not always return all endpoints so the values may not be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder bootstrapBrokersVpcConnectivityTls(String bootstrapBrokersVpcConnectivityTls) {
            return bootstrapBrokersVpcConnectivityTls(Output.of(bootstrapBrokersVpcConnectivityTls));
        }

        /**
         * @param brokerNodeGroupInfo Configuration block for the broker nodes of the Kafka cluster.
         * 
         * @return builder
         * 
         */
        public Builder brokerNodeGroupInfo(@Nullable Output<ClusterBrokerNodeGroupInfoArgs> brokerNodeGroupInfo) {
            $.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        /**
         * @param brokerNodeGroupInfo Configuration block for the broker nodes of the Kafka cluster.
         * 
         * @return builder
         * 
         */
        public Builder brokerNodeGroupInfo(ClusterBrokerNodeGroupInfoArgs brokerNodeGroupInfo) {
            return brokerNodeGroupInfo(Output.of(brokerNodeGroupInfo));
        }

        /**
         * @param clientAuthentication Configuration block for specifying a client authentication. See below.
         * 
         * @return builder
         * 
         */
        public Builder clientAuthentication(@Nullable Output<ClusterClientAuthenticationArgs> clientAuthentication) {
            $.clientAuthentication = clientAuthentication;
            return this;
        }

        /**
         * @param clientAuthentication Configuration block for specifying a client authentication. See below.
         * 
         * @return builder
         * 
         */
        public Builder clientAuthentication(ClusterClientAuthenticationArgs clientAuthentication) {
            return clientAuthentication(Output.of(clientAuthentication));
        }

        /**
         * @param clusterName Name of the MSK cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterName(@Nullable Output<String> clusterName) {
            $.clusterName = clusterName;
            return this;
        }

        /**
         * @param clusterName Name of the MSK cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterName(String clusterName) {
            return clusterName(Output.of(clusterName));
        }

        /**
         * @param configurationInfo Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
         * 
         * @return builder
         * 
         */
        public Builder configurationInfo(@Nullable Output<ClusterConfigurationInfoArgs> configurationInfo) {
            $.configurationInfo = configurationInfo;
            return this;
        }

        /**
         * @param configurationInfo Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
         * 
         * @return builder
         * 
         */
        public Builder configurationInfo(ClusterConfigurationInfoArgs configurationInfo) {
            return configurationInfo(Output.of(configurationInfo));
        }

        /**
         * @param currentVersion Current version of the MSK Cluster used for updates, e.g., `K13V1IB3VIYZZH`
         * * `encryption_info.0.encryption_at_rest_kms_key_arn` - The ARN of the KMS key used for encryption at rest of the broker data volumes.
         * 
         * @return builder
         * 
         */
        public Builder currentVersion(@Nullable Output<String> currentVersion) {
            $.currentVersion = currentVersion;
            return this;
        }

        /**
         * @param currentVersion Current version of the MSK Cluster used for updates, e.g., `K13V1IB3VIYZZH`
         * * `encryption_info.0.encryption_at_rest_kms_key_arn` - The ARN of the KMS key used for encryption at rest of the broker data volumes.
         * 
         * @return builder
         * 
         */
        public Builder currentVersion(String currentVersion) {
            return currentVersion(Output.of(currentVersion));
        }

        /**
         * @param encryptionInfo Configuration block for specifying encryption. See below.
         * 
         * @return builder
         * 
         */
        public Builder encryptionInfo(@Nullable Output<ClusterEncryptionInfoArgs> encryptionInfo) {
            $.encryptionInfo = encryptionInfo;
            return this;
        }

        /**
         * @param encryptionInfo Configuration block for specifying encryption. See below.
         * 
         * @return builder
         * 
         */
        public Builder encryptionInfo(ClusterEncryptionInfoArgs encryptionInfo) {
            return encryptionInfo(Output.of(encryptionInfo));
        }

        /**
         * @param enhancedMonitoring Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
         * 
         * @return builder
         * 
         */
        public Builder enhancedMonitoring(@Nullable Output<String> enhancedMonitoring) {
            $.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        /**
         * @param enhancedMonitoring Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
         * 
         * @return builder
         * 
         */
        public Builder enhancedMonitoring(String enhancedMonitoring) {
            return enhancedMonitoring(Output.of(enhancedMonitoring));
        }

        /**
         * @param kafkaVersion Specify the desired Kafka software version.
         * 
         * @return builder
         * 
         */
        public Builder kafkaVersion(@Nullable Output<String> kafkaVersion) {
            $.kafkaVersion = kafkaVersion;
            return this;
        }

        /**
         * @param kafkaVersion Specify the desired Kafka software version.
         * 
         * @return builder
         * 
         */
        public Builder kafkaVersion(String kafkaVersion) {
            return kafkaVersion(Output.of(kafkaVersion));
        }

        /**
         * @param loggingInfo Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
         * 
         * @return builder
         * 
         */
        public Builder loggingInfo(@Nullable Output<ClusterLoggingInfoArgs> loggingInfo) {
            $.loggingInfo = loggingInfo;
            return this;
        }

        /**
         * @param loggingInfo Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
         * 
         * @return builder
         * 
         */
        public Builder loggingInfo(ClusterLoggingInfoArgs loggingInfo) {
            return loggingInfo(Output.of(loggingInfo));
        }

        /**
         * @param numberOfBrokerNodes The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
         * 
         * @return builder
         * 
         */
        public Builder numberOfBrokerNodes(@Nullable Output<Integer> numberOfBrokerNodes) {
            $.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        /**
         * @param numberOfBrokerNodes The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
         * 
         * @return builder
         * 
         */
        public Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            return numberOfBrokerNodes(Output.of(numberOfBrokerNodes));
        }

        /**
         * @param openMonitoring Configuration block for JMX and Node monitoring for the MSK cluster. See below.
         * 
         * @return builder
         * 
         */
        public Builder openMonitoring(@Nullable Output<ClusterOpenMonitoringArgs> openMonitoring) {
            $.openMonitoring = openMonitoring;
            return this;
        }

        /**
         * @param openMonitoring Configuration block for JMX and Node monitoring for the MSK cluster. See below.
         * 
         * @return builder
         * 
         */
        public Builder openMonitoring(ClusterOpenMonitoringArgs openMonitoring) {
            return openMonitoring(Output.of(openMonitoring));
        }

        /**
         * @param storageMode Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
         * 
         * @return builder
         * 
         */
        public Builder storageMode(@Nullable Output<String> storageMode) {
            $.storageMode = storageMode;
            return this;
        }

        /**
         * @param storageMode Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
         * 
         * @return builder
         * 
         */
        public Builder storageMode(String storageMode) {
            return storageMode(Output.of(storageMode));
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param zookeeperConnectString A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder zookeeperConnectString(@Nullable Output<String> zookeeperConnectString) {
            $.zookeeperConnectString = zookeeperConnectString;
            return this;
        }

        /**
         * @param zookeeperConnectString A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder zookeeperConnectString(String zookeeperConnectString) {
            return zookeeperConnectString(Output.of(zookeeperConnectString));
        }

        /**
         * @param zookeeperConnectStringTls A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder zookeeperConnectStringTls(@Nullable Output<String> zookeeperConnectStringTls) {
            $.zookeeperConnectStringTls = zookeeperConnectStringTls;
            return this;
        }

        /**
         * @param zookeeperConnectStringTls A comma separated list of one or more hostname:port pairs to use to connect to the Apache Zookeeper cluster via TLS. The returned values are sorted alphabetically. The AWS API may not return all endpoints, so this value is not guaranteed to be stable across applies.
         * 
         * @return builder
         * 
         */
        public Builder zookeeperConnectStringTls(String zookeeperConnectStringTls) {
            return zookeeperConnectStringTls(Output.of(zookeeperConnectStringTls));
        }

        public ClusterState build() {
            return $;
        }
    }

}
