// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.msk;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.msk.ClusterPolicyArgs;
import com.pulumi.aws.msk.inputs.ClusterPolicyState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Resource for managing an AWS Managed Streaming for Kafka Cluster Policy.
 * 
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.msk.ClusterPolicy;
 * import com.pulumi.aws.msk.ClusterPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 * 
 *         final var currentPartition = AwsFunctions.getPartition();
 * 
 *         var example = new ClusterPolicy(&#34;example&#34;, ClusterPolicyArgs.builder()        
 *             .clusterArn(aws_msk_cluster.example().arn())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;Version&#34;, &#34;2012-10-17&#34;),
 *                     jsonProperty(&#34;Statement&#34;, jsonArray(jsonObject(
 *                         jsonProperty(&#34;Sid&#34;, &#34;ExampleMskClusterPolicy&#34;),
 *                         jsonProperty(&#34;Effect&#34;, &#34;Allow&#34;),
 *                         jsonProperty(&#34;Principal&#34;, jsonObject(
 *                             jsonProperty(&#34;AWS&#34;, String.format(&#34;arn:%s:iam::%s:root&#34;, currentPartition.applyValue(getPartitionResult -&gt; getPartitionResult.partition()),currentCallerIdentity.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId())))
 *                         )),
 *                         jsonProperty(&#34;Action&#34;, jsonArray(
 *                             &#34;kafka:Describe*&#34;, 
 *                             &#34;kafka:Get*&#34;, 
 *                             &#34;kafka:CreateVpcConnection&#34;, 
 *                             &#34;kafka:GetBootstrapBrokers&#34;
 *                         )),
 *                         jsonProperty(&#34;Resource&#34;, aws_msk_cluster.example().arn())
 *                     )))
 *                 )))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * In TODO v1.5.0 and later, use an `import` block to import Managed Streaming for Kafka Cluster Policy using the `cluster_arn. For exampleterraform import {
 * 
 *  to = aws_msk_cluster_policy.example
 * 
 *  id = &#34;arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3&#34; } Using `TODO import`, import Managed Streaming for Kafka Cluster Policy using the `cluster_arn`. For exampleconsole % TODO import aws_msk_cluster_policy.example arn:aws:kafka:us-west-2:123456789012:cluster/example/279c0212-d057-4dba-9aa9-1c4e5a25bfc7-3
 * 
 */
@ResourceType(type="aws:msk/clusterPolicy:ClusterPolicy")
public class ClusterPolicy extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * 
     */
    @Export(name="clusterArn", refs={String.class}, tree="[0]")
    private Output<String> clusterArn;

    /**
     * @return The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * 
     */
    public Output<String> clusterArn() {
        return this.clusterArn;
    }
    @Export(name="currentVersion", refs={String.class}, tree="[0]")
    private Output<String> currentVersion;

    public Output<String> currentVersion() {
        return this.currentVersion;
    }
    /**
     * Resource policy for cluster.
     * 
     */
    @Export(name="policy", refs={String.class}, tree="[0]")
    private Output<String> policy;

    /**
     * @return Resource policy for cluster.
     * 
     */
    public Output<String> policy() {
        return this.policy;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ClusterPolicy(String name) {
        this(name, ClusterPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ClusterPolicy(String name, ClusterPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ClusterPolicy(String name, ClusterPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:msk/clusterPolicy:ClusterPolicy", name, args == null ? ClusterPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ClusterPolicy(String name, Output<String> id, @Nullable ClusterPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:msk/clusterPolicy:ClusterPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ClusterPolicy get(String name, Output<String> id, @Nullable ClusterPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ClusterPolicy(name, id, state, options);
    }
}
