// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.msk;

import com.pulumi.aws.msk.inputs.ClusterBrokerNodeGroupInfoArgs;
import com.pulumi.aws.msk.inputs.ClusterClientAuthenticationArgs;
import com.pulumi.aws.msk.inputs.ClusterConfigurationInfoArgs;
import com.pulumi.aws.msk.inputs.ClusterEncryptionInfoArgs;
import com.pulumi.aws.msk.inputs.ClusterLoggingInfoArgs;
import com.pulumi.aws.msk.inputs.ClusterOpenMonitoringArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterArgs extends com.pulumi.resources.ResourceArgs {

    public static final ClusterArgs Empty = new ClusterArgs();

    /**
     * Configuration block for the broker nodes of the Kafka cluster.
     * 
     */
    @Import(name="brokerNodeGroupInfo", required=true)
    private Output<ClusterBrokerNodeGroupInfoArgs> brokerNodeGroupInfo;

    /**
     * @return Configuration block for the broker nodes of the Kafka cluster.
     * 
     */
    public Output<ClusterBrokerNodeGroupInfoArgs> brokerNodeGroupInfo() {
        return this.brokerNodeGroupInfo;
    }

    /**
     * Configuration block for specifying a client authentication. See below.
     * 
     */
    @Import(name="clientAuthentication")
    private @Nullable Output<ClusterClientAuthenticationArgs> clientAuthentication;

    /**
     * @return Configuration block for specifying a client authentication. See below.
     * 
     */
    public Optional<Output<ClusterClientAuthenticationArgs>> clientAuthentication() {
        return Optional.ofNullable(this.clientAuthentication);
    }

    /**
     * Name of the MSK cluster.
     * 
     */
    @Import(name="clusterName")
    private @Nullable Output<String> clusterName;

    /**
     * @return Name of the MSK cluster.
     * 
     */
    public Optional<Output<String>> clusterName() {
        return Optional.ofNullable(this.clusterName);
    }

    /**
     * Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
     * 
     */
    @Import(name="configurationInfo")
    private @Nullable Output<ClusterConfigurationInfoArgs> configurationInfo;

    /**
     * @return Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
     * 
     */
    public Optional<Output<ClusterConfigurationInfoArgs>> configurationInfo() {
        return Optional.ofNullable(this.configurationInfo);
    }

    /**
     * Configuration block for specifying encryption. See below.
     * 
     */
    @Import(name="encryptionInfo")
    private @Nullable Output<ClusterEncryptionInfoArgs> encryptionInfo;

    /**
     * @return Configuration block for specifying encryption. See below.
     * 
     */
    public Optional<Output<ClusterEncryptionInfoArgs>> encryptionInfo() {
        return Optional.ofNullable(this.encryptionInfo);
    }

    /**
     * Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
     * 
     */
    @Import(name="enhancedMonitoring")
    private @Nullable Output<String> enhancedMonitoring;

    /**
     * @return Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
     * 
     */
    public Optional<Output<String>> enhancedMonitoring() {
        return Optional.ofNullable(this.enhancedMonitoring);
    }

    /**
     * Specify the desired Kafka software version.
     * 
     */
    @Import(name="kafkaVersion", required=true)
    private Output<String> kafkaVersion;

    /**
     * @return Specify the desired Kafka software version.
     * 
     */
    public Output<String> kafkaVersion() {
        return this.kafkaVersion;
    }

    /**
     * Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
     * 
     */
    @Import(name="loggingInfo")
    private @Nullable Output<ClusterLoggingInfoArgs> loggingInfo;

    /**
     * @return Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
     * 
     */
    public Optional<Output<ClusterLoggingInfoArgs>> loggingInfo() {
        return Optional.ofNullable(this.loggingInfo);
    }

    /**
     * The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
     * 
     */
    @Import(name="numberOfBrokerNodes", required=true)
    private Output<Integer> numberOfBrokerNodes;

    /**
     * @return The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
     * 
     */
    public Output<Integer> numberOfBrokerNodes() {
        return this.numberOfBrokerNodes;
    }

    /**
     * Configuration block for JMX and Node monitoring for the MSK cluster. See below.
     * 
     */
    @Import(name="openMonitoring")
    private @Nullable Output<ClusterOpenMonitoringArgs> openMonitoring;

    /**
     * @return Configuration block for JMX and Node monitoring for the MSK cluster. See below.
     * 
     */
    public Optional<Output<ClusterOpenMonitoringArgs>> openMonitoring() {
        return Optional.ofNullable(this.openMonitoring);
    }

    /**
     * Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
     * 
     */
    @Import(name="storageMode")
    private @Nullable Output<String> storageMode;

    /**
     * @return Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
     * 
     */
    public Optional<Output<String>> storageMode() {
        return Optional.ofNullable(this.storageMode);
    }

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private ClusterArgs() {}

    private ClusterArgs(ClusterArgs $) {
        this.brokerNodeGroupInfo = $.brokerNodeGroupInfo;
        this.clientAuthentication = $.clientAuthentication;
        this.clusterName = $.clusterName;
        this.configurationInfo = $.configurationInfo;
        this.encryptionInfo = $.encryptionInfo;
        this.enhancedMonitoring = $.enhancedMonitoring;
        this.kafkaVersion = $.kafkaVersion;
        this.loggingInfo = $.loggingInfo;
        this.numberOfBrokerNodes = $.numberOfBrokerNodes;
        this.openMonitoring = $.openMonitoring;
        this.storageMode = $.storageMode;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterArgs $;

        public Builder() {
            $ = new ClusterArgs();
        }

        public Builder(ClusterArgs defaults) {
            $ = new ClusterArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param brokerNodeGroupInfo Configuration block for the broker nodes of the Kafka cluster.
         * 
         * @return builder
         * 
         */
        public Builder brokerNodeGroupInfo(Output<ClusterBrokerNodeGroupInfoArgs> brokerNodeGroupInfo) {
            $.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        /**
         * @param brokerNodeGroupInfo Configuration block for the broker nodes of the Kafka cluster.
         * 
         * @return builder
         * 
         */
        public Builder brokerNodeGroupInfo(ClusterBrokerNodeGroupInfoArgs brokerNodeGroupInfo) {
            return brokerNodeGroupInfo(Output.of(brokerNodeGroupInfo));
        }

        /**
         * @param clientAuthentication Configuration block for specifying a client authentication. See below.
         * 
         * @return builder
         * 
         */
        public Builder clientAuthentication(@Nullable Output<ClusterClientAuthenticationArgs> clientAuthentication) {
            $.clientAuthentication = clientAuthentication;
            return this;
        }

        /**
         * @param clientAuthentication Configuration block for specifying a client authentication. See below.
         * 
         * @return builder
         * 
         */
        public Builder clientAuthentication(ClusterClientAuthenticationArgs clientAuthentication) {
            return clientAuthentication(Output.of(clientAuthentication));
        }

        /**
         * @param clusterName Name of the MSK cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterName(@Nullable Output<String> clusterName) {
            $.clusterName = clusterName;
            return this;
        }

        /**
         * @param clusterName Name of the MSK cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterName(String clusterName) {
            return clusterName(Output.of(clusterName));
        }

        /**
         * @param configurationInfo Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
         * 
         * @return builder
         * 
         */
        public Builder configurationInfo(@Nullable Output<ClusterConfigurationInfoArgs> configurationInfo) {
            $.configurationInfo = configurationInfo;
            return this;
        }

        /**
         * @param configurationInfo Configuration block for specifying a MSK Configuration to attach to Kafka brokers. See below.
         * 
         * @return builder
         * 
         */
        public Builder configurationInfo(ClusterConfigurationInfoArgs configurationInfo) {
            return configurationInfo(Output.of(configurationInfo));
        }

        /**
         * @param encryptionInfo Configuration block for specifying encryption. See below.
         * 
         * @return builder
         * 
         */
        public Builder encryptionInfo(@Nullable Output<ClusterEncryptionInfoArgs> encryptionInfo) {
            $.encryptionInfo = encryptionInfo;
            return this;
        }

        /**
         * @param encryptionInfo Configuration block for specifying encryption. See below.
         * 
         * @return builder
         * 
         */
        public Builder encryptionInfo(ClusterEncryptionInfoArgs encryptionInfo) {
            return encryptionInfo(Output.of(encryptionInfo));
        }

        /**
         * @param enhancedMonitoring Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
         * 
         * @return builder
         * 
         */
        public Builder enhancedMonitoring(@Nullable Output<String> enhancedMonitoring) {
            $.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        /**
         * @param enhancedMonitoring Specify the desired enhanced MSK CloudWatch monitoring level. See [Monitoring Amazon MSK with Amazon CloudWatch](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html)
         * 
         * @return builder
         * 
         */
        public Builder enhancedMonitoring(String enhancedMonitoring) {
            return enhancedMonitoring(Output.of(enhancedMonitoring));
        }

        /**
         * @param kafkaVersion Specify the desired Kafka software version.
         * 
         * @return builder
         * 
         */
        public Builder kafkaVersion(Output<String> kafkaVersion) {
            $.kafkaVersion = kafkaVersion;
            return this;
        }

        /**
         * @param kafkaVersion Specify the desired Kafka software version.
         * 
         * @return builder
         * 
         */
        public Builder kafkaVersion(String kafkaVersion) {
            return kafkaVersion(Output.of(kafkaVersion));
        }

        /**
         * @param loggingInfo Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
         * 
         * @return builder
         * 
         */
        public Builder loggingInfo(@Nullable Output<ClusterLoggingInfoArgs> loggingInfo) {
            $.loggingInfo = loggingInfo;
            return this;
        }

        /**
         * @param loggingInfo Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.
         * 
         * @return builder
         * 
         */
        public Builder loggingInfo(ClusterLoggingInfoArgs loggingInfo) {
            return loggingInfo(Output.of(loggingInfo));
        }

        /**
         * @param numberOfBrokerNodes The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
         * 
         * @return builder
         * 
         */
        public Builder numberOfBrokerNodes(Output<Integer> numberOfBrokerNodes) {
            $.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        /**
         * @param numberOfBrokerNodes The desired total number of broker nodes in the kafka cluster.  It must be a multiple of the number of specified client subnets.
         * 
         * @return builder
         * 
         */
        public Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            return numberOfBrokerNodes(Output.of(numberOfBrokerNodes));
        }

        /**
         * @param openMonitoring Configuration block for JMX and Node monitoring for the MSK cluster. See below.
         * 
         * @return builder
         * 
         */
        public Builder openMonitoring(@Nullable Output<ClusterOpenMonitoringArgs> openMonitoring) {
            $.openMonitoring = openMonitoring;
            return this;
        }

        /**
         * @param openMonitoring Configuration block for JMX and Node monitoring for the MSK cluster. See below.
         * 
         * @return builder
         * 
         */
        public Builder openMonitoring(ClusterOpenMonitoringArgs openMonitoring) {
            return openMonitoring(Output.of(openMonitoring));
        }

        /**
         * @param storageMode Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
         * 
         * @return builder
         * 
         */
        public Builder storageMode(@Nullable Output<String> storageMode) {
            $.storageMode = storageMode;
            return this;
        }

        /**
         * @param storageMode Controls storage mode for supported storage tiers. Valid values are: `LOCAL` or `TIERED`.
         * 
         * @return builder
         * 
         */
        public Builder storageMode(String storageMode) {
            return storageMode(Output.of(storageMode));
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public ClusterArgs build() {
            $.brokerNodeGroupInfo = Objects.requireNonNull($.brokerNodeGroupInfo, "expected parameter 'brokerNodeGroupInfo' to be non-null");
            $.kafkaVersion = Objects.requireNonNull($.kafkaVersion, "expected parameter 'kafkaVersion' to be non-null");
            $.numberOfBrokerNodes = Objects.requireNonNull($.numberOfBrokerNodes, "expected parameter 'numberOfBrokerNodes' to be non-null");
            return $;
        }
    }

}
