// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.mq.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BrokerUser {
    /**
     * @return Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
     * 
     */
    private @Nullable Boolean consoleAccess;
    /**
     * @return List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
     * 
     */
    private @Nullable List<String> groups;
    /**
     * @return Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
     * 
     */
    private String password;
    /**
     * @return Whether to set set replication user. Defaults to `false`.
     * 
     */
    private @Nullable Boolean replicationUser;
    /**
     * @return Username of the user.
     * 
     * &gt; **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
     * 
     */
    private String username;

    private BrokerUser() {}
    /**
     * @return Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
     * 
     */
    public Optional<Boolean> consoleAccess() {
        return Optional.ofNullable(this.consoleAccess);
    }
    /**
     * @return List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
     * 
     */
    public List<String> groups() {
        return this.groups == null ? List.of() : this.groups;
    }
    /**
     * @return Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
     * 
     */
    public String password() {
        return this.password;
    }
    /**
     * @return Whether to set set replication user. Defaults to `false`.
     * 
     */
    public Optional<Boolean> replicationUser() {
        return Optional.ofNullable(this.replicationUser);
    }
    /**
     * @return Username of the user.
     * 
     * &gt; **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
     * 
     */
    public String username() {
        return this.username;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BrokerUser defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Boolean consoleAccess;
        private @Nullable List<String> groups;
        private String password;
        private @Nullable Boolean replicationUser;
        private String username;
        public Builder() {}
        public Builder(BrokerUser defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.consoleAccess = defaults.consoleAccess;
    	      this.groups = defaults.groups;
    	      this.password = defaults.password;
    	      this.replicationUser = defaults.replicationUser;
    	      this.username = defaults.username;
        }

        @CustomType.Setter
        public Builder consoleAccess(@Nullable Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }
        @CustomType.Setter
        public Builder groups(@Nullable List<String> groups) {
            this.groups = groups;
            return this;
        }
        public Builder groups(String... groups) {
            return groups(List.of(groups));
        }
        @CustomType.Setter
        public Builder password(String password) {
            this.password = Objects.requireNonNull(password);
            return this;
        }
        @CustomType.Setter
        public Builder replicationUser(@Nullable Boolean replicationUser) {
            this.replicationUser = replicationUser;
            return this;
        }
        @CustomType.Setter
        public Builder username(String username) {
            this.username = Objects.requireNonNull(username);
            return this;
        }
        public BrokerUser build() {
            final var o = new BrokerUser();
            o.consoleAccess = consoleAccess;
            o.groups = groups;
            o.password = password;
            o.replicationUser = replicationUser;
            o.username = username;
            return o;
        }
    }
}
