// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.mq.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BrokerUserArgs extends com.pulumi.resources.ResourceArgs {

    public static final BrokerUserArgs Empty = new BrokerUserArgs();

    /**
     * Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
     * 
     */
    @Import(name="consoleAccess")
    private @Nullable Output<Boolean> consoleAccess;

    /**
     * @return Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
     * 
     */
    public Optional<Output<Boolean>> consoleAccess() {
        return Optional.ofNullable(this.consoleAccess);
    }

    /**
     * List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
     * 
     */
    @Import(name="groups")
    private @Nullable Output<List<String>> groups;

    /**
     * @return List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
     * 
     */
    public Optional<Output<List<String>>> groups() {
        return Optional.ofNullable(this.groups);
    }

    /**
     * Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
     * 
     */
    @Import(name="password", required=true)
    private Output<String> password;

    /**
     * @return Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
     * 
     */
    public Output<String> password() {
        return this.password;
    }

    /**
     * Whether to set set replication user. Defaults to `false`.
     * 
     */
    @Import(name="replicationUser")
    private @Nullable Output<Boolean> replicationUser;

    /**
     * @return Whether to set set replication user. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> replicationUser() {
        return Optional.ofNullable(this.replicationUser);
    }

    /**
     * Username of the user.
     * 
     * &gt; **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
     * 
     */
    @Import(name="username", required=true)
    private Output<String> username;

    /**
     * @return Username of the user.
     * 
     * &gt; **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
     * 
     */
    public Output<String> username() {
        return this.username;
    }

    private BrokerUserArgs() {}

    private BrokerUserArgs(BrokerUserArgs $) {
        this.consoleAccess = $.consoleAccess;
        this.groups = $.groups;
        this.password = $.password;
        this.replicationUser = $.replicationUser;
        this.username = $.username;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BrokerUserArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BrokerUserArgs $;

        public Builder() {
            $ = new BrokerUserArgs();
        }

        public Builder(BrokerUserArgs defaults) {
            $ = new BrokerUserArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param consoleAccess Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
         * 
         * @return builder
         * 
         */
        public Builder consoleAccess(@Nullable Output<Boolean> consoleAccess) {
            $.consoleAccess = consoleAccess;
            return this;
        }

        /**
         * @param consoleAccess Whether to enable access to the [ActiveMQ Web Console](http://activemq.apache.org/web-console.html) for the user. Applies to `engine_type` of `ActiveMQ` only.
         * 
         * @return builder
         * 
         */
        public Builder consoleAccess(Boolean consoleAccess) {
            return consoleAccess(Output.of(consoleAccess));
        }

        /**
         * @param groups List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
         * 
         * @return builder
         * 
         */
        public Builder groups(@Nullable Output<List<String>> groups) {
            $.groups = groups;
            return this;
        }

        /**
         * @param groups List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
         * 
         * @return builder
         * 
         */
        public Builder groups(List<String> groups) {
            return groups(Output.of(groups));
        }

        /**
         * @param groups List of groups (20 maximum) to which the ActiveMQ user belongs. Applies to `engine_type` of `ActiveMQ` only.
         * 
         * @return builder
         * 
         */
        public Builder groups(String... groups) {
            return groups(List.of(groups));
        }

        /**
         * @param password Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
         * 
         * @return builder
         * 
         */
        public Builder password(Output<String> password) {
            $.password = password;
            return this;
        }

        /**
         * @param password Password of the user. It must be 12 to 250 characters long, at least 4 unique characters, and must not contain commas.
         * 
         * @return builder
         * 
         */
        public Builder password(String password) {
            return password(Output.of(password));
        }

        /**
         * @param replicationUser Whether to set set replication user. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder replicationUser(@Nullable Output<Boolean> replicationUser) {
            $.replicationUser = replicationUser;
            return this;
        }

        /**
         * @param replicationUser Whether to set set replication user. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder replicationUser(Boolean replicationUser) {
            return replicationUser(Output.of(replicationUser));
        }

        /**
         * @param username Username of the user.
         * 
         * &gt; **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
         * 
         * @return builder
         * 
         */
        public Builder username(Output<String> username) {
            $.username = username;
            return this;
        }

        /**
         * @param username Username of the user.
         * 
         * &gt; **NOTE:** AWS currently does not support updating RabbitMQ users. Updates to users can only be in the RabbitMQ UI.
         * 
         * @return builder
         * 
         */
        public Builder username(String username) {
            return username(Output.of(username));
        }

        public BrokerUserArgs build() {
            $.password = Objects.requireNonNull($.password, "expected parameter 'password' to be non-null");
            $.username = Objects.requireNonNull($.username, "expected parameter 'username' to be non-null");
            return $;
        }
    }

}
