// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.memorydb;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.memorydb.ClusterArgs;
import com.pulumi.aws.memorydb.inputs.ClusterState;
import com.pulumi.aws.memorydb.outputs.ClusterClusterEndpoint;
import com.pulumi.aws.memorydb.outputs.ClusterShard;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a MemoryDB Cluster.
 * 
 * More information about MemoryDB can be found in the [Developer Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/what-is-memorydb-for-redis.html).
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.memorydb.Cluster;
 * import com.pulumi.aws.memorydb.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Cluster(&#34;example&#34;, ClusterArgs.builder()        
 *             .aclName(&#34;open-access&#34;)
 *             .nodeType(&#34;db.t4g.small&#34;)
 *             .numShards(2)
 *             .securityGroupIds(aws_security_group.example().id())
 *             .snapshotRetentionLimit(7)
 *             .subnetGroupName(aws_memorydb_subnet_group.example().id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import a cluster using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:memorydb/cluster:Cluster example my-cluster
 * ```
 * 
 */
@ResourceType(type="aws:memorydb/cluster:Cluster")
public class Cluster extends com.pulumi.resources.CustomResource {
    /**
     * The name of the Access Control List to associate with the cluster.
     * 
     */
    @Export(name="aclName", refs={String.class}, tree="[0]")
    private Output<String> aclName;

    /**
     * @return The name of the Access Control List to associate with the cluster.
     * 
     */
    public Output<String> aclName() {
        return this.aclName;
    }
    /**
     * The ARN of the cluster.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The ARN of the cluster.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * When set to `true`, the cluster will automatically receive minor engine version upgrades after launch. Defaults to `true`.
     * 
     */
    @Export(name="autoMinorVersionUpgrade", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> autoMinorVersionUpgrade;

    /**
     * @return When set to `true`, the cluster will automatically receive minor engine version upgrades after launch. Defaults to `true`.
     * 
     */
    public Output<Optional<Boolean>> autoMinorVersionUpgrade() {
        return Codegen.optional(this.autoMinorVersionUpgrade);
    }
    @Export(name="clusterEndpoints", refs={List.class,ClusterClusterEndpoint.class}, tree="[0,1]")
    private Output<List<ClusterClusterEndpoint>> clusterEndpoints;

    public Output<List<ClusterClusterEndpoint>> clusterEndpoints() {
        return this.clusterEndpoints;
    }
    /**
     * Enables data tiering. This option is not supported by all instance types. For more information, see [Data tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
     * 
     */
    @Export(name="dataTiering", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> dataTiering;

    /**
     * @return Enables data tiering. This option is not supported by all instance types. For more information, see [Data tiering](https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html).
     * 
     */
    public Output<Optional<Boolean>> dataTiering() {
        return Codegen.optional(this.dataTiering);
    }
    /**
     * Description for the cluster.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return Description for the cluster.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * Patch version number of the Redis engine used by the cluster.
     * 
     */
    @Export(name="enginePatchVersion", refs={String.class}, tree="[0]")
    private Output<String> enginePatchVersion;

    /**
     * @return Patch version number of the Redis engine used by the cluster.
     * 
     */
    public Output<String> enginePatchVersion() {
        return this.enginePatchVersion;
    }
    /**
     * Version number of the Redis engine to be used for the cluster. Downgrades are not supported.
     * 
     */
    @Export(name="engineVersion", refs={String.class}, tree="[0]")
    private Output<String> engineVersion;

    /**
     * @return Version number of the Redis engine to be used for the cluster. Downgrades are not supported.
     * 
     */
    public Output<String> engineVersion() {
        return this.engineVersion;
    }
    /**
     * Name of the final cluster snapshot to be created when this resource is deleted. If omitted, no final snapshot will be made.
     * 
     */
    @Export(name="finalSnapshotName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> finalSnapshotName;

    /**
     * @return Name of the final cluster snapshot to be created when this resource is deleted. If omitted, no final snapshot will be made.
     * 
     */
    public Output<Optional<String>> finalSnapshotName() {
        return Codegen.optional(this.finalSnapshotName);
    }
    /**
     * ARN of the KMS key used to encrypt the cluster at rest.
     * 
     */
    @Export(name="kmsKeyArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> kmsKeyArn;

    /**
     * @return ARN of the KMS key used to encrypt the cluster at rest.
     * 
     */
    public Output<Optional<String>> kmsKeyArn() {
        return Codegen.optional(this.kmsKeyArn);
    }
    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed. Specify as a range in the format `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:23:00-mon:01:30`.
     * 
     */
    @Export(name="maintenanceWindow", refs={String.class}, tree="[0]")
    private Output<String> maintenanceWindow;

    /**
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. Specify as a range in the format `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:23:00-mon:01:30`.
     * 
     */
    public Output<String> maintenanceWindow() {
        return this.maintenanceWindow;
    }
    /**
     * Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the cluster. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     * 
     */
    @Export(name="namePrefix", refs={String.class}, tree="[0]")
    private Output<String> namePrefix;

    /**
     * @return Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     * 
     */
    public Output<String> namePrefix() {
        return this.namePrefix;
    }
    /**
     * The compute and memory capacity of the nodes in the cluster. See AWS documentation on [supported node types](https://docs.aws.amazon.com/memorydb/latest/devguide/nodes.supportedtypes.html) as well as [vertical scaling](https://docs.aws.amazon.com/memorydb/latest/devguide/cluster-vertical-scaling.html).
     * 
     * The following arguments are optional:
     * 
     */
    @Export(name="nodeType", refs={String.class}, tree="[0]")
    private Output<String> nodeType;

    /**
     * @return The compute and memory capacity of the nodes in the cluster. See AWS documentation on [supported node types](https://docs.aws.amazon.com/memorydb/latest/devguide/nodes.supportedtypes.html) as well as [vertical scaling](https://docs.aws.amazon.com/memorydb/latest/devguide/cluster-vertical-scaling.html).
     * 
     * The following arguments are optional:
     * 
     */
    public Output<String> nodeType() {
        return this.nodeType;
    }
    /**
     * The number of replicas to apply to each shard, up to a maximum of 5. Defaults to `1` (i.e. 2 nodes per shard).
     * 
     */
    @Export(name="numReplicasPerShard", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> numReplicasPerShard;

    /**
     * @return The number of replicas to apply to each shard, up to a maximum of 5. Defaults to `1` (i.e. 2 nodes per shard).
     * 
     */
    public Output<Optional<Integer>> numReplicasPerShard() {
        return Codegen.optional(this.numReplicasPerShard);
    }
    /**
     * The number of shards in the cluster. Defaults to `1`.
     * 
     */
    @Export(name="numShards", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> numShards;

    /**
     * @return The number of shards in the cluster. Defaults to `1`.
     * 
     */
    public Output<Optional<Integer>> numShards() {
        return Codegen.optional(this.numShards);
    }
    /**
     * The name of the parameter group associated with the cluster.
     * 
     */
    @Export(name="parameterGroupName", refs={String.class}, tree="[0]")
    private Output<String> parameterGroupName;

    /**
     * @return The name of the parameter group associated with the cluster.
     * 
     */
    public Output<String> parameterGroupName() {
        return this.parameterGroupName;
    }
    /**
     * The port number on which each of the nodes accepts connections. Defaults to `6379`.
     * 
     */
    @Export(name="port", refs={Integer.class}, tree="[0]")
    private Output<Integer> port;

    /**
     * @return The port number on which each of the nodes accepts connections. Defaults to `6379`.
     * 
     */
    public Output<Integer> port() {
        return this.port;
    }
    /**
     * Set of VPC Security Group ID-s to associate with this cluster.
     * 
     */
    @Export(name="securityGroupIds", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> securityGroupIds;

    /**
     * @return Set of VPC Security Group ID-s to associate with this cluster.
     * 
     */
    public Output<Optional<List<String>>> securityGroupIds() {
        return Codegen.optional(this.securityGroupIds);
    }
    /**
     * Set of shards in this cluster.
     * 
     */
    @Export(name="shards", refs={List.class,ClusterShard.class}, tree="[0,1]")
    private Output<List<ClusterShard>> shards;

    /**
     * @return Set of shards in this cluster.
     * 
     */
    public Output<List<ClusterShard>> shards() {
        return this.shards;
    }
    /**
     * List of ARN-s that uniquely identify RDB snapshot files stored in S3. The snapshot files will be used to populate the new cluster. Object names in the ARN-s cannot contain any commas.
     * 
     */
    @Export(name="snapshotArns", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> snapshotArns;

    /**
     * @return List of ARN-s that uniquely identify RDB snapshot files stored in S3. The snapshot files will be used to populate the new cluster. Object names in the ARN-s cannot contain any commas.
     * 
     */
    public Output<Optional<List<String>>> snapshotArns() {
        return Codegen.optional(this.snapshotArns);
    }
    /**
     * The name of a snapshot from which to restore data into the new cluster.
     * 
     */
    @Export(name="snapshotName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> snapshotName;

    /**
     * @return The name of a snapshot from which to restore data into the new cluster.
     * 
     */
    public Output<Optional<String>> snapshotName() {
        return Codegen.optional(this.snapshotName);
    }
    /**
     * The number of days for which MemoryDB retains automatic snapshots before deleting them. When set to `0`, automatic backups are disabled. Defaults to `0`.
     * 
     */
    @Export(name="snapshotRetentionLimit", refs={Integer.class}, tree="[0]")
    private Output<Integer> snapshotRetentionLimit;

    /**
     * @return The number of days for which MemoryDB retains automatic snapshots before deleting them. When set to `0`, automatic backups are disabled. Defaults to `0`.
     * 
     */
    public Output<Integer> snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }
    /**
     * The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: `05:00-09:00`.
     * 
     */
    @Export(name="snapshotWindow", refs={String.class}, tree="[0]")
    private Output<String> snapshotWindow;

    /**
     * @return The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: `05:00-09:00`.
     * 
     */
    public Output<String> snapshotWindow() {
        return this.snapshotWindow;
    }
    /**
     * ARN of the SNS topic to which cluster notifications are sent.
     * 
     */
    @Export(name="snsTopicArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> snsTopicArn;

    /**
     * @return ARN of the SNS topic to which cluster notifications are sent.
     * 
     */
    public Output<Optional<String>> snsTopicArn() {
        return Codegen.optional(this.snsTopicArn);
    }
    /**
     * The name of the subnet group to be used for the cluster. Defaults to a subnet group consisting of default VPC subnets.
     * 
     */
    @Export(name="subnetGroupName", refs={String.class}, tree="[0]")
    private Output<String> subnetGroupName;

    /**
     * @return The name of the subnet group to be used for the cluster. Defaults to a subnet group consisting of default VPC subnets.
     * 
     */
    public Output<String> subnetGroupName() {
        return this.subnetGroupName;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * A flag to enable in-transit encryption on the cluster. When set to `false`, the `acl_name` must be `open-access`. Defaults to `true`.
     * 
     */
    @Export(name="tlsEnabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> tlsEnabled;

    /**
     * @return A flag to enable in-transit encryption on the cluster. When set to `false`, the `acl_name` must be `open-access`. Defaults to `true`.
     * 
     */
    public Output<Optional<Boolean>> tlsEnabled() {
        return Codegen.optional(this.tlsEnabled);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Cluster(String name) {
        this(name, ClusterArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Cluster(String name, ClusterArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Cluster(String name, ClusterArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:memorydb/cluster:Cluster", name, args == null ? ClusterArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Cluster(String name, Output<String> id, @Nullable ClusterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:memorydb/cluster:Cluster", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Cluster get(String name, Output<String> id, @Nullable ClusterState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Cluster(name, id, state, options);
    }
}
