// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.mediastore;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.mediastore.ContainerPolicyArgs;
import com.pulumi.aws.mediastore.inputs.ContainerPolicyState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a MediaStore Container Policy.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.mediastore.Container;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.mediastore.ContainerPolicy;
 * import com.pulumi.aws.mediastore.ContainerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var currentRegion = AwsFunctions.getRegion();
 * 
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 * 
 *         var exampleContainer = new Container(&#34;exampleContainer&#34;);
 * 
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid(&#34;MediaStoreFullAccess&#34;)
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;AWS&#34;)
 *                     .identifiers(String.format(&#34;arn:aws:iam::%s:root&#34;, currentCallerIdentity.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions(&#34;mediastore:*&#34;)
 *                 .resources(exampleContainer.name().applyValue(name -&gt; String.format(&#34;arn:aws:mediastore:%s:%s:container/%s/*&#34;, currentRegion.applyValue(getRegionResult -&gt; getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -&gt; getCallerIdentityResult.accountId()),name)))
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test(&#34;Bool&#34;)
 *                     .variable(&#34;aws:SecureTransport&#34;)
 *                     .values(&#34;true&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *         var exampleContainerPolicy = new ContainerPolicy(&#34;exampleContainerPolicy&#34;, ContainerPolicyArgs.builder()        
 *             .containerName(exampleContainer.name())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(examplePolicyDocument -&gt; examplePolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import MediaStore Container Policy using the MediaStore Container Name. For example:
 * 
 * ```sh
 *  $ pulumi import aws:mediastore/containerPolicy:ContainerPolicy example example
 * ```
 * 
 */
@ResourceType(type="aws:mediastore/containerPolicy:ContainerPolicy")
public class ContainerPolicy extends com.pulumi.resources.CustomResource {
    /**
     * The name of the container.
     * 
     */
    @Export(name="containerName", refs={String.class}, tree="[0]")
    private Output<String> containerName;

    /**
     * @return The name of the container.
     * 
     */
    public Output<String> containerName() {
        return this.containerName;
    }
    /**
     * The contents of the policy.
     * 
     */
    @Export(name="policy", refs={String.class}, tree="[0]")
    private Output<String> policy;

    /**
     * @return The contents of the policy.
     * 
     */
    public Output<String> policy() {
        return this.policy;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ContainerPolicy(String name) {
        this(name, ContainerPolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ContainerPolicy(String name, ContainerPolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ContainerPolicy(String name, ContainerPolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:mediastore/containerPolicy:ContainerPolicy", name, args == null ? ContainerPolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ContainerPolicy(String name, Output<String> id, @Nullable ContainerPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:mediastore/containerPolicy:ContainerPolicy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ContainerPolicy get(String name, Output<String> id, @Nullable ContainerPolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ContainerPolicy(name, id, state, options);
    }
}
